/*
 * Decompiled with CFR 0.152.
 */
package com.github.mvysny.fakeservlet;

import com.github.mvysny.fakeservlet.FakeHttpEnvironment;
import com.github.mvysny.fakeservlet.FakeHttpEnvironmentKt;
import jakarta.servlet.ServletContext;
import jakarta.servlet.http.HttpSession;
import jakarta.servlet.http.HttpSessionContext;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u000f\b\u0016\u0018\u0000 52\u00020\u00012\u00020\u0002:\u00015B'\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0004\b\u000b\u0010\fB\u0011\b\u0016\u0012\u0006\u0010\r\u001a\u00020\u0001\u00a2\u0006\u0004\b\u000b\u0010\u000eJ\u0006\u0010\u0016\u001a\u00020\u0017J\b\u0010\u0018\u001a\u00020\bH\u0016J\b\u0010\u0019\u001a\u00020\u0004H\u0016J\b\u0010\u001a\u001a\u00020\bH\u0016J\b\u0010\u001b\u001a\u00020\u0006H\u0016J\u0010\u0010\u001c\u001a\u00020\u00172\u0006\u0010\u001d\u001a\u00020\nH\u0016J\b\u0010\u001e\u001a\u00020\nH\u0016J\n\u0010\u001f\u001a\u0004\u0018\u00010 H\u0017J\u0012\u0010!\u001a\u0004\u0018\u00010\u00112\u0006\u0010\"\u001a\u00020\u0004H\u0016J\u0012\u0010#\u001a\u0004\u0018\u00010\u00112\u0006\u0010\"\u001a\u00020\u0004H\u0017J\u000e\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00040%H\u0016J\u0013\u0010&\u001a\b\u0012\u0004\u0012\u00020\u00040'H\u0017\u00a2\u0006\u0002\u0010(J\u001a\u0010)\u001a\u00020\u00172\u0006\u0010\"\u001a\u00020\u00042\b\u0010*\u001a\u0004\u0018\u00010\u0011H\u0016J\u001a\u0010+\u001a\u00020\u00172\u0006\u0010\"\u001a\u00020\u00042\b\u0010*\u001a\u0004\u0018\u00010\u0011H\u0017J\u0010\u0010,\u001a\u00020\u00172\u0006\u0010\"\u001a\u00020\u0004H\u0016J\u0010\u0010-\u001a\u00020\u00172\u0006\u0010\"\u001a\u00020\u0004H\u0017J\u000e\u0010.\u001a\u00020\u00002\u0006\u0010/\u001a\u00020\u0001J\b\u00100\u001a\u00020\u0017H\u0016J\b\u00101\u001a\u00020\u0013H\u0016J\b\u00102\u001a\u00020\u0017H\u0002J\b\u00103\u001a\u00020\u0004H\u0016J\u0006\u00104\u001a\u00020\u0004R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00110\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0014\u001a\u00020\u00138F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015\u00a8\u00066"}, d2={"Lcom/github/mvysny/fakeservlet/FakeHttpSession;", "Ljakarta/servlet/http/HttpSession;", "Ljava/io/Serializable;", "sessionId", "", "servletContext", "Ljakarta/servlet/ServletContext;", "creationTime", "", "maxInactiveInterval", "", "<init>", "(Ljava/lang/String;Ljakarta/servlet/ServletContext;JI)V", "session", "(Ljakarta/servlet/http/HttpSession;)V", "attributes", "Ljava/util/concurrent/ConcurrentHashMap;", "", "valid", "", "isValid", "()Z", "destroy", "", "getCreationTime", "getId", "getLastAccessedTime", "getServletContext", "setMaxInactiveInterval", "interval", "getMaxInactiveInterval", "getSessionContext", "Ljakarta/servlet/http/HttpSessionContext;", "getAttribute", "name", "getValue", "getAttributeNames", "Ljava/util/Enumeration;", "getValueNames", "", "()[Ljava/lang/String;", "setAttribute", "value", "putValue", "removeAttribute", "removeValue", "copyAttributes", "httpSession", "invalidate", "isNew", "checkValid", "toString", "changeSessionId", "Companion", "fake-servlet5"})
@SourceDebugExtension(value={"SMAP\nFakeHttpSession.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FakeHttpSession.kt\ncom/github/mvysny/fakeservlet/FakeHttpSession\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,151:1\n37#2:152\n36#2,3:153\n1863#3,2:156\n*S KotlinDebug\n*F\n+ 1 FakeHttpSession.kt\ncom/github/mvysny/fakeservlet/FakeHttpSession\n*L\n80#1:152\n80#1:153,3\n109#1:156,2\n*E\n"})
public class FakeHttpSession
implements HttpSession,
Serializable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private String sessionId;
    @NotNull
    private final ServletContext servletContext;
    private final long creationTime;
    private int maxInactiveInterval;
    @NotNull
    private final ConcurrentHashMap<String, Object> attributes;
    private volatile boolean valid;
    @NotNull
    private static final AtomicInteger sessionIdGenerator = new AtomicInteger();

    public FakeHttpSession(@NotNull String sessionId, @NotNull ServletContext servletContext, long creationTime, int maxInactiveInterval) {
        Intrinsics.checkNotNullParameter((Object)sessionId, (String)"sessionId");
        Intrinsics.checkNotNullParameter((Object)servletContext, (String)"servletContext");
        this.sessionId = sessionId;
        this.servletContext = servletContext;
        this.creationTime = creationTime;
        this.maxInactiveInterval = maxInactiveInterval;
        this.attributes = new ConcurrentHashMap();
        this.valid = true;
    }

    public final boolean isValid() {
        return this.valid;
    }

    public FakeHttpSession(@NotNull HttpSession session) {
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        String string = session.getId();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getId(...)");
        ServletContext servletContext = session.getServletContext();
        Intrinsics.checkNotNullExpressionValue((Object)servletContext, (String)"getServletContext(...)");
        this(string, servletContext, session.getLastAccessedTime(), session.getMaxInactiveInterval());
        this.copyAttributes(session);
    }

    public final void destroy() {
        this.attributes.clear();
    }

    public long getCreationTime() {
        this.checkValid();
        return this.creationTime;
    }

    @NotNull
    public String getId() {
        return this.sessionId;
    }

    public long getLastAccessedTime() {
        this.checkValid();
        return 0L;
    }

    @NotNull
    public ServletContext getServletContext() {
        return this.servletContext;
    }

    public void setMaxInactiveInterval(int interval) {
        this.maxInactiveInterval = interval;
    }

    public int getMaxInactiveInterval() {
        return this.maxInactiveInterval;
    }

    @Deprecated(message="Deprecated in Java")
    @Nullable
    public HttpSessionContext getSessionContext() {
        return null;
    }

    @Nullable
    public Object getAttribute(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        this.checkValid();
        return this.attributes.get(name);
    }

    @Deprecated(message="Deprecated in Java")
    @Nullable
    public Object getValue(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return this.getAttribute(name);
    }

    @NotNull
    public Enumeration<String> getAttributeNames() {
        this.checkValid();
        Enumeration<String> enumeration = this.attributes.keys();
        Intrinsics.checkNotNullExpressionValue(enumeration, (String)"keys(...)");
        return enumeration;
    }

    @Deprecated(message="Deprecated in Java")
    @NotNull
    public String[] getValueNames() {
        ArrayList<String> arrayList = Collections.list(this.getAttributeNames());
        Intrinsics.checkNotNullExpressionValue(arrayList, (String)"list(...)");
        Collection $this$toTypedArray$iv = arrayList;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        return thisCollection$iv.toArray(new String[0]);
    }

    public void setAttribute(@NotNull String name, @Nullable Object value) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        this.checkValid();
        FakeHttpEnvironmentKt.putOrRemove(this.attributes, name, value);
    }

    @Deprecated(message="Deprecated in Java")
    public void putValue(@NotNull String name, @Nullable Object value) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        this.setAttribute(name, value);
    }

    public void removeAttribute(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        this.checkValid();
        this.attributes.remove(name);
    }

    @Deprecated(message="Deprecated in Java")
    public void removeValue(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        this.removeAttribute(name);
    }

    @NotNull
    public final FakeHttpSession copyAttributes(@NotNull HttpSession httpSession) {
        Intrinsics.checkNotNullParameter((Object)httpSession, (String)"httpSession");
        Enumeration enumeration = httpSession.getAttributeNames();
        Intrinsics.checkNotNullExpressionValue((Object)enumeration, (String)"getAttributeNames(...)");
        ArrayList arrayList = Collections.list(enumeration);
        Intrinsics.checkNotNullExpressionValue(arrayList, (String)"list(...)");
        Iterable $this$forEach$iv = arrayList;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String it = (String)element$iv;
            boolean bl = false;
            ((Map)this.attributes).put(it, httpSession.getAttribute(it));
        }
        return this;
    }

    public void invalidate() {
        this.checkValid();
        this.valid = false;
    }

    public boolean isNew() {
        this.checkValid();
        return false;
    }

    private final void checkValid() {
        if (!this.isValid() && FakeHttpEnvironment.INSTANCE.getStrictSessionValidityChecks()) {
            throw new IllegalStateException("invalidated: " + this);
        }
    }

    @NotNull
    public String toString() {
        return "MockHttpSession(sessionId='" + this.sessionId + "', creationTime=" + this.creationTime + ", maxInactiveInterval=" + this.maxInactiveInterval + ", attributes=" + this.attributes + ", isValid=" + this.isValid() + ')';
    }

    @NotNull
    public final String changeSessionId() {
        this.sessionId = FakeHttpSession.Companion.generateSessionId();
        return this.sessionId;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ\b\u0010\n\u001a\u00020\u000bH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/github/mvysny/fakeservlet/FakeHttpSession$Companion;", "", "<init>", "()V", "sessionIdGenerator", "Ljava/util/concurrent/atomic/AtomicInteger;", "create", "Lcom/github/mvysny/fakeservlet/FakeHttpSession;", "ctx", "Ljakarta/servlet/ServletContext;", "generateSessionId", "", "fake-servlet5"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final FakeHttpSession create(@NotNull ServletContext ctx) {
            Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
            return new FakeHttpSession(this.generateSessionId(), ctx, System.currentTimeMillis(), 30);
        }

        private final String generateSessionId() {
            return String.valueOf(sessionIdGenerator.incrementAndGet());
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

