/*
 * Decompiled with CFR 0.152.
 */
package com.github.mvysny.kaributesting.v10;

import com.github.mvysny.kaributesting.v10.SemanticVersion;
import com.github.mvysny.kaributesting.v10.mock.MockVaadinHelper;
import com.vaadin.flow.component.dependency.NpmPackage;
import com.vaadin.flow.server.Version;
import com.vaadin.shrinkwrap.VaadinCoreShrinkWrap;
import elemental.json.JsonObject;
import java.net.URL;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0014\u001a\u00020\u0015H\u0002R\u0013\u0010\u0003\u001a\u0004\u0018\u00010\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0011\u0010\u000b\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\nR\u0011\u0010\r\u001a\u00020\u000e8F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000fR\u0011\u0010\u0010\u001a\u00020\u00118F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u0016"}, d2={"Lcom/github/mvysny/kaributesting/v10/VaadinMeta;", "", "()V", "flowBuildInfo", "Lelemental/json/JsonObject;", "getFlowBuildInfo", "()Lelemental/json/JsonObject;", "flowVersion", "Lcom/github/mvysny/kaributesting/v10/SemanticVersion;", "getFlowVersion", "()Lcom/github/mvysny/kaributesting/v10/SemanticVersion;", "fullVersion", "getFullVersion", "isCompatibilityMode", "", "()Z", "version", "", "getVersion", "()I", "checkNotVaadin14CompatMode", "", "karibu-testing-v10"})
public final class VaadinMeta {
    @NotNull
    public static final VaadinMeta INSTANCE;

    @NotNull
    public final SemanticVersion getFlowVersion() {
        return new SemanticVersion(Version.getMajorVersion(), Version.getMinorVersion(), Version.getRevision(), null, 8, null);
    }

    public final int getVersion() {
        return this.getFullVersion().getMajor();
    }

    @NotNull
    public final SemanticVersion getFullVersion() {
        NpmPackage npmPackage = VaadinCoreShrinkWrap.class.getAnnotation(NpmPackage.class);
        boolean bl = false;
        boolean bl2 = false;
        if (npmPackage == null) {
            boolean bl3 = false;
            String string = "Karibu-Testing 1.2.x only supports Vaadin 14 and higher";
            throw (Throwable)new IllegalStateException(string.toString());
        }
        NpmPackage annotation = npmPackage;
        String version = annotation.version();
        return SemanticVersion.Companion.fromString(version);
    }

    @Nullable
    public final JsonObject getFlowBuildInfo() {
        return MockVaadinHelper.INSTANCE.getTokenFileFromClassloader();
    }

    public final boolean isCompatibilityMode() {
        boolean bl = this.getFullVersion().compareTo(SemanticVersion.Companion.getVAADIN_14_3_0()) >= 0;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "Karibu-Testing 1.2.x is only compatible with Vaadin " + SemanticVersion.Companion.getVAADIN_14_3_0() + " and above, but got " + INSTANCE.getVersion();
            throw (Throwable)new IllegalStateException(string.toString());
        }
        if (this.getVersion() == 14) {
            this.checkNotVaadin14CompatMode();
        }
        return false;
    }

    private final void checkNotVaadin14CompatMode() {
        boolean bl;
        boolean bl2;
        String error = "Karibu-Testing 1.2.x doesn't support Vaadin 14 Compatibility mode; please use Karibu-Testing 1.1.x instead. Alternatively, if you're not using compatibility mode, please exclude all webjars from your vaadin/vaadin-core dependency; please see the Skeleton Starter or Karibu10-helloworld-app on how to do that.";
        JsonObject fbi = this.getFlowBuildInfo();
        if (fbi != null) {
            boolean bl3 = !fbi.getBoolean("compatibilityMode");
            bl2 = false;
            bl = false;
            if (!bl3) {
                boolean bl4 = false;
                String string = "flow-build-info.json is set to compatibility mode: " + fbi + ". " + error;
                throw (Throwable)new IllegalStateException(string.toString());
            }
        }
        Thread thread = Thread.currentThread();
        Intrinsics.checkNotNullExpressionValue((Object)thread, (String)"Thread.currentThread()");
        URL polymerHtml = thread.getContextClassLoader().getResource("META-INF/resources/webjars/polymer/polymer.html");
        bl2 = polymerHtml == null;
        bl = false;
        boolean bl5 = false;
        if (!bl2) {
            boolean bl6 = false;
            String string = "Polymer 3 webjar is on the classpath, indicating compatibility mode: " + polymerHtml + ". " + error;
            throw (Throwable)new IllegalStateException(string.toString());
        }
    }

    private VaadinMeta() {
    }

    static {
        VaadinMeta vaadinMeta;
        INSTANCE = vaadinMeta = new VaadinMeta();
    }
}

