/*
 * Decompiled with CFR 0.152.
 */
package com.github.mvysny.kaributesting.v10;

import com.github.mvysny.kaributesting.v10.SemanticVersion;
import kotlin.Metadata;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u000f\n\u0002\u0010\u000b\n\u0002\u0010\u0000\n\u0002\b\u0006\b\u0086\b\u0018\u0000 \u001d2\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001\u001dB)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\bJ\u0011\u0010\u000f\u001a\u00020\u00032\u0006\u0010\u0010\u001a\u00020\u0000H\u0096\u0002J\t\u0010\u0011\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0012\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0013\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\u0014\u001a\u0004\u0018\u00010\u0007H\u00c6\u0003J3\u0010\u0015\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00032\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u00c6\u0001J\u0013\u0010\u0016\u001a\u00020\u00172\b\u0010\u0010\u001a\u0004\u0018\u00010\u0018H\u00d6\u0003J\t\u0010\u0019\u001a\u00020\u0003H\u00d6\u0001J\u000e\u0010\u001a\u001a\u00020\u00172\u0006\u0010\u0002\u001a\u00020\u0003J\u0016\u0010\u001a\u001a\u00020\u00172\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0003J\u000e\u0010\u001b\u001a\u00020\u00172\u0006\u0010\u0002\u001a\u00020\u0003J\u0016\u0010\u001b\u001a\u00020\u00172\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0003J\b\u0010\u001c\u001a\u00020\u0007H\u0016R\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\nR\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u001e"}, d2={"Lcom/github/mvysny/kaributesting/v10/SemanticVersion;", "", "major", "", "minor", "bugfix", "prerelease", "", "(IIILjava/lang/String;)V", "getBugfix", "()I", "getMajor", "getMinor", "getPrerelease", "()Ljava/lang/String;", "compareTo", "other", "component1", "component2", "component3", "component4", "copy", "equals", "", "", "hashCode", "isAtLeast", "isExactly", "toString", "Companion", "karibu-testing-v10"})
public final class SemanticVersion
implements Comparable<SemanticVersion> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int major;
    private final int minor;
    private final int bugfix;
    @Nullable
    private final String prerelease;
    @NotNull
    private static final Regex VERSION_REGEX = new Regex("(\\d+)\\.(\\d+)\\.(\\d+)([-.](.*))?");
    @NotNull
    private static final SemanticVersion VAADIN_14_3_0 = new SemanticVersion(14, 3, 0, null, 8, null);
    @NotNull
    private static final SemanticVersion VAADIN_14_4_0 = new SemanticVersion(14, 4, 0, null, 8, null);
    @NotNull
    private static final SemanticVersion VAADIN_14_5_0 = new SemanticVersion(14, 5, 0, null, 8, null);

    public SemanticVersion(int major, int minor, int bugfix, @Nullable String prerelease) {
        this.major = major;
        this.minor = minor;
        this.bugfix = bugfix;
        this.prerelease = prerelease;
        if (this.prerelease != null) {
            CharSequence charSequence = this.prerelease;
            boolean bl = false;
            boolean bl2 = !StringsKt.isBlank((CharSequence)charSequence);
            bl = false;
            boolean bl3 = false;
            if (!bl2) {
                boolean bl4 = false;
                String string = Intrinsics.stringPlus((String)this.getPrerelease(), (Object)" is blank");
                throw (Throwable)new IllegalArgumentException(string.toString());
            }
            bl2 = !StringsKt.startsWith$default((CharSequence)this.prerelease, (char)'-', (boolean)false, (int)2, null);
            bl = false;
            bl3 = false;
            if (!bl2) {
                boolean bl5 = false;
                String string = Intrinsics.stringPlus((String)this.getPrerelease(), (Object)" starts with a dash");
                throw (Throwable)new IllegalArgumentException(string.toString());
            }
        }
    }

    public /* synthetic */ SemanticVersion(int n, int n2, int n3, String string, int n4, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n4 & 8) != 0) {
            string = null;
        }
        this(n, n2, n3, string);
    }

    public final int getMajor() {
        return this.major;
    }

    public final int getMinor() {
        return this.minor;
    }

    public final int getBugfix() {
        return this.bugfix;
    }

    @Nullable
    public final String getPrerelease() {
        return this.prerelease;
    }

    @Override
    public int compareTo(@NotNull SemanticVersion other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        Function1[] function1Array = new Function1[]{compareTo.1.INSTANCE, compareTo.2.INSTANCE, compareTo.3.INSTANCE, compareTo.4.INSTANCE};
        return ComparisonsKt.compareValuesBy((Object)this, (Object)other, (Function1[])function1Array);
    }

    @NotNull
    public String toString() {
        return "" + this.major + '.' + this.minor + '.' + this.bugfix + (this.prerelease != null ? Intrinsics.stringPlus((String)"-", (Object)this.prerelease) : "");
    }

    public final boolean isExactly(int major, int minor) {
        return this.major == major && this.minor == minor;
    }

    public final boolean isExactly(int major) {
        return this.major == major;
    }

    public final boolean isAtLeast(int major, int minor) {
        return this.compareTo(new SemanticVersion(major, minor, 0, "\u0001")) >= 0;
    }

    public final boolean isAtLeast(int major) {
        return this.major >= major;
    }

    public final int component1() {
        return this.major;
    }

    public final int component2() {
        return this.minor;
    }

    public final int component3() {
        return this.bugfix;
    }

    @Nullable
    public final String component4() {
        return this.prerelease;
    }

    @NotNull
    public final SemanticVersion copy(int major, int minor, int bugfix, @Nullable String prerelease) {
        return new SemanticVersion(major, minor, bugfix, prerelease);
    }

    public static /* synthetic */ SemanticVersion copy$default(SemanticVersion semanticVersion, int n, int n2, int n3, String string, int n4, Object object) {
        if ((n4 & 1) != 0) {
            n = semanticVersion.major;
        }
        if ((n4 & 2) != 0) {
            n2 = semanticVersion.minor;
        }
        if ((n4 & 4) != 0) {
            n3 = semanticVersion.bugfix;
        }
        if ((n4 & 8) != 0) {
            string = semanticVersion.prerelease;
        }
        return semanticVersion.copy(n, n2, n3, string);
    }

    public int hashCode() {
        int result2 = Integer.hashCode(this.major);
        result2 = result2 * 31 + Integer.hashCode(this.minor);
        result2 = result2 * 31 + Integer.hashCode(this.bugfix);
        result2 = result2 * 31 + (this.prerelease == null ? 0 : this.prerelease.hashCode());
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof SemanticVersion)) {
            return false;
        }
        SemanticVersion semanticVersion = (SemanticVersion)other;
        if (this.major != semanticVersion.major) {
            return false;
        }
        if (this.minor != semanticVersion.minor) {
            return false;
        }
        if (this.bugfix != semanticVersion.bugfix) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.prerelease, (Object)semanticVersion.prerelease);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\r\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u000fR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006R\u0011\u0010\t\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u0006R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/github/mvysny/kaributesting/v10/SemanticVersion$Companion;", "", "()V", "VAADIN_14_3_0", "Lcom/github/mvysny/kaributesting/v10/SemanticVersion;", "getVAADIN_14_3_0", "()Lcom/github/mvysny/kaributesting/v10/SemanticVersion;", "VAADIN_14_4_0", "getVAADIN_14_4_0", "VAADIN_14_5_0", "getVAADIN_14_5_0", "VERSION_REGEX", "Lkotlin/text/Regex;", "fromString", "version", "", "karibu-testing-v10"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final SemanticVersion fromString(@NotNull String version) {
            void it;
            Intrinsics.checkNotNullParameter((Object)version, (String)"version");
            Object object = VERSION_REGEX.matchEntire((CharSequence)version);
            boolean bl = false;
            boolean bl2 = false;
            if (object == null) {
                boolean bl3 = false;
                String string = Intrinsics.stringPlus((String)"The version must be in the form of major.minor.bugfix but is ", (Object)version);
                throw (Throwable)new IllegalArgumentException(string.toString());
            }
            MatchResult match = object;
            object = (String)match.getGroupValues().get(1);
            bl = false;
            int n = Integer.parseInt((String)object);
            object = (String)match.getGroupValues().get(2);
            bl = false;
            int n2 = Integer.parseInt((String)object);
            object = (String)match.getGroupValues().get(3);
            bl = false;
            int n3 = Integer.parseInt((String)object);
            object = match.getGroupValues().get(5);
            bl = false;
            bl2 = false;
            String bl3 = (String)object;
            int n4 = n3;
            int n5 = n2;
            int n6 = n;
            boolean bl4 = false;
            CharSequence charSequence = (CharSequence)it;
            boolean bl5 = false;
            boolean bl6 = !StringsKt.isBlank((CharSequence)charSequence);
            String string = (String)(bl6 ? object : null);
            int n7 = n4;
            int n8 = n5;
            int n9 = n6;
            return new SemanticVersion(n9, n8, n7, string);
        }

        @NotNull
        public final SemanticVersion getVAADIN_14_3_0() {
            return VAADIN_14_3_0;
        }

        @NotNull
        public final SemanticVersion getVAADIN_14_4_0() {
            return VAADIN_14_4_0;
        }

        @NotNull
        public final SemanticVersion getVAADIN_14_5_0() {
            return VAADIN_14_5_0;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

