/*
 * Decompiled with CFR 0.152.
 */
package com.github.mvysny.kaributesting.v10;

import com.github.mvysny.kaributesting.v10.GridKt;
import com.github.mvysny.kaributesting.v10.PrettyPrintTreeKt;
import com.github.mvysny.kaributesting.v10.RenderersKt;
import com.github.mvysny.kaributesting.v10.UtilsKt;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ironlist.IronList;
import com.vaadin.flow.data.provider.DataProvider;
import com.vaadin.flow.data.provider.Query;
import com.vaadin.flow.data.renderer.Renderer;
import java.lang.reflect.Field;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.stream.Stream;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import kotlin.streams.jdk8.StreamsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u00006\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\u0004\u001a&\u0010\u0006\u001a\u00020\u0007\"\b\b\u0000\u0010\u0002*\u00020\b*\b\u0012\u0004\u0012\u0002H\u00020\u00032\b\b\u0002\u0010\t\u001a\u00020\nH\u0007\u001a,\u0010\u000b\u001a\b\u0012\u0004\u0012\u0002H\u00020\f\"\u0004\b\u0000\u0010\u0002*\b\u0012\u0004\u0012\u0002H\u00020\u00032\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000e\u001a\u001c\u0010\u0010\u001a\b\u0012\u0004\u0012\u0002H\u00020\f\"\u0004\b\u0000\u0010\u0002*\b\u0012\u0004\u0012\u0002H\u00020\u0003\u001a'\u0010\u0011\u001a\u0002H\u0002\"\b\b\u0000\u0010\u0002*\u00020\b*\b\u0012\u0004\u0012\u0002H\u00020\u00032\u0006\u0010\u0012\u001a\u00020\u000e\u00a2\u0006\u0002\u0010\u0013\u001a\"\u0010\u0014\u001a\u00020\u0007\"\b\b\u0000\u0010\u0002*\u00020\b*\b\u0012\u0004\u0012\u0002H\u00020\u00032\u0006\u0010\u0012\u001a\u00020\u000e\u001a\u000e\u0010\u0015\u001a\u00020\u000e*\u0006\u0012\u0002\b\u00030\u0003\u001a\u001e\u0010\u0016\u001a\u00020\u0017*\u0006\u0012\u0002\b\u00030\u00032\u0006\u0010\u0012\u001a\u00020\u000e2\u0006\u0010\u0018\u001a\u00020\u0007\u001a\u0016\u0010\u0019\u001a\u00020\u0017*\u0006\u0012\u0002\b\u00030\u00032\u0006\u0010\u001a\u001a\u00020\u000e\"'\u0010\u0000\u001a\b\u0012\u0004\u0012\u0002H\u00020\u0001\"\u0004\b\u0000\u0010\u0002*\b\u0012\u0004\u0012\u0002H\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005\u00a8\u0006\u001b"}, d2={"_renderer", "Lcom/vaadin/flow/data/renderer/Renderer;", "T", "Lcom/vaadin/flow/component/ironlist/IronList;", "get_renderer", "(Lcom/vaadin/flow/component/ironlist/IronList;)Lcom/vaadin/flow/data/renderer/Renderer;", "_dump", "", "", "rows", "Lkotlin/ranges/IntRange;", "_fetch", "", "offset", "", "limit", "_findAll", "_get", "rowIndex", "(Lcom/vaadin/flow/component/ironlist/IronList;I)Ljava/lang/Object;", "_getFormattedRow", "_size", "expectRow", "", "expected", "expectRows", "count", "karibu-testing-v10"})
public final class IronListKt {
    @NotNull
    public static final <T> T _get(@NotNull IronList<T> $this$_get, int rowIndex) {
        Intrinsics.checkNotNullParameter($this$_get, (String)"<this>");
        if (!(rowIndex >= 0)) {
            boolean $i$a$-require-IronListKt$_get$22 = false;
            String $i$a$-require-IronListKt$_get$22 = "rowIndex must be 0 or greater: " + rowIndex;
            throw new IllegalArgumentException($i$a$-require-IronListKt$_get$22.toString());
        }
        int size = IronListKt._size($this$_get);
        if (rowIndex >= size) {
            throw new AssertionError((Object)("Requested to get row " + rowIndex + " but the data provider only has " + IronListKt._size($this$_get) + " rows\n" + IronListKt._dump$default($this$_get, null, 1, null)));
        }
        List<T> fetched = IronListKt._fetch($this$_get, rowIndex, 1);
        Object object = CollectionsKt.firstOrNull(fetched);
        if (object == null) {
            throw new AssertionError((Object)("Requested to get row " + rowIndex + " but the data provider only has " + IronListKt._size($this$_get) + " rows\n" + IronListKt._dump$default($this$_get, null, 1, null)));
        }
        return (T)object;
    }

    @NotNull
    public static final <T> List<T> _fetch(@NotNull IronList<T> $this$_fetch, int offset, int limit) {
        Intrinsics.checkNotNullParameter($this$_fetch, (String)"<this>");
        DataProvider dataProvider = $this$_fetch.getDataProvider();
        if (dataProvider == null) {
            throw new NullPointerException("null cannot be cast to non-null type com.vaadin.flow.data.provider.DataProvider<T of com.github.mvysny.kaributesting.v10.IronListKt._fetch, kotlin.Any?>");
        }
        Stream stream = dataProvider.fetch(new Query(offset, limit, CollectionsKt.emptyList(), null, null));
        Intrinsics.checkNotNullExpressionValue((Object)stream, (String)"dataProvider as DataProv\u2026t, listOf(), null, null))");
        Stream stream2 = stream;
        return StreamsKt.toList((Stream)stream2);
    }

    @NotNull
    public static final <T> List<T> _findAll(@NotNull IronList<T> $this$_findAll) {
        Intrinsics.checkNotNullParameter($this$_findAll, (String)"<this>");
        return IronListKt._fetch($this$_findAll, 0, Integer.MAX_VALUE);
    }

    public static final int _size(@NotNull IronList<?> $this$_size) {
        Intrinsics.checkNotNullParameter($this$_size, (String)"<this>");
        DataProvider dataProvider = $this$_size.getDataProvider();
        Intrinsics.checkNotNullExpressionValue((Object)dataProvider, (String)"dataProvider");
        return GridKt._size$default(dataProvider, null, 1, null);
    }

    @NotNull
    public static final <T> Renderer<T> get_renderer(@NotNull IronList<T> $this$_renderer) {
        Intrinsics.checkNotNullParameter($this$_renderer, (String)"<this>");
        Field field = IronList.class.getDeclaredField("renderer");
        Intrinsics.checkNotNullExpressionValue((Object)field, (String)"IronList::class.java.getDeclaredField(\"renderer\")");
        Field f = field;
        f.setAccessible(true);
        Object object = f.get($this$_renderer);
        if (object == null) {
            throw new NullPointerException("null cannot be cast to non-null type com.vaadin.flow.data.renderer.Renderer<T of com.github.mvysny.kaributesting.v10.IronListKt.<get-_renderer>>");
        }
        return (Renderer)object;
    }

    @NotNull
    public static final <T> String _getFormattedRow(@NotNull IronList<T> $this$_getFormattedRow, int rowIndex) {
        Intrinsics.checkNotNullParameter($this$_getFormattedRow, (String)"<this>");
        T rowObject = IronListKt._get($this$_getFormattedRow, rowIndex);
        return String.valueOf(RenderersKt._getPresentationValue(IronListKt.get_renderer($this$_getFormattedRow), rowObject));
    }

    @JvmOverloads
    @NotNull
    public static final <T> String _dump(@NotNull IronList<T> $this$_dump, @NotNull IntRange rows) {
        StringBuilder stringBuilder;
        Intrinsics.checkNotNullParameter($this$_dump, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)rows, (String)"rows");
        StringBuilder $this$_dump_u24lambda_u2d1 = stringBuilder = new StringBuilder();
        boolean bl = false;
        $this$_dump_u24lambda_u2d1.append("----------------------\n");
        IntRange dsIndices = RangesKt.until((int)0, (int)IronListKt._size($this$_dump));
        Set displayIndices = CollectionsKt.intersect((Iterable)((Iterable)rows), (Iterable)((Iterable)dsIndices));
        Iterator iterator = displayIndices.iterator();
        while (iterator.hasNext()) {
            int i = ((Number)iterator.next()).intValue();
            $this$_dump_u24lambda_u2d1.append(i);
            $this$_dump_u24lambda_u2d1.append(": ");
            $this$_dump_u24lambda_u2d1.append(IronListKt._getFormattedRow($this$_dump, i));
            $this$_dump_u24lambda_u2d1.append('\n');
        }
        int andMore = UtilsKt.getSize(dsIndices) - displayIndices.size();
        if (andMore > 0) {
            $this$_dump_u24lambda_u2d1.append("--and " + andMore + " more\n");
        }
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"StringBuilder().apply(builderAction).toString()");
        return string;
    }

    public static /* synthetic */ String _dump$default(IronList ironList, IntRange intRange, int n, Object object) {
        if ((n & 1) != 0) {
            intRange = new IntRange(0, 10);
        }
        return IronListKt._dump(ironList, intRange);
    }

    public static final void expectRows(@NotNull IronList<?> $this$expectRows, int count) {
        Intrinsics.checkNotNullParameter($this$expectRows, (String)"<this>");
        int actual = IronListKt._size($this$expectRows);
        if (actual != count) {
            throw new AssertionError((Object)(PrettyPrintTreeKt.toPrettyString((Component)$this$expectRows) + ": expected " + count + " rows but got " + actual + '\n' + IronListKt._dump$default($this$expectRows, null, 1, null)));
        }
    }

    public static final void expectRow(@NotNull IronList<?> $this$expectRow, int rowIndex, @NotNull String expected) {
        Intrinsics.checkNotNullParameter($this$expectRow, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)expected, (String)"expected");
        String actual = IronListKt._getFormattedRow($this$expectRow, rowIndex);
        if (!Intrinsics.areEqual((Object)expected, (Object)actual)) {
            throw new AssertionError((Object)(PrettyPrintTreeKt.toPrettyString((Component)$this$expectRow) + " at " + rowIndex + ": expected " + expected + " but got " + actual + '\n' + IronListKt._dump$default($this$expectRow, null, 1, null)));
        }
    }

    @JvmOverloads
    @NotNull
    public static final <T> String _dump(@NotNull IronList<T> $this$_dump) {
        Intrinsics.checkNotNullParameter($this$_dump, (String)"<this>");
        return IronListKt._dump$default($this$_dump, null, 1, null);
    }
}

