/*
 * Decompiled with CFR 0.152.
 */
package com.github.mvysny.kaributesting.v10;

import com.github.mvysny.kaributesting.v10.BasicUtilsKt;
import com.github.mvysny.kaributesting.v10.PrettyPrintTreeKt;
import com.vaadin.flow.component.ClickEvent;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEvent;
import com.vaadin.flow.component.contextmenu.ContextMenu;
import com.vaadin.flow.component.contextmenu.ContextMenuBase;
import com.vaadin.flow.component.contextmenu.HasMenuItems;
import com.vaadin.flow.component.contextmenu.MenuItem;
import com.vaadin.flow.component.contextmenu.MenuItemBase;
import com.vaadin.flow.component.contextmenu.SubMenuBase;
import com.vaadin.flow.component.grid.Grid;
import com.vaadin.flow.component.grid.contextmenu.GridContextMenu;
import com.vaadin.flow.component.grid.contextmenu.GridMenuItem;
import com.vaadin.flow.function.SerializablePredicate;
import java.lang.reflect.Method;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.test.AssertionsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000<\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010 \n\u0002\b\u0002\u001a\u0012\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0004\u001a\n\u0010\u0000\u001a\u00020\u0001*\u00020\u0004\u001a,\u0010\u0000\u001a\u00020\u0001*\u00020\u00042\u001e\u0010\u0005\u001a\u001a\u0012\u0010\u0012\u000e\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0007\u0012\u0004\u0012\u00020\b0\u0006H\u0002\u001a%\u0010\u0000\u001a\u00020\u0001\"\u0004\b\u0000\u0010\t*\b\u0012\u0004\u0012\u0002H\t0\n2\b\u0010\u000b\u001a\u0004\u0018\u0001H\t\u00a2\u0006\u0002\u0010\f\u001a\u0012\u0010\r\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u000e\u001a\u00020\u000f\u001a-\u0010\r\u001a\u00020\u0001\"\u0004\b\u0000\u0010\t*\b\u0012\u0004\u0012\u0002H\t0\u00102\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\u000b\u001a\u0004\u0018\u0001H\t\u00a2\u0006\u0002\u0010\u0011\u001a'\u0010\u0012\u001a\u00020\u0001\"\u0004\b\u0000\u0010\t*\b\u0012\u0004\u0012\u0002H\t0\u00102\b\u0010\u000b\u001a\u0004\u0018\u0001H\tH\u0002\u00a2\u0006\u0002\u0010\u0013\u001aL\u0010\u0014\u001a\u00020\u0001*\u000e\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u00072\u0012\u0010\u0015\u001a\u000e\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u00072\u001e\u0010\u0005\u001a\u001a\u0012\u0010\u0012\u000e\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0007\u0012\u0004\u0012\u00020\b0\u0006H\u0002\u001aL\u0010\u0016\u001a\u00020\u0001*\u000e\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u00072\u0012\u0010\u0015\u001a\u000e\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u00072\u001e\u0010\u0005\u001a\u001a\u0012\u0010\u0012\u000e\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0007\u0012\u0004\u0012\u00020\b0\u0006H\u0002\u001a\u001e\u0010\u0017\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u00070\u0018*\u00020\bH\u0002\u001a$\u0010\u0019\u001a\u001a\u0012\u0010\u0012\u000e\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0007\u0012\u0004\u0012\u00020\b0\u0006*\u00020\bH\u0002\u00a8\u0006\u001a"}, d2={"_click", "", "Lcom/vaadin/flow/component/contextmenu/HasMenuItems;", "item", "Lcom/vaadin/flow/component/contextmenu/MenuItem;", "parentMap", "", "Lcom/vaadin/flow/component/contextmenu/MenuItemBase;", "Lcom/vaadin/flow/component/Component;", "T", "Lcom/vaadin/flow/component/grid/contextmenu/GridMenuItem;", "gridItem", "(Lcom/vaadin/flow/component/grid/contextmenu/GridMenuItem;Ljava/lang/Object;)V", "_clickItemWithCaption", "caption", "", "Lcom/vaadin/flow/component/grid/contextmenu/GridContextMenu;", "(Lcom/vaadin/flow/component/grid/contextmenu/GridContextMenu;Ljava/lang/String;Ljava/lang/Object;)V", "_setContextMenuTargetItemKey", "(Lcom/vaadin/flow/component/grid/contextmenu/GridContextMenu;Ljava/lang/Object;)V", "checkMenuItemEnabled", "originalItem", "checkMenuItemVisible", "getItems", "", "getParentMap", "karibu-testing-v10"})
public final class ContextMenuKt {
    public static final void _clickItemWithCaption(@NotNull HasMenuItems $this$_clickItemWithCaption, @NotNull String caption) {
        Object v0;
        Map<MenuItemBase<?, ?, ?>, Component> parentMap;
        block2: {
            Intrinsics.checkNotNullParameter((Object)$this$_clickItemWithCaption, (String)"<this>");
            Intrinsics.checkNotNullParameter((Object)caption, (String)"caption");
            ((Component)$this$_clickItemWithCaption).getElement().setProperty("opened", true);
            parentMap = ContextMenuKt.getParentMap((Component)$this$_clickItemWithCaption);
            Iterable $this$firstOrNull$iv = parentMap.keySet();
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                MenuItemBase it = (MenuItemBase)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getText(), (Object)caption)) continue;
                v0 = element$iv;
                break block2;
            }
            v0 = null;
        }
        MenuItemBase menuItemBase = v0;
        if (menuItemBase == null) {
            AssertionsKt.fail((String)("No menu item with caption " + caption + " in this menu:\n" + PrettyPrintTreeKt.toPrettyTree((Component)$this$_clickItemWithCaption)));
            throw new KotlinNothingValueException();
        }
        MenuItemBase item = menuItemBase;
        ContextMenuKt._click((MenuItem)item, parentMap);
        ((Component)$this$_clickItemWithCaption).getElement().setProperty("opened", false);
    }

    public static final void _click(@NotNull HasMenuItems $this$_click, @NotNull MenuItem item) {
        Intrinsics.checkNotNullParameter((Object)$this$_click, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
        Map<MenuItemBase<?, ?, ?>, Component> parentMap = ContextMenuKt.getParentMap((Component)$this$_click);
        if (!parentMap.keySet().contains(item)) {
            AssertionsKt.fail((String)(PrettyPrintTreeKt.toPrettyString((Component)item) + " is not contained in this menu:\n" + PrettyPrintTreeKt.toPrettyTree((Component)$this$_click)));
            throw new KotlinNothingValueException();
        }
        ContextMenuKt._click(item, parentMap);
    }

    private static final List<MenuItemBase<?, ?, ?>> getItems(Component $this$getItems) {
        List list;
        Component component = $this$getItems;
        if (component instanceof ContextMenuBase) {
            List list2 = ((ContextMenuBase)$this$getItems).getItems();
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getItems()");
            list = list2;
        } else if (component instanceof SubMenuBase) {
            List list3 = ((SubMenuBase)$this$getItems).getItems();
            Intrinsics.checkNotNullExpressionValue((Object)list3, (String)"getItems()");
            list = list3;
        } else if (component instanceof MenuItemBase) {
            list = ContextMenuKt.getItems($this$getItems);
        } else {
            Method method = $this$getItems.getClass().getMethod("getItems", new Class[0]);
            Intrinsics.checkNotNullExpressionValue((Object)method, (String)"this.javaClass.getMethod(\"getItems\")");
            Method method2 = method;
            Object object = method2.invoke((Object)$this$getItems, new Object[0]);
            if (object == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.collections.List<com.vaadin.flow.component.contextmenu.MenuItemBase<*, *, *>>");
            }
            list = (List)object;
        }
        return list;
    }

    public static final <T> void _clickItemWithCaption(@NotNull GridContextMenu<T> $this$_clickItemWithCaption, @NotNull String caption, @Nullable T gridItem) {
        Object v1;
        block4: {
            Intrinsics.checkNotNullParameter($this$_clickItemWithCaption, (String)"<this>");
            Intrinsics.checkNotNullParameter((Object)caption, (String)"caption");
            ContextMenuKt._setContextMenuTargetItemKey($this$_clickItemWithCaption, gridItem);
            $this$_clickItemWithCaption.getElement().setProperty("opened", true);
            SerializablePredicate serializablePredicate = $this$_clickItemWithCaption.getDynamicContentHandler();
            if (serializablePredicate != null) {
                SerializablePredicate serializablePredicate2;
                SerializablePredicate it = serializablePredicate2 = serializablePredicate;
                boolean bl = false;
                boolean openMenu = it.test(gridItem);
                if (!openMenu) {
                    AssertionsKt.fail((String)Intrinsics.stringPlus((String)"The dynamic content handler returned false signalling the menu should not open:\n", (Object)PrettyPrintTreeKt.toPrettyTree((Component)$this$_clickItemWithCaption)));
                    throw new KotlinNothingValueException();
                }
            }
            Map<MenuItemBase<?, ?, ?>, Component> parentMap = ContextMenuKt.getParentMap((Component)$this$_clickItemWithCaption);
            Iterable $this$firstOrNull$iv = parentMap.keySet();
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                MenuItemBase it = (MenuItemBase)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getText(), (Object)caption)) continue;
                v1 = element$iv;
                break block4;
            }
            v1 = null;
        }
        MenuItemBase menuItemBase = v1;
        if (menuItemBase == null) {
            AssertionsKt.fail((String)("No menu item with caption " + caption + " in GridContextMenu:\n" + PrettyPrintTreeKt.toPrettyTree((Component)$this$_clickItemWithCaption)));
            throw new KotlinNothingValueException();
        }
        MenuItemBase item = menuItemBase;
        ContextMenuKt._click((GridMenuItem)item, gridItem);
        $this$_clickItemWithCaption.getElement().setProperty("opened", false);
    }

    private static final Map<MenuItemBase<?, ?, ?>, Component> getParentMap(Component $this$getParentMap) {
        Map result2 = new LinkedHashMap();
        Iterable $this$forEach$iv = ContextMenuKt.getItems($this$getParentMap);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            MenuItemBase it = (MenuItemBase)element$iv;
            boolean bl = false;
            ContextMenuKt.getParentMap$fillInParentFor(result2, it, $this$getParentMap);
        }
        return result2;
    }

    public static final void _click(@NotNull MenuItem $this$_click) {
        Intrinsics.checkNotNullParameter((Object)$this$_click, (String)"<this>");
        ContextMenu contextMenu = (ContextMenu)$this$_click.getContextMenu();
        if (contextMenu == null) {
            AssertionsKt.fail((String)"This function doesn't work on menu items attached to MenuBars. Use either menuBar._clickItemWithCaption(\"foo\") or menuBar._click(menuItem). See https://github.com/mvysny/karibu-testing/issues/33 for more details");
            throw new KotlinNothingValueException();
        }
        ContextMenu contextMenu2 = contextMenu;
        Map<MenuItemBase<?, ?, ?>, Component> parentMap = ContextMenuKt.getParentMap((Component)contextMenu2);
        ContextMenuKt._click($this$_click, parentMap);
    }

    private static final void _click(MenuItem $this$_click, Map<MenuItemBase<?, ?, ?>, ? extends Component> parentMap) {
        ContextMenuKt.checkMenuItemVisible((MenuItemBase)$this$_click, (MenuItemBase)$this$_click, parentMap);
        ContextMenuKt.checkMenuItemEnabled((MenuItemBase)$this$_click, (MenuItemBase)$this$_click, parentMap);
        BasicUtilsKt._fireEvent((Component)$this$_click, (ComponentEvent)new ClickEvent((Component)$this$_click, true, 0, 0, 0, 0, 1, 1, false, false, false, false));
    }

    public static final <T> void _click(@NotNull GridMenuItem<T> $this$_click, @Nullable T gridItem) {
        Intrinsics.checkNotNullParameter($this$_click, (String)"<this>");
        ContextMenuBase contextMenuBase = $this$_click.getContextMenu();
        Intrinsics.checkNotNullExpressionValue((Object)contextMenuBase, (String)"contextMenu");
        Map<MenuItemBase<?, ?, ?>, Component> parentMap = ContextMenuKt.getParentMap((Component)contextMenuBase);
        ContextMenuKt.checkMenuItemVisible((MenuItemBase)$this$_click, (MenuItemBase)$this$_click, parentMap);
        ContextMenuKt.checkMenuItemEnabled((MenuItemBase)$this$_click, (MenuItemBase)$this$_click, parentMap);
        contextMenuBase = $this$_click.getContextMenu();
        Intrinsics.checkNotNullExpressionValue((Object)contextMenuBase, (String)"contextMenu");
        ContextMenuKt._setContextMenuTargetItemKey((GridContextMenu)contextMenuBase, gridItem);
        BasicUtilsKt._fireDomEvent$default((Component)$this$_click, "click", null, 2, null);
    }

    private static final <T> void _setContextMenuTargetItemKey(GridContextMenu<T> $this$_setContextMenuTargetItemKey, T gridItem) {
        Component component = $this$_setContextMenuTargetItemKey.getTarget();
        if (component == null) {
            throw new NullPointerException("null cannot be cast to non-null type com.vaadin.flow.component.grid.Grid<T of com.github.mvysny.kaributesting.v10.ContextMenuKt._setContextMenuTargetItemKey>");
        }
        Grid grid = (Grid)component;
        String key = grid.getDataCommunicator().getKeyMapper().key(gridItem);
        if (key == null) {
            boolean bl = false;
            String string = "grid " + PrettyPrintTreeKt.toPrettyString((Component)grid) + " generated null as key for " + gridItem;
            throw new IllegalArgumentException(string.toString());
        }
        grid.getElement().setProperty("_contextMenuTargetItemKey", key);
    }

    private static final void checkMenuItemVisible(MenuItemBase<?, ?, ?> $this$checkMenuItemVisible, MenuItemBase<?, ?, ?> originalItem, Map<MenuItemBase<?, ?, ?>, ? extends Component> parentMap) {
        if (!$this$checkMenuItemVisible.isVisible()) {
            if (Intrinsics.areEqual(originalItem, $this$checkMenuItemVisible)) {
                AssertionsKt.fail((String)Intrinsics.stringPlus((String)PrettyPrintTreeKt.toPrettyString((Component)originalItem), (Object)" is not visible"));
                throw new KotlinNothingValueException();
            }
            AssertionsKt.fail((String)(PrettyPrintTreeKt.toPrettyString((Component)originalItem) + " is not visible because its parent item is not visible:\n" + PrettyPrintTreeKt.toPrettyTree((Component)$this$checkMenuItemVisible)));
            throw new KotlinNothingValueException();
        }
        Component component = parentMap.get($this$checkMenuItemVisible);
        if (component == null) {
            StringBuilder stringBuilder = new StringBuilder().append(PrettyPrintTreeKt.toPrettyString((Component)originalItem)).append(" is not part of\n");
            ContextMenuBase contextMenuBase = $this$checkMenuItemVisible.getContextMenu();
            Intrinsics.checkNotNullExpressionValue((Object)contextMenuBase, (String)"getContextMenu()");
            AssertionsKt.fail((String)stringBuilder.append(PrettyPrintTreeKt.toPrettyTree((Component)contextMenuBase)).append("?!?").toString());
            throw new KotlinNothingValueException();
        }
        Component parent = component;
        if ((component = parent) instanceof MenuItem) {
            ContextMenuKt.checkMenuItemVisible((MenuItemBase)parent, originalItem, parentMap);
        } else if (component instanceof GridMenuItem) {
            ContextMenuKt.checkMenuItemVisible((MenuItemBase)parent, originalItem, parentMap);
        } else if (component instanceof ContextMenu) {
            if (((ContextMenu)parent).getTarget() == null) {
                boolean $i$a$-checkNotNull-ContextMenuKt$checkMenuItemVisible$22 = false;
                String $i$a$-checkNotNull-ContextMenuKt$checkMenuItemVisible$22 = "The context menu " + PrettyPrintTreeKt.toPrettyString(parent) + " is not attached to any component";
                throw new IllegalStateException($i$a$-checkNotNull-ContextMenuKt$checkMenuItemVisible$22.toString());
            }
            Boolean bl = true;
            StringBuilder stringBuilder = new StringBuilder().append("Cannot click ").append(PrettyPrintTreeKt.toPrettyString((Component)originalItem)).append(" since it's attached to ");
            Object $i$a$-checkNotNull-ContextMenuKt$checkMenuItemVisible$22 = ((ContextMenu)parent).getTarget();
            Intrinsics.checkNotNullExpressionValue((Object)$i$a$-checkNotNull-ContextMenuKt$checkMenuItemVisible$22, (String)"parent.target");
            $i$a$-checkNotNull-ContextMenuKt$checkMenuItemVisible$22 = stringBuilder.append(PrettyPrintTreeKt.toPrettyString($i$a$-checkNotNull-ContextMenuKt$checkMenuItemVisible$22)).append(" which is not effectively visible").toString();
            Boolean bl2 = bl;
            boolean bl3 = false;
            Component component2 = ((ContextMenu)parent).getTarget();
            Intrinsics.checkNotNullExpressionValue((Object)component2, (String)"parent.target");
            AssertionsKt.assertEquals((Object)bl2, (Object)BasicUtilsKt.isEffectivelyVisible(component2), (String)$i$a$-checkNotNull-ContextMenuKt$checkMenuItemVisible$22);
        } else if (component instanceof GridContextMenu) {
            if (((GridContextMenu)parent).getTarget() == null) {
                boolean bl = false;
                String string = "The context menu " + PrettyPrintTreeKt.toPrettyString(parent) + " is not attached to any component";
                throw new IllegalStateException(string.toString());
            }
            Boolean bl = true;
            StringBuilder stringBuilder = new StringBuilder().append("Cannot click ").append(PrettyPrintTreeKt.toPrettyString((Component)originalItem)).append(" since it's attached to ");
            Object object = ((GridContextMenu)parent).getTarget();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"parent.target");
            object = stringBuilder.append(PrettyPrintTreeKt.toPrettyString(object)).append(" which is not effectively visible").toString();
            Boolean bl4 = bl;
            boolean bl5 = false;
            Component component3 = ((GridContextMenu)parent).getTarget();
            Intrinsics.checkNotNullExpressionValue((Object)component3, (String)"parent.target");
            AssertionsKt.assertEquals((Object)bl4, (Object)BasicUtilsKt.isEffectivelyVisible(component3), (String)object);
        } else {
            Boolean bl = true;
            String string = "Cannot click " + PrettyPrintTreeKt.toPrettyString((Component)originalItem) + " since it's attached to " + PrettyPrintTreeKt.toPrettyString(parent) + " which is not effectively visible";
            Boolean bl6 = bl;
            boolean bl7 = false;
            AssertionsKt.assertEquals((Object)bl6, (Object)BasicUtilsKt.isEffectivelyVisible(parent), (String)string);
        }
    }

    private static final void checkMenuItemEnabled(MenuItemBase<?, ?, ?> $this$checkMenuItemEnabled, MenuItemBase<?, ?, ?> originalItem, Map<MenuItemBase<?, ?, ?>, ? extends Component> parentMap) {
        if (!$this$checkMenuItemEnabled.isEnabled()) {
            if (Intrinsics.areEqual(originalItem, $this$checkMenuItemEnabled)) {
                AssertionsKt.fail((String)Intrinsics.stringPlus((String)PrettyPrintTreeKt.toPrettyString((Component)originalItem), (Object)" is not enabled"));
                throw new KotlinNothingValueException();
            }
            AssertionsKt.fail((String)(PrettyPrintTreeKt.toPrettyString((Component)originalItem) + " is not enabled because its parent item is not enabled:\n" + PrettyPrintTreeKt.toPrettyTree((Component)$this$checkMenuItemEnabled)));
            throw new KotlinNothingValueException();
        }
        Component component = parentMap.get($this$checkMenuItemEnabled);
        if (component == null) {
            StringBuilder stringBuilder = new StringBuilder().append(PrettyPrintTreeKt.toPrettyString((Component)originalItem)).append(" is not part of\n");
            ContextMenuBase contextMenuBase = $this$checkMenuItemEnabled.getContextMenu();
            Intrinsics.checkNotNullExpressionValue((Object)contextMenuBase, (String)"getContextMenu()");
            AssertionsKt.fail((String)stringBuilder.append(PrettyPrintTreeKt.toPrettyTree((Component)contextMenuBase)).append("?!?").toString());
            throw new KotlinNothingValueException();
        }
        Component parent = component;
        if ((component = parent) instanceof MenuItem) {
            ContextMenuKt.checkMenuItemEnabled((MenuItemBase)parent, originalItem, parentMap);
        } else if (component instanceof GridMenuItem) {
            ContextMenuKt.checkMenuItemEnabled((MenuItemBase)parent, originalItem, parentMap);
        } else if (!(component instanceof ContextMenu) && !(component instanceof GridContextMenu)) {
            Boolean bl = true;
            String string = "Cannot click " + PrettyPrintTreeKt.toPrettyString((Component)originalItem) + " since it's attached to " + PrettyPrintTreeKt.toPrettyString(parent) + " which is not effectively visible";
            Boolean bl2 = bl;
            boolean bl3 = false;
            AssertionsKt.assertEquals((Object)bl2, (Object)BasicUtilsKt.isEffectivelyEnabled(parent), (String)string);
        }
    }

    private static final void getParentMap$fillInParentFor(Map<MenuItemBase<?, ?, ?>, Component> result2, MenuItemBase<?, ?, ?> item, Component parent) {
        result2.put(item, parent);
        List list = item.getSubMenu().getItems();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"item.getSubMenu().getItems()");
        Iterable $this$forEach$iv = list;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            MenuItemBase it = (MenuItemBase)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
            ContextMenuKt.getParentMap$fillInParentFor(result2, it, (Component)item);
        }
    }
}

