/*
 * Decompiled with CFR 0.152.
 */
package com.github.mvysny.kaributesting.v10;

import com.github.mvysny.kaributesting.mockhttp.MockHttpSession;
import com.github.mvysny.kaributesting.mockhttp.MockRequest;
import com.github.mvysny.kaributesting.mockhttp.MockResponse;
import com.github.mvysny.kaributesting.mockhttp.MockServletConfig;
import com.github.mvysny.kaributesting.v10.BasicUtilsKt;
import com.github.mvysny.kaributesting.v10.MockPage;
import com.github.mvysny.kaributesting.v10.MockVaadin;
import com.github.mvysny.kaributesting.v10.MockVaadinKt;
import com.github.mvysny.kaributesting.v10.Routes;
import com.github.mvysny.kaributesting.v10.TestingLifecycleHookKt;
import com.github.mvysny.kaributesting.v10.UtilsKt;
import com.github.mvysny.kaributesting.v10.VaadinMeta;
import com.github.mvysny.kaributesting.v10.mock.MockVaadinHelper;
import com.github.mvysny.kaributesting.v10.mock.MockVaadinServlet;
import com.github.mvysny.kaributesting.v10.mock.MockVaadinServletKt;
import com.github.mvysny.kaributools.VaadinVersion;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentUtil;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.internal.CurrentInstance;
import com.vaadin.flow.router.Location;
import com.vaadin.flow.router.NavigationTrigger;
import com.vaadin.flow.router.Router;
import com.vaadin.flow.server.DefaultErrorHandler;
import com.vaadin.flow.server.ErrorEvent;
import com.vaadin.flow.server.ErrorHandler;
import com.vaadin.flow.server.ServiceDestroyEvent;
import com.vaadin.flow.server.SessionInitEvent;
import com.vaadin.flow.server.VaadinRequest;
import com.vaadin.flow.server.VaadinResponse;
import com.vaadin.flow.server.VaadinService;
import com.vaadin.flow.server.VaadinServlet;
import com.vaadin.flow.server.VaadinServletRequest;
import com.vaadin.flow.server.VaadinServletResponse;
import com.vaadin.flow.server.VaadinServletService;
import com.vaadin.flow.server.VaadinSession;
import com.vaadin.flow.server.WrappedHttpSession;
import com.vaadin.flow.server.WrappedSession;
import com.vaadin.flow.shared.communication.PushMode;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import kotlin.ExceptionsKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u00152\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00170\"H\u0007J\u0010\u0010#\u001a\u00020\u001f2\u0006\u0010$\u001a\u00020\u0005H\u0002J\b\u0010%\u001a\u00020\u001fH\u0007J\b\u0010&\u001a\u00020\u001fH\u0002J\u000e\u0010'\u001a\u00020\u001f2\u0006\u0010$\u001a\u00020\u0005J\u001e\u0010(\u001a\u00020\u001f2\u0006\u0010)\u001a\u00020*2\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00170\"H\u0002J#\u0010+\u001a\u00020\u001f2\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00170\"2\u0006\u0010 \u001a\u00020\u0015H\u0000\u00a2\u0006\u0002\b,J\u001c\u0010-\u001a\u00020\u001f2\b\b\u0002\u0010.\u001a\u00020\u00052\b\b\u0002\u0010 \u001a\u00020\u0015H\u0007J \u0010/\u001a\u00020\u001f2\u000e\b\u0002\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00170\"2\u0006\u00100\u001a\u000201H\u0007J\"\u0010/\u001a\u00020\u001f2\b\b\u0002\u00102\u001a\u0002032\u000e\b\u0002\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00170\"H\u0007J\b\u00104\u001a\u00020\u001fH\u0007R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00070\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R&\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00110\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00130\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00150\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00170\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0018\u001a\u00020\u0019X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001d\u00a8\u00065"}, d2={"Lcom/github/mvysny/kaributesting/v10/MockVaadin;", "", "()V", "currentlyClosingSession", "Ljava/lang/ThreadLocal;", "", "lastNavigation", "Lcom/vaadin/flow/router/Location;", "mockRequestFactory", "Lkotlin/Function1;", "Lcom/github/mvysny/kaributesting/mockhttp/MockHttpSession;", "Lcom/github/mvysny/kaributesting/mockhttp/MockRequest;", "getMockRequestFactory", "()Lkotlin/jvm/functions/Function1;", "setMockRequestFactory", "(Lkotlin/jvm/functions/Function1;)V", "strongRefReq", "Lcom/vaadin/flow/server/VaadinRequest;", "strongRefRes", "Lcom/vaadin/flow/server/VaadinResponse;", "strongRefSession", "Lcom/vaadin/flow/server/VaadinSession;", "strongRefUI", "Lcom/vaadin/flow/component/UI;", "userAgent", "", "getUserAgent", "()Ljava/lang/String;", "setUserAgent", "(Ljava/lang/String;)V", "afterSessionClose", "", "session", "uiFactory", "Lkotlin/Function0;", "clearVaadinInstances", "fireUIDetach", "clientRoundtrip", "closeCurrentSession", "closeCurrentUI", "createSession", "ctx", "Ljavax/servlet/ServletContext;", "createUI", "createUI$karibu_testing_v10", "runUIQueue", "propagateExceptionToHandler", "setup", "servlet", "Lcom/vaadin/flow/server/VaadinServlet;", "routes", "Lcom/github/mvysny/kaributesting/v10/Routes;", "tearDown", "karibu-testing-v10"})
public final class MockVaadin {
    @NotNull
    public static final MockVaadin INSTANCE = new MockVaadin();
    @NotNull
    private static final ThreadLocal<VaadinSession> strongRefSession = new ThreadLocal();
    @NotNull
    private static final ThreadLocal<UI> strongRefUI = new ThreadLocal();
    @NotNull
    private static final ThreadLocal<VaadinRequest> strongRefReq = new ThreadLocal();
    @NotNull
    private static final ThreadLocal<VaadinResponse> strongRefRes = new ThreadLocal();
    @NotNull
    private static final ThreadLocal<Location> lastNavigation = new ThreadLocal();
    @NotNull
    private static final ThreadLocal<Boolean> currentlyClosingSession = new ThreadLocal<Boolean>(){

        @NotNull
        protected Boolean initialValue() {
            return false;
        }
    };
    @NotNull
    private static String userAgent = "Mozilla/5.0 (X11; Ubuntu; Linux x86_64; rv:94.0) Gecko/20100101 Firefox/94.0";
    @NotNull
    private static Function1<? super MockHttpSession, ? extends MockRequest> mockRequestFactory = mockRequestFactory.1.INSTANCE;

    private MockVaadin() {
    }

    @JvmStatic
    @JvmOverloads
    public static final void setup(@NotNull Routes routes, @NotNull Function0<? extends UI> uiFactory) {
        Intrinsics.checkNotNullParameter((Object)routes, (String)"routes");
        Intrinsics.checkNotNullParameter(uiFactory, (String)"uiFactory");
        MockVaadinServlet servlet = new MockVaadinServlet(routes, null, 2, null);
        MockVaadin.setup(uiFactory, servlet);
    }

    public static /* synthetic */ void setup$default(Routes routes, Function0 function0, int n, Object object) {
        if ((n & 1) != 0) {
            routes = new Routes(null, null, false, 7, null);
        }
        if ((n & 2) != 0) {
            function0 = setup.1.INSTANCE;
        }
        MockVaadin.setup(routes, (Function0<? extends UI>)function0);
    }

    @JvmStatic
    public static final void setup(@NotNull Function0<? extends UI> uiFactory, @NotNull VaadinServlet servlet) {
        Intrinsics.checkNotNullParameter(uiFactory, (String)"uiFactory");
        Intrinsics.checkNotNullParameter((Object)servlet, (String)"servlet");
        if (!VaadinVersion.INSTANCE.getGet().isAtLeast(14, 3)) {
            boolean bl = false;
            String string = Intrinsics.stringPlus((String)"Karibu-Testing only works with Vaadin 14.3.0+ but you're using ", (Object)VaadinVersion.INSTANCE.getGet());
            throw new IllegalStateException(string.toString());
        }
        if (!(!VaadinMeta.INSTANCE.isCompatibilityMode())) {
            String string = "Check failed.";
            throw new IllegalStateException(string.toString());
        }
        if (!UtilsKt.isInitialized((Servlet)servlet)) {
            ServletContext ctx = MockVaadinHelper.INSTANCE.createMockContext();
            servlet.init((ServletConfig)new MockServletConfig(ctx));
        }
        VaadinServletService vaadinServletService = MockVaadinServletKt.getServiceSafe(servlet);
        if (vaadinServletService == null) {
            String string = "Required value was null.";
            throw new IllegalStateException(string.toString());
        }
        VaadinServletService service = vaadinServletService;
        if (!(service.getRouter() != null)) {
            boolean bl = false;
            String string = servlet + " failed to call VaadinServletService.init() in createServletService()";
            throw new IllegalStateException(string.toString());
        }
        VaadinService.setCurrent((VaadinService)((VaadinService)service));
        ServletContext servletContext = servlet.getServletContext();
        Intrinsics.checkNotNullExpressionValue((Object)servletContext, (String)"servlet.servletContext");
        INSTANCE.createSession(servletContext, uiFactory);
    }

    public static /* synthetic */ void setup$default(Function0 function0, VaadinServlet vaadinServlet, int n, Object object) {
        if ((n & 1) != 0) {
            function0 = setup.2.INSTANCE;
        }
        MockVaadin.setup((Function0<? extends UI>)function0, vaadinServlet);
    }

    public final void closeCurrentUI(boolean fireUIDetach) {
        UI uI = UI.getCurrent();
        if (uI == null) {
            return;
        }
        UI ui = uI;
        lastNavigation.set(ui.getInternals().getActiveViewLocation());
        if (ui.isClosing() && ui.getInternals().getSession() != null) {
            BasicUtilsKt._close(ui);
        }
        if (fireUIDetach) {
            ComponentUtil.onComponentDetach((Component)((Component)ui));
        }
        UI.setCurrent(null);
        strongRefUI.remove();
    }

    @JvmStatic
    public static final void tearDown() {
        INSTANCE.clearVaadinInstances(false);
        VaadinService service = VaadinService.getCurrent();
        if (service != null) {
            MockVaadinKt.access$fireServiceDestroyListeners(service, new ServiceDestroyEvent(service));
            VaadinService.setCurrent(null);
        }
        lastNavigation.remove();
    }

    private final void clearVaadinInstances(boolean fireUIDetach) {
        this.closeCurrentUI(fireUIDetach);
        this.closeCurrentSession();
        CurrentInstance.set(VaadinRequest.class, null);
        CurrentInstance.set(VaadinResponse.class, null);
        strongRefReq.remove();
        strongRefRes.remove();
    }

    private final void closeCurrentSession() {
        VaadinSession session = VaadinSession.getCurrent();
        if (session != null) {
            VaadinService vaadinService = VaadinService.getCurrent();
            Intrinsics.checkNotNullExpressionValue((Object)vaadinService, (String)"getCurrent()");
            VaadinService service = vaadinService;
            service.fireSessionDestroy(session);
            VaadinSession.setCurrent(null);
            currentlyClosingSession.set(true);
            MockVaadin.runUIQueue$default(false, session, 1, null);
            currentlyClosingSession.set(false);
        }
        strongRefSession.remove();
    }

    @NotNull
    public final String getUserAgent() {
        return userAgent;
    }

    public final void setUserAgent(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        userAgent = string;
    }

    @NotNull
    public final Function1<MockHttpSession, MockRequest> getMockRequestFactory() {
        return mockRequestFactory;
    }

    public final void setMockRequestFactory(@NotNull Function1<? super MockHttpSession, ? extends MockRequest> function1) {
        Intrinsics.checkNotNullParameter(function1, (String)"<set-?>");
        mockRequestFactory = function1;
    }

    /*
     * WARNING - void declaration
     */
    private final void createSession(ServletContext ctx, Function0<? extends UI> uiFactory) {
        void $this$createSession_u24lambda_u2d2;
        VaadinService vaadinService = VaadinService.getCurrent();
        if (vaadinService == null) {
            String string = "Required value was null.";
            throw new IllegalStateException(string.toString());
        }
        VaadinServletService service = (VaadinServletService)vaadinService;
        MockHttpSession httpSession = MockHttpSession.Companion.create(ctx);
        MockRequest mockRequest = (MockRequest)mockRequestFactory.invoke((Object)httpSession);
        ((Map)mockRequest.getHeaders()).put("User-Agent", CollectionsKt.listOf((Object)userAgent));
        VaadinServletRequest request = MockVaadinServletKt.createVaadinServletRequest((HttpServletRequest)mockRequest, (VaadinService)service);
        strongRefReq.set((VaadinRequest)request);
        CurrentInstance.set(VaadinRequest.class, (Object)request);
        VaadinService vaadinService2 = (VaadinService)service;
        Object object = VaadinRequest.getCurrent();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getCurrent()");
        VaadinSession session = MockVaadinServletKt._createVaadinSession(vaadinService2, object);
        Object object2 = object = new ReentrantLock();
        String string = Intrinsics.stringPlus((String)service.getServiceName(), (Object)".lock");
        MockHttpSession mockHttpSession = httpSession;
        boolean bl = false;
        $this$createSession_u24lambda_u2d2.lock();
        Unit unit = Unit.INSTANCE;
        mockHttpSession.setAttribute(string, object);
        httpSession.setAttribute(VaadinSession.class.getName() + '.' + service.getServiceName(), (Object)session);
        session.refreshTransients((WrappedSession)new WrappedHttpSession((HttpSession)httpSession), (VaadinService)service);
        if (!(session.getLockInstance() != null)) {
            boolean $i$a$-check-MockVaadin$createSession$42 = false;
            String $i$a$-check-MockVaadin$createSession$42 = session + " created from " + service + " has null lock. See the MockSession class on how to mock locks properly";
            throw new IllegalStateException($i$a$-check-MockVaadin$createSession$42.toString());
        }
        Lock lock = session.getLockInstance();
        if (lock == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.util.concurrent.locks.ReentrantLock");
        }
        if (!((ReentrantLock)lock).isLocked()) {
            boolean $i$a$-check-MockVaadin$createSession$52 = false;
            String $i$a$-check-MockVaadin$createSession$52 = session + " created from " + service + ": lock must be locked!";
            throw new IllegalStateException($i$a$-check-MockVaadin$createSession$52.toString());
        }
        session.setConfiguration(service.getDeploymentConfiguration());
        VaadinSession.setCurrent((VaadinSession)session);
        strongRefSession.set(session);
        session.setBrowser(MockVaadinServletKt.WebBrowser((VaadinRequest)request));
        if (session.getBrowser().getBrowserApplication() == null) {
            boolean bl2 = false;
            String string2 = "The WebBrowser has not been mocked properly";
            throw new IllegalStateException(string2.toString());
        }
        VaadinServletResponse response = MockVaadinServletKt.createVaadinServletResponse((HttpServletResponse)new MockResponse(), (VaadinService)service);
        strongRefRes.set((VaadinResponse)response);
        CurrentInstance.set(VaadinResponse.class, (Object)response);
        MockVaadinKt.access$fireSessionInitListeners((VaadinService)service, new SessionInitEvent((VaadinService)service, session, (VaadinRequest)request));
        this.createUI$karibu_testing_v10(uiFactory, session);
    }

    public final void createUI$karibu_testing_v10(@NotNull Function0<? extends UI> uiFactory, @NotNull VaadinSession session) {
        Field field;
        Intrinsics.checkNotNullParameter(uiFactory, (String)"uiFactory");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        VaadinRequest vaadinRequest = VaadinRequest.getCurrent();
        if (vaadinRequest == null) {
            String string = "Required value was null.";
            throw new IllegalStateException(string.toString());
        }
        VaadinRequest request = vaadinRequest;
        UI ui = (UI)uiFactory.invoke();
        if (!(ui.getSession() == null)) {
            boolean $i$a$-require-MockVaadin$createUI$22 = false;
            String $i$a$-require-MockVaadin$createUI$22 = "uiFactory produced UI " + ui + " which is already attached to a Session, yet we expect the UI to be a fresh new instance, not yet attached to a Session, so that the tests are able to always start with a fresh UI with a pre-known state. Perhaps you're using Spring which reuses a scoped instance of the UI?";
            throw new IllegalArgumentException($i$a$-require-MockVaadin$createUI$22.toString());
        }
        Field $this$createUI_u24lambda_u2d7 = field = UI.class.getDeclaredField("page");
        boolean bl = false;
        $this$createUI_u24lambda_u2d7.setAccessible(true);
        $this$createUI_u24lambda_u2d7.set(ui, (Object)new MockPage(ui, uiFactory, session));
        ui.getInternals().setSession(session);
        UI.setCurrent((UI)ui);
        ui.doInit(request, 1);
        strongRefUI.set(ui);
        session.addUI(ui);
        session.getService().fireUIInitListeners(ui);
        if (lastNavigation.get() != null) {
            Router router = UI.getCurrent().getInternals().getRouter();
            UI uI = UI.getCurrent();
            Location location = lastNavigation.get();
            Intrinsics.checkNotNull((Object)location);
            router.navigate(uI, location, NavigationTrigger.PROGRAMMATIC);
            lastNavigation.remove();
        } else if (UI.getCurrent().getInternals().getRouter().getRegistry().getNavigationTarget("").isPresent()) {
            UI.getCurrent().navigate("");
        }
        ui.getPushConfiguration().setPushMode(PushMode.AUTOMATIC);
    }

    @JvmStatic
    public static final void clientRoundtrip() {
        if (VaadinSession.getCurrent() == null) {
            boolean bl = false;
            String string = "No VaadinSession";
            throw new IllegalStateException(string.toString());
        }
        MockVaadin.runUIQueue$default(false, null, 3, null);
        UI.getCurrent().getInternals().getStateTree().runExecutionsBeforeClientResponse();
        TestingLifecycleHookKt.cleanupDialogs();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JvmStatic
    @JvmOverloads
    public static final void runUIQueue(boolean propagateExceptionToHandler, @NotNull VaadinSession session) {
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        List errors = new ArrayList();
        ErrorHandler oldErrorHandler = session.getErrorHandler();
        if (oldErrorHandler == null || oldErrorHandler instanceof DefaultErrorHandler || !propagateExceptionToHandler) {
            session.setErrorHandler(new ErrorHandler(errors){
                final /* synthetic */ List<Throwable> $errors;
                {
                    this.$errors = $errors;
                }

                public final void error(ErrorEvent it) {
                    Throwable throwable = it.getThrowable();
                    Intrinsics.checkNotNullExpressionValue((Object)throwable, (String)"it.throwable");
                    Throwable t = throwable;
                    if (!(t instanceof ExecutionException)) {
                        t = new ExecutionException(t.getMessage(), t);
                    }
                    this.$errors.add(t);
                }
            });
        }
        try {
            session.unlock();
            session.lock();
        }
        finally {
            session.setErrorHandler(oldErrorHandler);
        }
        if (!((Collection)errors).isEmpty()) {
            Iterable $this$forEach$iv = CollectionsKt.drop((Iterable)errors, (int)1);
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Throwable it = (Throwable)element$iv;
                boolean bl = false;
                ExceptionsKt.addSuppressed((Throwable)((Throwable)errors.get(0)), (Throwable)it);
            }
            throw (Throwable)errors.get(0);
        }
    }

    public static /* synthetic */ void runUIQueue$default(boolean bl, VaadinSession vaadinSession, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        if ((n & 2) != 0) {
            VaadinSession vaadinSession2 = VaadinSession.getCurrent();
            Intrinsics.checkNotNullExpressionValue((Object)vaadinSession2, (String)"getCurrent()");
            vaadinSession = vaadinSession2;
        }
        MockVaadin.runUIQueue(bl, vaadinSession);
    }

    @JvmStatic
    public static final void afterSessionClose(@NotNull VaadinSession session, @NotNull Function0<? extends UI> uiFactory) {
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Intrinsics.checkNotNullParameter(uiFactory, (String)"uiFactory");
        if (!currentlyClosingSession.get().booleanValue()) {
            MockHttpSession mockSession = UtilsKt.getMock(session);
            INSTANCE.clearVaadinInstances(true);
            mockSession.destroy();
            INSTANCE.createSession(mockSession.getServletContext(), uiFactory);
        }
    }

    @JvmStatic
    @JvmOverloads
    public static final void setup(@NotNull Routes routes) {
        Intrinsics.checkNotNullParameter((Object)routes, (String)"routes");
        MockVaadin.setup$default(routes, null, 2, null);
    }

    @JvmStatic
    @JvmOverloads
    public static final void setup() {
        MockVaadin.setup$default(null, null, 3, null);
    }

    @JvmStatic
    @JvmOverloads
    public static final void runUIQueue(boolean propagateExceptionToHandler) {
        MockVaadin.runUIQueue$default(propagateExceptionToHandler, null, 2, null);
    }

    @JvmStatic
    @JvmOverloads
    public static final void runUIQueue() {
        MockVaadin.runUIQueue$default(false, null, 3, null);
    }
}

