/*
 * Decompiled with CFR 0.152.
 */
package com.github.mvysny.kaributesting.v10.mock;

import com.github.mvysny.kaributesting.v10.VaadinMeta;
import com.github.mvysny.kaributesting.v10.mock.MockVaadin19Kt;
import com.github.mvysny.kaributesting.v10.mock.MockVaadinHelper;
import com.github.mvysny.kaributools.VaadinVersion;
import com.vaadin.flow.di.Lookup;
import com.vaadin.flow.di.LookupInitializer;
import com.vaadin.flow.server.VaadinContext;
import com.vaadin.flow.server.VaadinServletContext;
import com.vaadin.flow.server.startup.LookupServletContainerInitializer;
import elemental.json.Json;
import elemental.json.JsonObject;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Set;
import javax.servlet.ServletContext;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004J\u000e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u001c\u0010\t\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0007\u001a\u00020\n2\n\u0010\u000b\u001a\u0006\u0012\u0002\b\u00030\fJ\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0007\u001a\u00020\nJ\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0007\u001a\u00020\b\u00a8\u0006\u000f"}, d2={"Lcom/github/mvysny/kaributesting/v10/mock/MockVaadin19;", "", "()V", "getTokenFileFromClassloader", "Lelemental/json/JsonObject;", "init", "", "ctx", "Ljavax/servlet/ServletContext;", "lookup", "Lcom/vaadin/flow/server/VaadinContext;", "clazz", "Ljava/lang/Class;", "verifyHasLookup", "Lcom/vaadin/flow/di/Lookup;", "karibu-testing-v10"})
@SourceDebugExtension(value={"SMAP\nMockVaadin19.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MockVaadin19.kt\ncom/github/mvysny/kaributesting/v10/mock/MockVaadin19\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,107:1\n1#2:108\n*E\n"})
public final class MockVaadin19 {
    @NotNull
    public static final MockVaadin19 INSTANCE = new MockVaadin19();

    private MockVaadin19() {
    }

    public final void init(@NotNull ServletContext ctx) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        MockVaadin19Kt.checkVaadinSupportedByKaribuTesting();
        LookupServletContainerInitializer loaderInitializer = new LookupServletContainerInitializer();
        Object[] objectArray = new Class[2];
        objectArray[0] = LookupInitializer.class;
        Intrinsics.checkNotNullExpressionValue(Class.forName("com.vaadin.flow.di.LookupInitializer$ResourceProviderImpl"), (String)"forName(...)");
        Set loaders = SetsKt.mutableSetOf((Object[])objectArray);
        int vaadinVersion = VaadinVersion.INSTANCE.getGet().getMajor();
        if (vaadinVersion >= 19) {
            MockVaadin19.init$tryLoad(loaders, "com.vaadin.flow.component.polymertemplate.rpc.PolymerPublishedEventRpcHandler");
        }
        boolean bl = 19 <= vaadinVersion ? vaadinVersion < 21 : false;
        if (bl) {
            MockVaadin19.init$tryLoad(loaders, "com.vaadin.flow.server.frontend.fusion.EndpointGeneratorTaskFactoryImpl");
        }
        if (vaadinVersion >= 21) {
            MockVaadin19.init$tryLoad(loaders, "com.vaadin.fusion.frontend.EndpointGeneratorTaskFactoryImpl");
        }
        loaderInitializer.onStartup(loaders, ctx);
        this.verifyHasLookup(ctx);
    }

    @NotNull
    public final Lookup verifyHasLookup(@NotNull ServletContext ctx) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        if (!MockVaadin19Kt.getHasLookup(VaadinMeta.INSTANCE)) {
            boolean $i$a$-check-MockVaadin19$verifyHasLookup$22 = false;
            String $i$a$-check-MockVaadin19$verifyHasLookup$22 = "Lookup is only available in Vaadin 19+ and 14.6+";
            throw new IllegalStateException($i$a$-check-MockVaadin19$verifyHasLookup$22.toString());
        }
        Object lookup = ctx.getAttribute("com.vaadin.flow.di.Lookup");
        if (lookup == null) {
            boolean bl = false;
            StringBuilder stringBuilder = new StringBuilder().append("The context doesn't contain the Vaadin 19 Lookup class. Available attributes: ");
            Enumeration enumeration = ctx.getAttributeNames();
            Intrinsics.checkNotNullExpressionValue((Object)enumeration, (String)"getAttributeNames(...)");
            ArrayList arrayList = Collections.list(enumeration);
            Intrinsics.checkNotNullExpressionValue(arrayList, (String)"list(...)");
            String string = stringBuilder.append(arrayList).toString();
            throw new IllegalStateException(string.toString());
        }
        return (Lookup)lookup;
    }

    @NotNull
    public final Lookup verifyHasLookup(@NotNull VaadinContext ctx) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        ServletContext servletContext = ((VaadinServletContext)ctx).getContext();
        Intrinsics.checkNotNullExpressionValue((Object)servletContext, (String)"getContext(...)");
        return this.verifyHasLookup(servletContext);
    }

    @Nullable
    public final Object lookup(@NotNull VaadinContext ctx, @NotNull Class<?> clazz) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter(clazz, (String)"clazz");
        Lookup lookup = this.verifyHasLookup(ctx);
        return lookup.lookup(clazz);
    }

    @Nullable
    public final JsonObject getTokenFileFromClassloader() {
        VaadinContext ctx = MockVaadinHelper.INSTANCE.createMockVaadinContext();
        Class<?> clazz = Class.forName("com.vaadin.flow.server.startup.ApplicationConfigurationFactory");
        Intrinsics.checkNotNullExpressionValue(clazz, (String)"forName(...)");
        Object acf = this.lookup(ctx, clazz);
        if (acf == null) {
            boolean $i$a$-checkNotNull-MockVaadin19$getTokenFileFromClassloader$22 = false;
            String $i$a$-checkNotNull-MockVaadin19$getTokenFileFromClassloader$22 = "ApplicationConfigurationFactory is null";
            throw new IllegalStateException($i$a$-checkNotNull-MockVaadin19$getTokenFileFromClassloader$22.toString());
        }
        Class<?> dacfClass = Class.forName("com.vaadin.flow.server.startup.DefaultApplicationConfigurationFactory");
        if (dacfClass.isInstance(acf)) {
            Class[] classArray = new Class[]{VaadinContext.class};
            Method m = dacfClass.getDeclaredMethod("getTokenFileFromClassloader", classArray);
            m.setAccessible(true);
            Object[] objectArray = new Object[]{ctx};
            String string = (String)m.invoke(acf, objectArray);
            if (string == null) {
                return null;
            }
            String json = string;
            return Json.parse((String)json);
        }
        return null;
    }

    private static final void init$tryLoad(Set<Class<?>> loaders, String clazz) {
        try {
            Class<?> clazz2 = Class.forName(clazz);
            Intrinsics.checkNotNullExpressionValue(clazz2, (String)"forName(...)");
            loaders.add(clazz2);
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }
}

