/*
 * Decompiled with CFR 0.152.
 */
package com.github.mvysny.kaributesting.v10;

import com.github.mvysny.kaributesting.v10.SearchSpec;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.icon.VaadinIcon;
import java.util.function.Predicate;
import kotlin.jvm.functions.Function1;
import kotlin.ranges.IntRange;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SearchSpecJ<T extends Component> {
    @NotNull
    private final SearchSpec<T> spec;

    public SearchSpecJ(@NotNull SearchSpec<T> spec) {
        this.spec = spec;
    }

    @NotNull
    public SearchSpecJ<T> withId(@Nullable String id) {
        this.spec.setId(id);
        return this;
    }

    @NotNull
    public SearchSpecJ<T> withLabel(@Nullable String label) {
        this.spec.setLabel(label);
        return this;
    }

    @Deprecated(forRemoval=true)
    @NotNull
    public SearchSpecJ<T> withCaption(@Nullable String caption) {
        this.spec.setCaption(caption);
        return this;
    }

    @NotNull
    public SearchSpecJ<T> withValue(@Nullable Object value) {
        this.spec.setValue(value);
        return this;
    }

    @NotNull
    public SearchSpecJ<T> withPlaceholder(@Nullable String placeholder) {
        this.spec.setPlaceholder(placeholder);
        return this;
    }

    @NotNull
    public SearchSpecJ<T> withText(@Nullable String text) {
        this.spec.setText(text);
        return this;
    }

    @NotNull
    public SearchSpecJ<T> withCount(@NotNull IntRange count) {
        this.spec.setCount(count);
        return this;
    }

    @NotNull
    public SearchSpecJ<T> withCount(int count) {
        return this.withCount(count, count);
    }

    @NotNull
    public SearchSpecJ<T> withCount(int min, int max) {
        if (min > max) {
            throw new IllegalArgumentException("Parameter min: invalid value " + min + ": must be less than or equal to max: " + max);
        }
        return this.withCount(new IntRange(min, max));
    }

    @NotNull
    public SearchSpecJ<T> withClasses(@Nullable String classes) {
        this.spec.setClasses(classes);
        return this;
    }

    @NotNull
    public SearchSpecJ<T> withoutClasses(@Nullable String classes) {
        this.spec.setWithoutClasses(classes);
        return this;
    }

    @NotNull
    public SearchSpecJ<T> withThemes(@Nullable String themes) {
        this.spec.setThemes(themes);
        return this;
    }

    @NotNull
    public SearchSpecJ<T> withoutThemes(@Nullable String themes) {
        this.spec.setWithoutThemes(themes);
        return this;
    }

    @NotNull
    public SearchSpecJ<T> withPredicate(@NotNull Predicate<T> predicate) {
        this.spec.getPredicates().add(predicate);
        return this;
    }

    @NotNull
    public String toString() {
        return this.spec.toString();
    }

    @NotNull
    public Predicate<Component> toPredicate() {
        final Function1<Component, Boolean> predicate = this.spec.toPredicate();
        final String toString = this.spec.toString();
        return new Predicate<Component>(){

            @Override
            public boolean test(Component component) {
                return (Boolean)predicate.invoke((Object)component);
            }

            public String toString() {
                return toString;
            }
        };
    }

    @NotNull
    public SearchSpecJ<T> withIcon(@NotNull String collection, @NotNull String iconName) {
        this.spec.iconIs(collection, iconName);
        return this;
    }

    @NotNull
    public SearchSpecJ<T> withIcon(@NotNull VaadinIcon vaadinIcon) {
        this.spec.iconIs(vaadinIcon);
        return this;
    }

    @NotNull
    public SearchSpecJ<T> withEnabled(boolean enabled) {
        this.spec.setEnabled(enabled);
        return this;
    }

    @NotNull
    public SearchSpecJ<T> withAttribute(@NotNull String name, @NotNull String value) {
        this.spec.getAttributes().put(name, value);
        return this;
    }
}

