/*
 * Decompiled with CFR 0.152.
 */
package com.github.mvysny.kaributesting.mockhttp;

import com.github.mvysny.kaributesting.mockhttp.SessionAttributeEntrySetIterator;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import javax.servlet.http.HttpSession;
import kotlin.Metadata;
import kotlin.collections.AbstractMutableSet;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010'\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010)\n\u0002\b\u0002\b\u0002\u0018\u00002\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u00020\u0001B\r\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u001c\u0010\u000e\u001a\u00020\u000f2\u0012\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0002H\u0016J\u001d\u0010\u0011\u001a\u00020\u000f2\u0012\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0002H\u0096\u0002J\b\u0010\u0012\u001a\u00020\u000fH\u0016J\u001b\u0010\u0013\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u00020\u0014H\u0096\u0002J\u001c\u0010\u0015\u001a\u00020\u000f2\u0012\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0002H\u0016R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u00020\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0016"}, d2={"Lcom/github/mvysny/kaributesting/mockhttp/SessionAttributeEntrySet;", "Lkotlin/collections/AbstractMutableSet;", "", "", "", "session", "Ljavax/servlet/http/HttpSession;", "(Ljavax/servlet/http/HttpSession;)V", "getSession", "()Ljavax/servlet/http/HttpSession;", "size", "", "getSize", "()I", "add", "", "element", "contains", "isEmpty", "iterator", "", "remove", "mock-servlet-environment"})
final class SessionAttributeEntrySet
extends AbstractMutableSet<Map.Entry<String, Object>> {
    @NotNull
    private final HttpSession session;

    public SessionAttributeEntrySet(@NotNull HttpSession session) {
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        this.session = session;
    }

    @NotNull
    public final HttpSession getSession() {
        return this.session;
    }

    public int getSize() {
        Enumeration enumeration = this.session.getAttributeNames();
        Intrinsics.checkNotNullExpressionValue((Object)enumeration, (String)"session.attributeNames");
        return SequencesKt.count((Sequence)SequencesKt.asSequence((Iterator)CollectionsKt.iterator((Enumeration)enumeration)));
    }

    public boolean isEmpty() {
        return !this.session.getAttributeNames().hasMoreElements();
    }

    public boolean add(@NotNull Map.Entry<String, Object> element) {
        boolean modified;
        Intrinsics.checkNotNullParameter(element, (String)"element");
        boolean bl = modified = !Intrinsics.areEqual((Object)this.session.getAttribute(element.getKey()), (Object)element.getValue());
        if (modified) {
            this.session.setAttribute(element.getKey(), element.getValue());
        }
        return modified;
    }

    @NotNull
    public Iterator<Map.Entry<String, Object>> iterator() {
        return new SessionAttributeEntrySetIterator(this.session);
    }

    public boolean remove(@NotNull Map.Entry<String, Object> element) {
        Intrinsics.checkNotNullParameter(element, (String)"element");
        boolean contains = this.contains((Object)element);
        if (contains) {
            this.session.removeAttribute(element.getKey());
        }
        return contains;
    }

    public boolean contains(@NotNull Map.Entry<String, Object> element) {
        Intrinsics.checkNotNullParameter(element, (String)"element");
        return Intrinsics.areEqual((Object)this.session.getAttribute(element.getKey()), (Object)element.getValue());
    }
}

