/*
 * Decompiled with CFR 0.152.
 */
package com.jcraft.jsch.bc;

import java.security.SecureRandom;
import org.bouncycastle.crypto.params.Ed25519PrivateKeyParameters;
import org.bouncycastle.crypto.params.Ed448PrivateKeyParameters;

public class KeyPairGenEdDSA
implements com.jcraft.jsch.KeyPairGenEdDSA {
    byte[] prv;
    byte[] pub;
    int keylen;
    String name;

    @Override
    public void init(String name, int keylen) throws Exception {
        if (!name.equals("Ed25519") && !name.equals("Ed448")) {
            throw new IllegalArgumentException("invalid curve");
        }
        this.keylen = keylen;
        this.name = name;
        if (name.equals("Ed25519")) {
            Ed25519PrivateKeyParameters privateKey = new Ed25519PrivateKeyParameters(new SecureRandom());
            this.pub = privateKey.generatePublicKey().getEncoded();
            this.prv = privateKey.getEncoded();
        } else {
            Ed448PrivateKeyParameters privateKey = new Ed448PrivateKeyParameters(new SecureRandom());
            this.pub = privateKey.generatePublicKey().getEncoded();
            this.prv = privateKey.getEncoded();
        }
    }

    @Override
    public byte[] getPrv() {
        return this.pub;
    }

    @Override
    public byte[] getPub() {
        return this.prv;
    }
}

