/*
 * Decompiled with CFR 0.152.
 */
package com.jcraft.jsch.bc;

import com.jcraft.jsch.Buffer;
import java.nio.charset.StandardCharsets;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.Signer;
import org.bouncycastle.crypto.params.Ed25519PrivateKeyParameters;
import org.bouncycastle.crypto.params.Ed25519PublicKeyParameters;
import org.bouncycastle.crypto.params.Ed448PrivateKeyParameters;
import org.bouncycastle.crypto.params.Ed448PublicKeyParameters;
import org.bouncycastle.crypto.signers.Ed25519Signer;
import org.bouncycastle.crypto.signers.Ed448Signer;

public abstract class SignatureEdDSA
implements com.jcraft.jsch.SignatureEdDSA {
    Signer signature;

    abstract String getName();

    abstract String getAlgo();

    abstract int getKeylen();

    @Override
    public void init() throws Exception {
        if (!this.getAlgo().equals("Ed25519") && !this.getAlgo().equals("Ed448")) {
            throw new IllegalArgumentException("invalid curve");
        }
        this.signature = this.getAlgo().equals("Ed25519") ? new Ed25519Signer() : new Ed448Signer(new byte[0]);
    }

    @Override
    public void setPubKey(byte[] y_arr) throws Exception {
        if (this.getAlgo().equals("Ed25519")) {
            Ed25519PublicKeyParameters pubKey = new Ed25519PublicKeyParameters(y_arr);
            this.signature.init(false, (CipherParameters)pubKey);
        } else {
            Ed448PublicKeyParameters pubKey = new Ed448PublicKeyParameters(y_arr);
            this.signature.init(false, (CipherParameters)pubKey);
        }
    }

    @Override
    public void setPrvKey(byte[] bytes) throws Exception {
        if (this.getAlgo().equals("Ed25519")) {
            Ed25519PrivateKeyParameters prvKey = new Ed25519PrivateKeyParameters(bytes);
            this.signature.init(true, (CipherParameters)prvKey);
        } else {
            Ed448PrivateKeyParameters prvKey = new Ed448PrivateKeyParameters(bytes);
            this.signature.init(true, (CipherParameters)prvKey);
        }
    }

    @Override
    public byte[] sign() throws Exception {
        byte[] sig = this.signature.generateSignature();
        return sig;
    }

    @Override
    public void update(byte[] foo) throws Exception {
        this.signature.update(foo, 0, foo.length);
    }

    @Override
    public boolean verify(byte[] sig) throws Exception {
        int i = 0;
        int j = 0;
        Buffer buf = new Buffer(sig);
        String foo = new String(buf.getString(), StandardCharsets.UTF_8);
        if (foo.equals(this.getName())) {
            j = buf.getInt();
            i = buf.getOffSet();
            byte[] tmp = new byte[j];
            System.arraycopy(sig, i, tmp, 0, j);
            sig = tmp;
        }
        return this.signature.verifySignature(sig);
    }
}

