/*
 * Decompiled with CFR 0.152.
 */
package com.github.mygreen.cellformatter;

import com.github.mygreen.cellformatter.ConditionDateFormatter;
import com.github.mygreen.cellformatter.ConditionFormatterFactory;
import com.github.mygreen.cellformatter.LocaleSymbol;
import com.github.mygreen.cellformatter.lang.ArgUtils;
import com.github.mygreen.cellformatter.lang.Utils;
import com.github.mygreen.cellformatter.term.AsteriskTerm;
import com.github.mygreen.cellformatter.term.DateTerm;
import com.github.mygreen.cellformatter.term.EscapedCharTerm;
import com.github.mygreen.cellformatter.term.LocaelSymbolTerm;
import com.github.mygreen.cellformatter.term.OtherTerm;
import com.github.mygreen.cellformatter.term.Term;
import com.github.mygreen.cellformatter.term.UnderscoreTerm;
import com.github.mygreen.cellformatter.term.WordTerm;
import com.github.mygreen.cellformatter.tokenizer.Token;
import com.github.mygreen.cellformatter.tokenizer.TokenStore;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConditionDateFormatterFactory
extends ConditionFormatterFactory<ConditionDateFormatter> {
    private static Logger logger = LoggerFactory.getLogger(ConditionDateFormatterFactory.class);
    private static final String[] DATE_DECISTION_CHARS = new String[]{"yy", "yyyy", "m", "mm", "mmm", "mmmm", "mmmmm", "d", "dd", "ddd", "dddd", "g", "gg", "ggg", "ee", "aaa", "aaaa", "r", "rr", "h", "hh", "s", "ss", "am/pm", "a/p", "q", "qq", "nn", "nnn", "ww"};
    private static final String[] DATE_TERM_CHARS = new String[]{"yy", "yyyy", "m", "mm", "mmm", "mmmm", "mmmmm", "d", "dd", "ddd", "dddd", "g", "gg", "ggg", "e", "ee", "aaa", "aaaa", "r", "rr", "h", "hh", "s", "ss", "am/pm", "a/p", "q", "qq", "nn", "ww"};
    private static final List<String> SORTED_DATE_CHARS = Utils.reverse(DATE_TERM_CHARS);
    private static final Pattern PATTERN_ELAPSED_TIME = Pattern.compile("\\[([h]+|[m]+|[s]+)\\]", 2);

    public boolean isDatePattern(TokenStore store) {
        if (store.containsInFactor("General")) {
            return false;
        }
        if (store.containsAnyInFactorIgnoreCase(DATE_DECISTION_CHARS)) {
            return true;
        }
        for (Token token : store.getTokens()) {
            Token.Condition condition;
            String value;
            if (!(token instanceof Token.Condition) || !PATTERN_ELAPSED_TIME.matcher(value = (condition = token.asCondition()).getValue()).matches()) continue;
            return true;
        }
        return false;
    }

    @Override
    public ConditionDateFormatter create(TokenStore store) {
        ArgUtils.notNull(store, "store");
        ConditionDateFormatter formatter = new ConditionDateFormatter(store.getConcatenatedToken());
        for (Token token : store.getTokens()) {
            if (token instanceof Token.Condition) {
                Token.Condition conditionToken = token.asCondition();
                String condition = conditionToken.getCondition();
                if (PATTERN_ELAPSED_TIME.matcher(token.getValue()).matches()) {
                    if (Utils.startsWithIgnoreCase(condition, "h")) {
                        formatter.addTerm(DateTerm.elapsedHour(condition));
                        continue;
                    }
                    if (Utils.startsWithIgnoreCase(condition, "m")) {
                        formatter.addTerm(DateTerm.elapsedMinute(condition));
                        continue;
                    }
                    if (!Utils.startsWithIgnoreCase(condition, "s")) continue;
                    formatter.addTerm(DateTerm.elapsedSecond(condition));
                    continue;
                }
                formatter.addCondition(condition);
                if (this.isConditionOperator(conditionToken)) {
                    this.setupConditionOperator(formatter, conditionToken);
                    continue;
                }
                if (this.isConditionLocale(conditionToken)) {
                    this.setupConditionLocale(formatter, conditionToken);
                    continue;
                }
                if (this.isConditionLocaleSymbol(conditionToken)) {
                    LocaleSymbol localeSymbol = this.setupConditionLocaleSymbol(formatter, conditionToken);
                    formatter.addTerm(new LocaelSymbolTerm<Calendar>(localeSymbol));
                    continue;
                }
                if (this.isConditionDbNum(conditionToken)) {
                    this.setupConditionDbNum(formatter, conditionToken);
                    continue;
                }
                if (!this.isConditionColor(conditionToken)) continue;
                this.setupConditionColor(formatter, conditionToken);
                continue;
            }
            if (token instanceof Token.Word) {
                formatter.addTerm(new WordTerm<Calendar>(token.asWord()));
                continue;
            }
            if (token instanceof Token.EscapedChar) {
                formatter.addTerm(new EscapedCharTerm<Calendar>(token.asEscapedChar()));
                continue;
            }
            if (token instanceof Token.Underscore) {
                formatter.addTerm(new UnderscoreTerm<Calendar>(token.asUnderscore()));
                continue;
            }
            if (token instanceof Token.Asterisk) {
                formatter.addTerm(new AsteriskTerm<Calendar>(token.asAsterisk()));
                continue;
            }
            if (token instanceof Token.Factor) {
                List<Token> list = this.convertFactor(token.asFactor());
                for (Token item : list) {
                    if (item instanceof Token.Formatter) {
                        String formatterItem = item.asFormatter().getValue();
                        if (Utils.equalsAnyIgnoreCase(formatterItem, new String[]{"am/pm", "a/p"})) {
                            formatter.addTerm(DateTerm.amPm(formatterItem));
                            continue;
                        }
                        if (Utils.startsWithIgnoreCase(formatterItem, "w")) {
                            formatter.addTerm(DateTerm.weekNumber(formatterItem));
                            continue;
                        }
                        if (Utils.startsWithIgnoreCase(formatterItem, "y")) {
                            formatter.addTerm(DateTerm.year(formatterItem));
                            continue;
                        }
                        if (Utils.startsWithIgnoreCase(formatterItem, "g")) {
                            formatter.addTerm(DateTerm.eraName(formatterItem));
                            continue;
                        }
                        if (Utils.startsWithIgnoreCase(formatterItem, "e")) {
                            formatter.addTerm(DateTerm.eraYear(formatterItem));
                            continue;
                        }
                        if (Utils.startsWithIgnoreCase(formatterItem, "r")) {
                            formatter.addTerm(DateTerm.eraNameYear(formatterItem));
                            continue;
                        }
                        if (Utils.startsWithIgnoreCase(formatterItem, "m")) {
                            formatter.addTerm(DateTerm.month(formatterItem));
                            continue;
                        }
                        if (Utils.startsWithIgnoreCase(formatterItem, "d")) {
                            formatter.addTerm(DateTerm.day(formatterItem));
                            continue;
                        }
                        if (Utils.startsWithIgnoreCase(formatterItem, "a")) {
                            formatter.addTerm(DateTerm.weekName(formatterItem));
                            continue;
                        }
                        if (Utils.startsWithIgnoreCase(formatterItem, "n")) {
                            formatter.addTerm(DateTerm.weekNameForOO(formatterItem));
                            continue;
                        }
                        if (Utils.startsWithIgnoreCase(formatterItem, "h")) {
                            boolean halfHour = store.containsAnyInFactorIgnoreCase(new String[]{"am/pm", "a/p"});
                            formatter.addTerm(DateTerm.hour(formatterItem, halfHour));
                            continue;
                        }
                        if (Utils.startsWithIgnoreCase(formatterItem, "s")) {
                            formatter.addTerm(DateTerm.second(formatterItem));
                            continue;
                        }
                        if (Utils.startsWithIgnoreCase(formatterItem, "q")) {
                            formatter.addTerm(DateTerm.quater(formatterItem));
                            continue;
                        }
                        if (logger.isWarnEnabled()) {
                            logger.warn("unknown date format terms '{}'.", (Object)formatterItem);
                        }
                        formatter.addTerm(new OtherTerm<Calendar>(item));
                        continue;
                    }
                    formatter.addTerm(new OtherTerm<Calendar>(item));
                }
                continue;
            }
            formatter.addTerm(new OtherTerm<Calendar>(token));
        }
        this.convertMinuteTerm(formatter);
        return formatter;
    }

    private List<Token> convertFactor(Token.Factor factor) {
        String item = factor.getValue();
        int itemLength = item.length();
        ArrayList<Token> list = new ArrayList<Token>();
        int idx = 0;
        StringBuilder noTermChar = new StringBuilder();
        while (idx < itemLength) {
            String matchChars = null;
            for (String chars : SORTED_DATE_CHARS) {
                if (!Utils.startsWithIgnoreCase(item, chars, idx)) continue;
                matchChars = item.substring(idx, idx + chars.length());
                break;
            }
            if (matchChars == null) {
                noTermChar.append(item.charAt(idx));
                ++idx;
                continue;
            }
            if (noTermChar.length() > 0) {
                list.add(Token.factor(noTermChar.toString()));
                noTermChar = new StringBuilder();
            }
            list.add(Token.formatter(matchChars));
            idx += matchChars.length();
        }
        if (noTermChar.length() > 0) {
            list.add(Token.factor(noTermChar.toString()));
        }
        return list;
    }

    private void convertMinuteTerm(ConditionDateFormatter formatter) {
        int termSize = formatter.getTerms().size();
        for (int i = 0; i < termSize; ++i) {
            Term<Calendar> term = formatter.getTerms().get(i);
            if (!(term instanceof DateTerm.MonthTerm) || !this.isMinuteTerm(i, formatter.getTerms())) continue;
            DateTerm.MonthTerm monthTerm = (DateTerm.MonthTerm)term;
            formatter.getTerms().set(i, DateTerm.minute(monthTerm.getFormat()));
        }
    }

    private boolean isMinuteTerm(int currentTermIdx, List<Term<Calendar>> terms) {
        Term<Calendar> term;
        int i;
        int termSize = terms.size();
        if (currentTermIdx - 1 > 0) {
            DateTerm beforeTerm = null;
            for (i = currentTermIdx - 1; i >= 0; --i) {
                term = terms.get(i);
                if (!(term instanceof DateTerm)) continue;
                beforeTerm = (DateTerm)term;
                break;
            }
            if (beforeTerm != null && (beforeTerm instanceof DateTerm.HourTerm || beforeTerm instanceof DateTerm.ElapsedHourTerm)) {
                return true;
            }
        }
        if (currentTermIdx + 1 < termSize) {
            DateTerm afterTerm = null;
            for (i = currentTermIdx + 1; i < termSize; ++i) {
                term = terms.get(i);
                if (!(term instanceof DateTerm)) continue;
                afterTerm = (DateTerm)term;
                break;
            }
            if (afterTerm != null && (afterTerm instanceof DateTerm.SecondTerm || afterTerm instanceof DateTerm.ElapsedSecondTerm)) {
                return true;
            }
        }
        return false;
    }
}

