/*
 * Decompiled with CFR 0.152.
 */
package com.github.mygreen.cellformatter;

import com.github.mygreen.cellformatter.ConditionFormatter;
import com.github.mygreen.cellformatter.ConditionOperator;
import com.github.mygreen.cellformatter.LocaleSymbol;
import com.github.mygreen.cellformatter.callback.Callback;
import com.github.mygreen.cellformatter.callback.DBNum1;
import com.github.mygreen.cellformatter.callback.DBNum2;
import com.github.mygreen.cellformatter.callback.DBNum3;
import com.github.mygreen.cellformatter.callback.DBNumBase;
import com.github.mygreen.cellformatter.lang.MSColor;
import com.github.mygreen.cellformatter.lang.MSLocale;
import com.github.mygreen.cellformatter.tokenizer.Token;
import com.github.mygreen.cellformatter.tokenizer.TokenStore;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ConditionFormatterFactory<F> {
    private static Logger logger = LoggerFactory.getLogger(ConditionFormatterFactory.class);
    private static final Pattern PATTERN_CONDITION_OPERATOR = Pattern.compile("\\[([><=]+)([+-]*[0-9\\.]+)\\]");
    private static final Pattern PATTERN_CONDITION_LOCALE = Pattern.compile("\\[\\$\\-([0-9a-zA-Z]+)\\]");
    private static final Pattern PATTERN_CONDITION_LOCALE_SYMBOL = Pattern.compile("\\[\\$(.+)\\-([0-9a-zA-Z]+)\\]");
    private static final Pattern PATTERN_CONDITION_DBNUM = Pattern.compile("\\[DBNum([0-9]+)\\]");
    private static final Pattern PATTERN_CONDITION_INDEX_COLOR = Pattern.compile("\\[(\u8272|Color)([0-9]+)\\]");

    public abstract F create(TokenStore var1);

    protected boolean isConditionOperator(Token.Condition token) {
        return PATTERN_CONDITION_OPERATOR.matcher(token.getValue()).matches();
    }

    protected boolean isConditionLocale(Token.Condition token) {
        return PATTERN_CONDITION_LOCALE.matcher(token.getValue()).matches();
    }

    protected boolean isConditionLocaleSymbol(Token.Condition token) {
        return PATTERN_CONDITION_LOCALE_SYMBOL.matcher(token.getValue()).matches();
    }

    protected boolean isConditionDbNum(Token.Condition token) {
        return PATTERN_CONDITION_DBNUM.matcher(token.getValue()).matches();
    }

    protected boolean isConditionColor(Token.Condition token) {
        if (MSColor.valueOfKnownColor(token.getCondition()) != null) {
            return true;
        }
        return PATTERN_CONDITION_INDEX_COLOR.matcher(token.getValue()).matches();
    }

    protected ConditionOperator setupConditionOperator(ConditionFormatter formatter, Token.Condition token) {
        ConditionOperator conditionOperator;
        Matcher matcher = PATTERN_CONDITION_OPERATOR.matcher(token.getValue());
        if (!matcher.matches()) {
            throw new IllegalArgumentException("not match condition:" + token.getValue());
        }
        String operator = matcher.group(1);
        String number = matcher.group(2);
        double condition = Double.valueOf(number);
        switch (operator) {
            case "=": {
                conditionOperator = new ConditionOperator.Equal(condition);
                break;
            }
            case "<>": {
                conditionOperator = new ConditionOperator.NotEqual(condition);
                break;
            }
            case ">": {
                conditionOperator = new ConditionOperator.GreaterThan(condition);
                break;
            }
            case "<": {
                conditionOperator = new ConditionOperator.LessThan(condition);
                break;
            }
            case ">=": {
                conditionOperator = new ConditionOperator.GreaterEqual(condition);
                break;
            }
            case "<=": {
                conditionOperator = new ConditionOperator.LessEqual(condition);
                break;
            }
            default: {
                logger.warn("unknown operator : {}", (Object)operator);
                conditionOperator = ConditionOperator.ALL;
            }
        }
        formatter.setOperator(conditionOperator);
        return conditionOperator;
    }

    protected MSLocale setupConditionLocale(ConditionFormatter formatter, Token.Condition token) {
        Matcher matcher = PATTERN_CONDITION_LOCALE.matcher(token.getValue());
        if (!matcher.matches()) {
            throw new IllegalArgumentException("not match condition:" + token.getValue());
        }
        String number = matcher.group(1);
        int value = Integer.valueOf(number, 16);
        MSLocale locale = MSLocale.createKnownLocale(value);
        if (locale == null) {
            locale = new MSLocale(value);
        }
        formatter.setLocale(locale);
        return locale;
    }

    protected LocaleSymbol setupConditionLocaleSymbol(ConditionFormatter formatter, Token.Condition token) {
        Matcher matcher = PATTERN_CONDITION_LOCALE_SYMBOL.matcher(token.getValue());
        if (!matcher.matches()) {
            throw new IllegalArgumentException("not match condition:" + token.getValue());
        }
        String symbol = matcher.group(1);
        String number = matcher.group(2);
        int value = Integer.valueOf(number, 16);
        MSLocale locale = MSLocale.createKnownLocale(value);
        if (locale == null) {
            locale = new MSLocale(value);
        }
        formatter.setLocale(locale);
        return new LocaleSymbol(locale, symbol);
    }

    protected Callback<?> setupConditionDbNum(ConditionFormatter formatter, Token.Condition token) {
        Matcher matcher = PATTERN_CONDITION_DBNUM.matcher(token.getValue());
        if (!matcher.matches()) {
            throw new IllegalArgumentException("not match condition:" + token.getValue());
        }
        DBNumBase callback = null;
        String number = matcher.group(1);
        if (number.startsWith("1")) {
            callback = DBNum1.create();
        } else if (number.startsWith("2")) {
            callback = DBNum2.create();
        } else if (number.startsWith("3")) {
            callback = DBNum3.create();
        }
        if (callback != null) {
            formatter.addCallback(callback);
        }
        return callback;
    }

    protected MSColor setupConditionColor(ConditionFormatter formatter, Token.Condition token) {
        MSColor color = MSColor.valueOfKnownColor(token.getCondition());
        if (color != null) {
            formatter.setColor(color);
            return color;
        }
        Matcher matcher = PATTERN_CONDITION_INDEX_COLOR.matcher(token.getValue());
        if (!matcher.matches()) {
            throw new IllegalArgumentException("not match condition:" + token.getValue());
        }
        String number = matcher.group(2);
        short index = Short.valueOf(number);
        color = MSColor.valueOfIndexColor(index);
        formatter.setColor(color);
        return color;
    }
}

