/*
 * Decompiled with CFR 0.152.
 */
package com.github.mygreen.cellformatter.lang;

import com.github.mygreen.cellformatter.lang.ArgUtils;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import java.util.concurrent.TimeUnit;

public class ExcelDateUtils {
    public static final int SECONDS_IN_DAYS = (int)TimeUnit.HOURS.toSeconds(24L);
    public static final long MILLISECONDS_19000101 = ExcelDateUtils.parseDate("1900-01-01 00:00:00.000").getTime();
    public static final long MILLISECONDS_19040101 = ExcelDateUtils.parseDate("1904-01-01 00:00:00.000").getTime();
    public static final long MILLISECONDS_19000301 = ExcelDateUtils.parseDate("1900-03-01 00:00:00.000").getTime();
    public static final int OFFSET_DAYS_1900;
    public static final int OFFSET_DAYS_1904;
    public static final int NON_LEAP_DAY = 61;

    public static Date convertJavaDate(double numValue, boolean startDate1904) {
        double utcDay;
        if (startDate1904) {
            utcDay = numValue + (double)OFFSET_DAYS_1904;
        } else {
            utcDay = numValue + (double)OFFSET_DAYS_1900;
            if (numValue >= 61.0) {
                utcDay -= 1.0;
            }
        }
        long utcTime = Math.round(utcDay * (double)SECONDS_IN_DAYS) * 1000L;
        return new Date(utcTime);
    }

    public static double convertExcelNumber(Date value, boolean startDate1904) {
        ArgUtils.notNull(value, "value");
        long utcDay = value.getTime();
        BigDecimal numValue = new BigDecimal(utcDay);
        numValue = numValue.divide(new BigDecimal(SECONDS_IN_DAYS * 1000), 17, 4);
        if (startDate1904) {
            numValue = numValue.subtract(new BigDecimal(OFFSET_DAYS_1904));
        } else if ((numValue = numValue.subtract(new BigDecimal(OFFSET_DAYS_1900))).compareTo(new BigDecimal(60)) >= 0) {
            numValue = numValue.add(new BigDecimal(1));
        }
        return numValue.doubleValue();
    }

    public static String formatDate(Date date) {
        ArgUtils.notNull(date, "date");
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
        format.setTimeZone(TimeZone.getTimeZone("GMT-00:00"));
        return format.format(date);
    }

    public static Date parseDate(String str) {
        ArgUtils.notEmpty(str, str);
        try {
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
            format.setTimeZone(TimeZone.getTimeZone("GMT-00:00"));
            return format.parse(str);
        }
        catch (ParseException e) {
            throw new IllegalStateException(String.format("fail parse to Data from '%s',", str), e);
        }
    }

    public static long getExcelZeroDateTime(boolean isStartDate1904) {
        if (isStartDate1904) {
            return MILLISECONDS_19040101;
        }
        return MILLISECONDS_19000101 - TimeUnit.DAYS.toMillis(1L);
    }

    static {
        long offsetDay1900 = ExcelDateUtils.parseDate("1900-01-01 00:00:00.000").getTime() / ((long)SECONDS_IN_DAYS * 1000L);
        OFFSET_DAYS_1900 = (int)offsetDay1900 - 1;
        long offsetDay1904 = ExcelDateUtils.parseDate("1904-01-01 00:00:00.000").getTime() / ((long)SECONDS_IN_DAYS * 1000L);
        OFFSET_DAYS_1904 = (int)offsetDay1904;
    }
}

