/*
 * Decompiled with CFR 0.152.
 */
package com.github.mygreen.cellformatter.lang;

import com.github.mygreen.cellformatter.lang.ArgUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class Utils {
    public static boolean isEmpty(String str) {
        return str == null || str.isEmpty();
    }

    public static boolean isNotEmpty(String str) {
        return !Utils.isEmpty(str);
    }

    public static List<String> reverse(String[] array) {
        ArgUtils.notNull(array, "array");
        if (array.length == 0) {
            return new ArrayList<String>();
        }
        List<String> list = Arrays.asList(array);
        Collections.sort(list, new Comparator<String>(){

            @Override
            public int compare(String str1, String str2) {
                int len2;
                int len1 = str1.length();
                if (len1 != (len2 = str2.length())) {
                    return Integer.compare(len1, len2) * -1;
                }
                return str1.compareTo(str2) * 1;
            }
        });
        return list;
    }

    public static boolean startsWithIgnoreCase(String str, String prefix) {
        return Utils.startsWith(str, prefix, true);
    }

    public static boolean startsWithIgnoreCase(String str, String prefix, int offset) {
        if (str == null || prefix == null) {
            return str == null && prefix == null;
        }
        if (str.length() < offset) {
            return false;
        }
        String subStr = str.substring(offset);
        return Utils.startsWithIgnoreCase(subStr, prefix);
    }

    private static boolean startsWith(String str, String prefix, boolean ignoreCase) {
        if (str == null || prefix == null) {
            return str == null && prefix == null;
        }
        if (prefix.length() > str.length()) {
            return false;
        }
        return str.regionMatches(ignoreCase, 0, prefix, 0, prefix.length());
    }

    public static boolean containsIgnoreCase(String str, String searchStr) {
        if (str == null || searchStr == null) {
            return false;
        }
        int len = searchStr.length();
        int max = str.length() - len;
        for (int i = 0; i <= max; ++i) {
            if (!str.regionMatches(true, i, searchStr, 0, len)) continue;
            return true;
        }
        return false;
    }

    public static boolean containsAny(String str, String[] list, boolean ignoreCase) {
        if (str == null) {
            return false;
        }
        if (list == null || list.length == 0) {
            return false;
        }
        for (String item : list) {
            if (!(ignoreCase ? Utils.containsIgnoreCase(str, item) : str.indexOf(item) >= 0)) continue;
            return true;
        }
        return false;
    }

    public static boolean equalsAny(String str, String[] searchChars) {
        for (String search : searchChars) {
            if (!str.equals(search)) continue;
            return true;
        }
        return false;
    }

    public static boolean equalsAnyIgnoreCase(String str, String[] list) {
        if (str == null) {
            return false;
        }
        if (list == null || list.length == 0) {
            return false;
        }
        for (String item : list) {
            if (!str.equalsIgnoreCase(item)) continue;
            return true;
        }
        return false;
    }

    public static String supplyZero(String str, int size) {
        if (str == null) {
            return "";
        }
        int length = str.length();
        if (length > size) {
            return str;
        }
        StringBuilder sb = new StringBuilder();
        int appendSize = size - length;
        for (int i = 0; i < appendSize; ++i) {
            sb.append("0");
        }
        sb.append(str);
        return sb.toString();
    }
}

