/*
 * Decompiled with CFR 0.152.
 */
package com.scin.sdk.exception;

import com.scin.sdk.enums.StatusEnum;
import lombok.NonNull;

public class BusinessException
extends RuntimeException {
    @NonNull
    private int code;
    @NonNull
    private String message;
    @NonNull
    private String local;

    public static BusinessException of(StatusEnum statusEnum) {
        return BusinessException.of(statusEnum.getCode(), statusEnum.getMessage(), statusEnum.getDescription());
    }

    public static BusinessException of(int code, String message, String local) {
        return new BusinessException(code, message, local);
    }

    @Override
    public synchronized Throwable fillInStackTrace() {
        return null;
    }

    @NonNull
    public int getCode() {
        return this.code;
    }

    @Override
    @NonNull
    public String getMessage() {
        return this.message;
    }

    @NonNull
    public String getLocal() {
        return this.local;
    }

    public void setCode(@NonNull int code) {
        this.code = code;
    }

    public void setMessage(@NonNull String message) {
        if (message == null) {
            throw new NullPointerException("message is marked non-null but is null");
        }
        this.message = message;
    }

    public void setLocal(@NonNull String local) {
        if (local == null) {
            throw new NullPointerException("local is marked non-null but is null");
        }
        this.local = local;
    }

    @Override
    public String toString() {
        return "BusinessException(code=" + this.getCode() + ", message=" + this.getMessage() + ", local=" + this.getLocal() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BusinessException)) {
            return false;
        }
        BusinessException other = (BusinessException)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getCode() != other.getCode()) {
            return false;
        }
        String this$message = this.getMessage();
        String other$message = other.getMessage();
        if (this$message == null ? other$message != null : !this$message.equals(other$message)) {
            return false;
        }
        String this$local = this.getLocal();
        String other$local = other.getLocal();
        return !(this$local == null ? other$local != null : !this$local.equals(other$local));
    }

    protected boolean canEqual(Object other) {
        return other instanceof BusinessException;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getCode();
        String $message = this.getMessage();
        result = result * 59 + ($message == null ? 43 : $message.hashCode());
        String $local = this.getLocal();
        result = result * 59 + ($local == null ? 43 : $local.hashCode());
        return result;
    }

    public BusinessException(@NonNull int code, @NonNull String message, @NonNull String local) {
        if (message == null) {
            throw new NullPointerException("message is marked non-null but is null");
        }
        if (local == null) {
            throw new NullPointerException("local is marked non-null but is null");
        }
        this.code = code;
        this.message = message;
        this.local = local;
    }
}

