/*
 * Decompiled with CFR 0.152.
 */
package com.scin.sdk.utils;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.Feature;
import com.scin.sdk.api.Authority;
import com.scin.sdk.api.RestResponse;
import com.scin.sdk.enums.SystemStatusEnum;
import com.scin.sdk.exception.BusinessException;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpUtil {
    private static final OkHttpClient CLIENT = new OkHttpClient();
    private static final Logger log = LoggerFactory.getLogger(HttpUtil.class);
    private static final MediaType JSON = MediaType.parse((String)"application/json; charset=utf-8");

    public static Authority sign(String url, Object params) {
        log.info("\u8fde\u63a5URL={}", (Object)url);
        log.info("============================================");
        try {
            String content = JSONObject.toJSONString((Object)params);
            RequestBody requestBody = RequestBody.create((MediaType)JSON, (String)content);
            Request.Builder requestBuilder = new Request.Builder().url(url).post(requestBody);
            Request request = requestBuilder.build();
            Response response = CLIENT.newCall(request).execute();
            log.info("\u8bf7\u6c42JSON:{}", (Object)content);
            log.info("\u8fd4\u56deCODE:{}", (Object)response.code());
            log.info("============================================");
            if (response.code() != 200) {
                throw BusinessException.of(SystemStatusEnum.APP_USER_NOT_AUTHORIZED);
            }
            RestResponse r = (RestResponse)JSONObject.parseObject((byte[])response.body().bytes(), RestResponse.class, (Feature[])new Feature[0]);
            if (r.getCode() != 1) {
                throw BusinessException.of(r.getCode(), r.getMessage(), r.getLocal());
            }
            return r.getData();
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }
}

