/*
 * Decompiled with CFR 0.152.
 */
package com.github.myzhan.locust4j.taskset;

import com.github.myzhan.locust4j.AbstractTask;
import com.github.myzhan.locust4j.taskset.AbstractTaskSet;
import java.util.Map;
import java.util.NavigableMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WeighingTaskSet
extends AbstractTaskSet {
    private static final Logger logger = LoggerFactory.getLogger(WeighingTaskSet.class);
    private final int weight;
    private final String name;
    private final NavigableMap<Integer, AbstractTask> randomMap = new ConcurrentSkipListMap<Integer, AbstractTask>();
    private final AtomicInteger offset = new AtomicInteger(0);

    public WeighingTaskSet(String name, int weight) {
        this.name = name;
        this.weight = weight;
    }

    @Override
    public void addTask(AbstractTask task) {
        if (task.getWeight() <= 0) {
            logger.error("The weight of task {} is {}, ignored.", (Object)task.getName(), (Object)task.getWeight());
            return;
        }
        this.tasks.add(task);
        Integer nextOffset = this.offset.addAndGet(task.getWeight());
        this.randomMap.put(nextOffset, task);
    }

    public AbstractTask getTask(int roll) {
        if (roll < 0 || roll >= this.offset.get()) {
            return null;
        }
        Map.Entry<Integer, AbstractTask> entry = this.randomMap.higherEntry(roll);
        if (null == entry) {
            return null;
        }
        return entry.getValue();
    }

    @Override
    public int getWeight() {
        return this.weight;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void execute() throws Exception {
        int roll = ThreadLocalRandom.current().nextInt(this.offset.get());
        AbstractTask task = this.getTask(roll);
        task.execute();
    }
}

