/*
 * Decompiled with CFR 0.152.
 */
package com.github.myzhan.locust4j.message;

import com.github.myzhan.locust4j.message.Visitor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.msgpack.core.MessageBufferPacker;
import org.msgpack.core.MessageFormat;
import org.msgpack.core.MessagePack;
import org.msgpack.core.MessagePacker;
import org.msgpack.core.MessageUnpacker;

public class Message {
    private final String type;
    private final Map<String, Object> data;
    private int version;
    private final String nodeID;
    private static final String TYPE_CLIENT_READY = "client_ready";

    public Message(String type, Map<String, Object> data, int version, String nodeID) {
        this.type = type;
        this.data = data;
        this.version = version;
        this.nodeID = nodeID;
    }

    public Message(byte[] bytes) throws IOException {
        MessageUnpacker unpacker = MessagePack.newDefaultUnpacker((byte[])bytes);
        int arrayHeader = unpacker.unpackArrayHeader();
        this.type = unpacker.unpackString();
        if (unpacker.getNextFormat() != MessageFormat.NIL) {
            this.data = Message.unpackMap(unpacker);
        } else {
            unpacker.unpackNil();
            this.data = null;
        }
        if (unpacker.getNextFormat() != MessageFormat.NIL) {
            this.nodeID = unpacker.unpackString();
        } else {
            unpacker.unpackNil();
            this.nodeID = null;
        }
        unpacker.close();
    }

    public static Map<String, Object> unpackMap(MessageUnpacker unpacker) throws IOException {
        HashMap<String, Object> result = new HashMap<String, Object>(6);
        for (int mapSize = unpacker.unpackMapHeader(); mapSize > 0; --mapSize) {
            ArrayList<String> value;
            String key = null;
            if (unpacker.getNextFormat() == MessageFormat.NIL) {
                unpacker.unpackNil();
            } else {
                key = unpacker.unpackString();
            }
            MessageFormat messageFormat = unpacker.getNextFormat();
            switch (messageFormat.getValueType()) {
                case BOOLEAN: {
                    value = unpacker.unpackBoolean();
                    break;
                }
                case FLOAT: {
                    value = Float.valueOf(unpacker.unpackFloat());
                    break;
                }
                case INTEGER: {
                    value = unpacker.unpackInt();
                    break;
                }
                case NIL: {
                    value = null;
                    unpacker.unpackNil();
                    break;
                }
                case STRING: {
                    value = unpacker.unpackString();
                    break;
                }
                case MAP: {
                    value = Message.unpackMap(unpacker);
                    break;
                }
                case ARRAY: {
                    int size = unpacker.unpackArrayHeader();
                    value = new ArrayList<String>(size);
                    for (int index = 0; index < size; ++index) {
                        value.add(unpacker.unpackString());
                    }
                    break;
                }
                default: {
                    throw new IOException("Message received unsupported type: " + messageFormat.getValueType());
                }
            }
            if (null == key) continue;
            result.put(key, value);
        }
        return result;
    }

    public String getType() {
        return this.type;
    }

    public Map<String, Object> getData() {
        return this.data;
    }

    public String getNodeID() {
        return this.nodeID;
    }

    public byte[] getBytes() throws IOException {
        MessageBufferPacker packer = MessagePack.newDefaultBufferPacker();
        Visitor visitor = new Visitor((MessagePacker)packer);
        packer.packArrayHeader(3);
        packer.packString(this.type);
        if (TYPE_CLIENT_READY.equals(this.type)) {
            if (this.version == -1) {
                packer.packInt(this.version);
            } else {
                packer.packNil();
            }
        } else if (this.data != null) {
            packer.packMapHeader(this.data.size());
            for (Map.Entry<String, Object> entry : this.data.entrySet()) {
                packer.packString(entry.getKey());
                visitor.visit(entry.getValue());
            }
        } else {
            packer.packNil();
        }
        packer.packString(this.nodeID);
        byte[] bytes = packer.toByteArray();
        packer.close();
        return bytes;
    }

    public String toString() {
        return String.format("%s-%s-%s", this.nodeID, this.type, this.data);
    }
}

