/*
 * Decompiled with CFR 0.152.
 */
package com.github.myzhan.locust4j.stats;

import com.github.myzhan.locust4j.stats.RequestFailure;
import com.github.myzhan.locust4j.stats.RequestSuccess;
import com.github.myzhan.locust4j.stats.StatsEntry;
import com.github.myzhan.locust4j.stats.StatsError;
import com.github.myzhan.locust4j.utils.Utils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Stats
implements Runnable {
    private static final Logger logger = LoggerFactory.getLogger(Stats.class);
    private Map<String, StatsEntry> entries;
    private Map<String, StatsError> errors;
    private StatsEntry total;
    private final ConcurrentLinkedQueue<RequestSuccess> reportSuccessQueue;
    private final ConcurrentLinkedQueue<RequestFailure> reportFailureQueue;
    private final ConcurrentLinkedQueue<Boolean> clearStatsQueue;
    private final ConcurrentLinkedQueue<Boolean> timeToReportQueue;
    private final BlockingQueue<Map<String, Object>> messageToRunnerQueue;
    private ExecutorService threadPool;
    private final AtomicInteger threadNumber;
    private final Object lock = new Object();

    public Stats() {
        this.reportSuccessQueue = new ConcurrentLinkedQueue();
        this.reportFailureQueue = new ConcurrentLinkedQueue();
        this.clearStatsQueue = new ConcurrentLinkedQueue();
        this.timeToReportQueue = new ConcurrentLinkedQueue();
        this.messageToRunnerQueue = new LinkedBlockingDeque<Map<String, Object>>();
        this.threadNumber = new AtomicInteger();
        this.entries = new HashMap<String, StatsEntry>(8);
        this.errors = new HashMap<String, StatsError>(8);
        this.total = new StatsEntry("Total");
        this.total.reset();
    }

    public static Stats getInstance() {
        return StatsInstanceHolder.INSTANCE;
    }

    public void start() {
        this.threadPool = new ThreadPoolExecutor(2, Integer.MAX_VALUE, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                Thread thread = new Thread(r);
                thread.setName(String.format("locust4j-stats#%d#", Stats.this.threadNumber.getAndIncrement()));
                return thread;
            }
        });
        this.threadPool.submit(new StatsTimer(this));
        this.threadPool.submit(this);
    }

    public void stop() {
        this.threadPool.shutdownNow();
    }

    public Queue<RequestSuccess> getReportSuccessQueue() {
        return this.reportSuccessQueue;
    }

    public Queue<RequestFailure> getReportFailureQueue() {
        return this.reportFailureQueue;
    }

    public Queue<Boolean> getClearStatsQueue() {
        return this.clearStatsQueue;
    }

    public BlockingQueue<Map<String, Object>> getMessageToRunnerQueue() {
        return this.messageToRunnerQueue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void wakeMeUp() {
        Object object = this.lock;
        synchronized (object) {
            this.lock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sleep() {
        Object object = this.lock;
        synchronized (object) {
            try {
                this.lock.wait();
            }
            catch (Exception ex) {
                logger.error(ex.getMessage());
            }
        }
    }

    @Override
    public void run() {
        String name = Thread.currentThread().getName();
        Thread.currentThread().setName(name + "stats");
        while (true) {
            Boolean timeToReport;
            Boolean needToClearStats;
            RequestFailure failureMessage;
            boolean allEmpty = true;
            RequestSuccess successMessage = this.reportSuccessQueue.poll();
            if (successMessage != null) {
                this.logRequest(successMessage.getRequestType(), successMessage.getName(), successMessage.getResponseTime(), successMessage.getContentLength());
                allEmpty = false;
            }
            if (null != (failureMessage = this.reportFailureQueue.poll())) {
                this.logRequest(failureMessage.getRequestType(), failureMessage.getName(), failureMessage.getResponseTime(), 0L);
                this.logError(failureMessage.getRequestType(), failureMessage.getName(), failureMessage.getError());
                allEmpty = false;
            }
            if (null != (needToClearStats = this.clearStatsQueue.poll()) && needToClearStats.booleanValue()) {
                this.clearAll();
                allEmpty = false;
            }
            if (null != (timeToReport = this.timeToReportQueue.poll())) {
                Map<String, Object> data = this.collectReportData();
                this.messageToRunnerQueue.add(data);
                allEmpty = false;
            }
            if (!allEmpty) continue;
            this.sleep();
        }
    }

    protected StatsEntry getTotal() {
        return this.total;
    }

    protected StatsEntry get(String name, String method) {
        StatsEntry entry = this.entries.get(name + method);
        if (null == entry) {
            entry = new StatsEntry(name, method);
            entry.reset();
            this.entries.put(name + method, entry);
        }
        return entry;
    }

    public void logRequest(String method, String name, long responseTime, long contentLength) {
        this.total.log(responseTime, contentLength);
        this.get(name, method).log(responseTime, contentLength);
    }

    public void logError(String method, String name, String error) {
        StatsError entry;
        this.total.logError(error);
        this.get(name, method).logError(error);
        String key = Utils.md5(method, name, error);
        if (null == key) {
            key = method + name + error;
        }
        if (null == (entry = this.errors.get(key))) {
            entry = new StatsError(name, method, error);
            this.errors.put(key, entry);
        }
        entry.occured();
    }

    public void clearAll() {
        this.total = new StatsEntry("Total");
        this.total.reset();
        this.entries = new HashMap<String, StatsEntry>(8);
        this.errors = new HashMap<String, StatsError>(8);
    }

    protected List<Map<String, Object>> serializeStats() {
        ArrayList<Map<String, Object>> entries = new ArrayList<Map<String, Object>>(this.entries.size());
        for (Map.Entry<String, StatsEntry> item : this.entries.entrySet()) {
            StatsEntry entry = item.getValue();
            if (entry.getNumRequests() == 0L && entry.getNumFailures() == 0L) continue;
            entries.add(entry.getStrippedReport());
        }
        return entries;
    }

    public Map<String, Map<String, Object>> serializeErrors() {
        HashMap<String, Map<String, Object>> errors = new HashMap<String, Map<String, Object>>(8);
        for (Map.Entry<String, StatsError> item : this.errors.entrySet()) {
            String key = item.getKey();
            StatsError error = item.getValue();
            errors.put(key, error.toMap());
        }
        return errors;
    }

    protected Map<String, Object> collectReportData() {
        HashMap<String, Object> data = new HashMap<String, Object>(3);
        data.put("stats", this.serializeStats());
        data.put("stats_total", this.total.getStrippedReport());
        data.put("errors", this.serializeErrors());
        this.errors.clear();
        return data;
    }

    private static class StatsInstanceHolder {
        private static final Stats INSTANCE = new Stats();

        private StatsInstanceHolder() {
        }
    }

    private static class StatsTimer
    implements Runnable {
        private static final int SLAVE_REPORT_INTERVAL = 3000;
        protected Stats stats;

        private StatsTimer(Stats stats) {
            this.stats = stats;
        }

        @Override
        public void run() {
            String name = Thread.currentThread().getName();
            Thread.currentThread().setName(name + "stats-timer");
            while (true) {
                try {
                    Thread.sleep(3000L);
                }
                catch (InterruptedException ex) {
                    return;
                }
                catch (Exception ex) {
                    logger.error(ex.getMessage());
                }
                this.stats.timeToReportQueue.offer(true);
                this.stats.wakeMeUp();
            }
        }
    }
}

