/*
 * Decompiled with CFR 0.152.
 */
package com.github.nagyesta.lowkeyvault.http;

import com.azure.core.http.HttpClient;
import com.azure.core.http.HttpRequest;
import com.azure.core.util.FluxUtil;
import com.github.nagyesta.lowkeyvault.http.ApacheHttpRequest;
import com.github.nagyesta.lowkeyvault.http.ApacheHttpResponse;
import com.github.nagyesta.lowkeyvault.http.ContentLengthHeaderRemover;
import com.github.nagyesta.lowkeyvault.http.management.LowkeyVaultException;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Objects;
import java.util.function.UnaryOperator;
import javax.net.ssl.HostnameVerifier;
import org.apache.http.HttpEntity;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.TrustStrategy;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.ssl.SSLContextBuilder;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public final class ApacheHttpClient
implements HttpClient {
    private final org.apache.http.client.HttpClient httpClient;
    private final UnaryOperator<URI> authorityOverrideFunction;

    public ApacheHttpClient(UnaryOperator<URI> authorityOverrideFunction, TrustStrategy trustStrategy, HostnameVerifier hostnameVerifier) {
        try {
            this.authorityOverrideFunction = Objects.requireNonNull(authorityOverrideFunction);
            SSLContextBuilder builder = new SSLContextBuilder();
            builder.loadTrustMaterial(null, (org.apache.http.ssl.TrustStrategy)trustStrategy);
            SSLConnectionSocketFactory socketFactory = new SSLConnectionSocketFactory(builder.build(), hostnameVerifier);
            this.httpClient = HttpClients.custom().addInterceptorFirst((HttpRequestInterceptor)new ContentLengthHeaderRemover()).setSSLSocketFactory((LayeredConnectionSocketFactory)socketFactory).build();
        }
        catch (Exception e) {
            throw new LowkeyVaultException("Failed to create HTTP client.", e);
        }
    }

    ApacheHttpClient(org.apache.http.client.HttpClient httpClient, UnaryOperator<URI> authorityOverrideFunction) {
        this.httpClient = Objects.requireNonNull(httpClient);
        this.authorityOverrideFunction = Objects.requireNonNull(authorityOverrideFunction);
    }

    public Mono<com.azure.core.http.HttpResponse> send(HttpRequest azureRequest) {
        try {
            ApacheHttpRequest apacheRequest = new ApacheHttpRequest(azureRequest.getHttpMethod(), azureRequest.getUrl(), azureRequest.getHeaders(), this.authorityOverrideFunction);
            Mono bodyMono = azureRequest.getBody() != null ? FluxUtil.collectBytesInByteBufferStream((Flux)azureRequest.getBody()) : Mono.just((Object)new byte[0]);
            return bodyMono.flatMap(bodyBytes -> {
                apacheRequest.setEntity((HttpEntity)new ByteArrayEntity(bodyBytes));
                try {
                    HttpResponse response = this.httpClient.execute((HttpUriRequest)apacheRequest);
                    return Mono.just((Object)((Object)new ApacheHttpResponse(azureRequest, response)));
                }
                catch (IOException ex) {
                    return Mono.error((Throwable)ex);
                }
            });
        }
        catch (URISyntaxException e) {
            return Mono.error((Throwable)e);
        }
    }
}

