/*
 * Decompiled with CFR 0.152.
 */
package com.github.nagyesta.lowkeyvault.http;

import com.azure.core.credential.BasicAuthenticationCredential;
import com.azure.core.credential.TokenCredential;
import com.azure.core.http.HttpClient;
import com.azure.core.http.policy.FixedDelay;
import com.azure.core.http.policy.RetryPolicy;
import com.azure.core.http.policy.RetryStrategy;
import com.azure.security.keyvault.certificates.CertificateAsyncClient;
import com.azure.security.keyvault.certificates.CertificateClient;
import com.azure.security.keyvault.certificates.CertificateClientBuilder;
import com.azure.security.keyvault.certificates.CertificateServiceVersion;
import com.azure.security.keyvault.keys.KeyAsyncClient;
import com.azure.security.keyvault.keys.KeyClient;
import com.azure.security.keyvault.keys.KeyClientBuilder;
import com.azure.security.keyvault.keys.KeyServiceVersion;
import com.azure.security.keyvault.keys.cryptography.CryptographyAsyncClient;
import com.azure.security.keyvault.keys.cryptography.CryptographyClient;
import com.azure.security.keyvault.keys.cryptography.CryptographyClientBuilder;
import com.azure.security.keyvault.keys.cryptography.CryptographyServiceVersion;
import com.azure.security.keyvault.secrets.SecretAsyncClient;
import com.azure.security.keyvault.secrets.SecretClient;
import com.azure.security.keyvault.secrets.SecretClientBuilder;
import com.azure.security.keyvault.secrets.SecretServiceVersion;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.nagyesta.lowkeyvault.http.ApacheHttpClient;
import com.github.nagyesta.lowkeyvault.http.management.LowkeyVaultManagementClient;
import com.github.nagyesta.lowkeyvault.http.management.impl.LowkeyVaultManagementClientImpl;
import java.net.URI;
import java.time.Duration;
import java.util.Objects;
import java.util.Optional;
import java.util.function.UnaryOperator;
import javax.net.ssl.HostnameVerifier;
import lombok.Generated;
import org.apache.http.conn.ssl.DefaultHostnameVerifier;
import org.apache.http.conn.ssl.TrustSelfSignedStrategy;
import org.apache.http.conn.ssl.TrustStrategy;

public final class ApacheHttpClientProvider {
    private static final String DUMMY = "dummy";
    private final String vaultUrl;
    private final UnaryOperator<URI> hostOverrideFunction;
    private final TrustStrategy trustStrategy;
    private final HostnameVerifier hostnameVerifier;

    public ApacheHttpClientProvider(String vaultUrl) {
        this(vaultUrl, null);
    }

    public ApacheHttpClientProvider(String vaultUrl, UnaryOperator<URI> hostOverrideFunction) {
        this(vaultUrl, hostOverrideFunction, null, null);
    }

    public ApacheHttpClientProvider(String vaultUrl, UnaryOperator<URI> hostOverrideFunction, TrustStrategy trustStrategy, HostnameVerifier hostnameVerifier) {
        this.vaultUrl = vaultUrl;
        this.hostOverrideFunction = Optional.ofNullable(hostOverrideFunction).orElse(uri -> uri);
        this.trustStrategy = Optional.ofNullable(trustStrategy).orElse((TrustStrategy)new TrustSelfSignedStrategy());
        this.hostnameVerifier = Optional.ofNullable(hostnameVerifier).orElse((HostnameVerifier)new DefaultHostnameVerifier());
    }

    public HttpClient createInstance() {
        return new ApacheHttpClient(this.hostOverrideFunction, this.trustStrategy, this.hostnameVerifier);
    }

    public LowkeyVaultManagementClient getLowkeyVaultManagementClient(ObjectMapper objectMapper) {
        return new LowkeyVaultManagementClientImpl(this.vaultUrl, this.createInstance(), objectMapper);
    }

    public KeyAsyncClient getKeyAsyncClient() {
        return this.getKeyAsyncClient(KeyServiceVersion.V7_4);
    }

    public KeyAsyncClient getKeyAsyncClient(KeyServiceVersion version) {
        return this.getKeyBuilder().serviceVersion(version).buildAsyncClient();
    }

    public KeyClient getKeyClient() {
        return this.getKeyClient(KeyServiceVersion.V7_4);
    }

    public KeyClient getKeyClient(KeyServiceVersion version) {
        return this.getKeyBuilder().serviceVersion(version).buildClient();
    }

    public CertificateAsyncClient getCertificateAsyncClient() {
        return this.getCertificateAsyncClient(CertificateServiceVersion.V7_4);
    }

    public CertificateAsyncClient getCertificateAsyncClient(CertificateServiceVersion version) {
        return this.getCertificateBuilder().serviceVersion(version).buildAsyncClient();
    }

    public CertificateClient getCertificateClient() {
        return this.getCertificateClient(CertificateServiceVersion.V7_4);
    }

    public CertificateClient getCertificateClient(CertificateServiceVersion version) {
        return this.getCertificateBuilder().serviceVersion(version).buildClient();
    }

    public SecretAsyncClient getSecretAsyncClient() {
        return this.getSecretAsyncClient(SecretServiceVersion.V7_4);
    }

    public SecretAsyncClient getSecretAsyncClient(SecretServiceVersion version) {
        return this.getSecretBuilder().serviceVersion(version).buildAsyncClient();
    }

    public SecretClient getSecretClient() {
        return this.getSecretClient(SecretServiceVersion.V7_4);
    }

    public SecretClient getSecretClient(SecretServiceVersion version) {
        return this.getSecretBuilder().serviceVersion(version).buildClient();
    }

    public CryptographyAsyncClient getCryptoAsyncClient(String webKeyId) {
        return this.getCryptoAsyncClient(webKeyId, CryptographyServiceVersion.V7_4);
    }

    public CryptographyAsyncClient getCryptoAsyncClient(String webKeyId, CryptographyServiceVersion version) {
        return this.getCryptoBuilder(webKeyId).serviceVersion(version).buildAsyncClient();
    }

    public CryptographyClient getCryptoClient(String webKeyId) {
        return this.getCryptoClient(webKeyId, CryptographyServiceVersion.V7_4);
    }

    public CryptographyClient getCryptoClient(String webKeyId, CryptographyServiceVersion version) {
        return this.getCryptoBuilder(webKeyId).serviceVersion(version).buildClient();
    }

    private KeyClientBuilder getKeyBuilder() {
        return new KeyClientBuilder().vaultUrl(this.getVaultUrl()).credential((TokenCredential)this.getCredential()).httpClient(this.createInstance()).disableChallengeResourceVerification().retryPolicy(this.getRetryPolicy());
    }

    private CertificateClientBuilder getCertificateBuilder() {
        return new CertificateClientBuilder().vaultUrl(this.getVaultUrl()).credential((TokenCredential)this.getCredential()).httpClient(this.createInstance()).disableChallengeResourceVerification().retryPolicy(this.getRetryPolicy());
    }

    private SecretClientBuilder getSecretBuilder() {
        return new SecretClientBuilder().vaultUrl(this.getVaultUrl()).credential((TokenCredential)this.getCredential()).httpClient(this.createInstance()).disableChallengeResourceVerification().retryPolicy(this.getRetryPolicy());
    }

    private CryptographyClientBuilder getCryptoBuilder(String webKeyId) {
        return new CryptographyClientBuilder().keyIdentifier(Objects.requireNonNull(webKeyId)).credential((TokenCredential)this.getCredential()).httpClient(this.createInstance()).disableChallengeResourceVerification().retryPolicy(this.getRetryPolicy());
    }

    private RetryPolicy getRetryPolicy() {
        return new RetryPolicy((RetryStrategy)new FixedDelay(0, Duration.ZERO));
    }

    private BasicAuthenticationCredential getCredential() {
        return new BasicAuthenticationCredential(DUMMY, DUMMY);
    }

    @Generated
    public String getVaultUrl() {
        return this.vaultUrl;
    }
}

