/*
 * Decompiled with CFR 0.152.
 */
package com.github.nagyesta.lowkeyvault.http;

import com.azure.core.http.HttpHeaders;
import com.azure.core.http.HttpMethod;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Objects;
import java.util.function.UnaryOperator;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;

final class ApacheHttpRequest
extends HttpEntityEnclosingRequestBase {
    private final String method;

    ApacheHttpRequest(HttpMethod method, URL url, HttpHeaders headers, UnaryOperator<URI> authorityOverrideFunction) throws URISyntaxException {
        this.method = method.name();
        URI uri = Objects.requireNonNull(url).toURI();
        URI overrideUri = (URI)Objects.requireNonNull(authorityOverrideFunction).apply(uri);
        this.setURI(overrideUri);
        headers.stream().forEach(header -> this.addHeader(header.getName(), header.getValue()));
        this.addHeader("Host", url.getAuthority());
    }

    public String getMethod() {
        return this.method;
    }
}

