/*
 * Decompiled with CFR 0.152.
 */
package com.github.nagyesta.lowkeyvault.http;

import com.azure.core.http.HttpHeaderName;
import com.azure.core.http.HttpHeaders;
import com.azure.core.http.HttpRequest;
import com.azure.core.http.HttpResponse;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Optional;
import org.apache.http.HttpEntity;
import org.apache.http.entity.StringEntity;
import org.apache.http.util.EntityUtils;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

final class ApacheHttpResponse
extends HttpResponse {
    private final int statusCode;
    private final HttpHeaders headers;
    private final String entity;

    ApacheHttpResponse(HttpRequest request, org.apache.http.HttpResponse apacheResponse) throws IOException {
        super(request);
        this.statusCode = apacheResponse.getStatusLine().getStatusCode();
        this.headers = new HttpHeaders();
        Arrays.stream(apacheResponse.getAllHeaders()).forEach(header -> this.headers.set(HttpHeaderName.fromString((String)header.getName()), header.getValue()));
        HttpEntity responseEntity = Optional.ofNullable(apacheResponse.getEntity()).orElse((HttpEntity)new StringEntity(""));
        this.entity = EntityUtils.toString((HttpEntity)responseEntity, (Charset)StandardCharsets.UTF_8);
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public String getHeaderValue(String s) {
        return this.getHeaders().getValue(HttpHeaderName.fromString((String)s));
    }

    public HttpHeaders getHeaders() {
        return this.headers;
    }

    public Flux<ByteBuffer> getBody() {
        return this.getBodyAsByteArray().map(ByteBuffer::wrap).flux();
    }

    public Mono<byte[]> getBodyAsByteArray() {
        return Mono.just((Object)this.entity.getBytes(StandardCharsets.UTF_8));
    }

    public Mono<String> getBodyAsString() {
        return this.getBodyAsString(StandardCharsets.UTF_8);
    }

    public Mono<String> getBodyAsString(Charset charset) {
        return this.getBodyAsByteArray().map(bytes -> new String((byte[])bytes, charset));
    }
}

