/*
 * Decompiled with CFR 0.152.
 */
package com.github.nagyesta.lowkeyvault.http.management;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.Optional;

public class EpochSecondsSerializer
extends JsonSerializer<OffsetDateTime> {
    public void serialize(OffsetDateTime value, JsonGenerator generator, SerializerProvider provider) throws IOException {
        Optional<Long> optionalEpochSeconds = Optional.ofNullable(value).map(OffsetDateTime::toEpochSecond);
        if (optionalEpochSeconds.isPresent()) {
            generator.writeNumber(optionalEpochSeconds.get().longValue());
        } else {
            generator.writeNull();
        }
    }
}

