/*
 * Decompiled with CFR 0.152.
 */
package com.github.nagyesta.lowkeyvault.http.management;

import java.net.URI;
import lombok.Generated;
import lombok.NonNull;

public final class TimeShiftContext {
    private final int seconds;
    private final boolean regenerateCertificates;
    private final URI vaultBaseUri;

    private TimeShiftContext(int seconds, URI vaultBaseUri, boolean regenerateCertificates) {
        this.seconds = seconds;
        this.vaultBaseUri = vaultBaseUri;
        this.regenerateCertificates = regenerateCertificates;
    }

    public static TimeShiftContextBuilder builder() {
        return new TimeShiftContextBuilder();
    }

    @Generated
    public int getSeconds() {
        return this.seconds;
    }

    @Generated
    public boolean isRegenerateCertificates() {
        return this.regenerateCertificates;
    }

    @Generated
    public URI getVaultBaseUri() {
        return this.vaultBaseUri;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TimeShiftContext)) {
            return false;
        }
        TimeShiftContext other = (TimeShiftContext)o;
        if (this.getSeconds() != other.getSeconds()) {
            return false;
        }
        if (this.isRegenerateCertificates() != other.isRegenerateCertificates()) {
            return false;
        }
        URI this$vaultBaseUri = this.getVaultBaseUri();
        URI other$vaultBaseUri = other.getVaultBaseUri();
        return !(this$vaultBaseUri == null ? other$vaultBaseUri != null : !((Object)this$vaultBaseUri).equals(other$vaultBaseUri));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getSeconds();
        result = result * 59 + (this.isRegenerateCertificates() ? 79 : 97);
        URI $vaultBaseUri = this.getVaultBaseUri();
        result = result * 59 + ($vaultBaseUri == null ? 43 : ((Object)$vaultBaseUri).hashCode());
        return result;
    }

    public static final class TimeShiftContextBuilder {
        private static final int SECONDS_PER_MINUTE = 60;
        private static final int MINUTES_PER_HOUR = 60;
        private static final int HOURS_PER_DAY = 24;
        private int seconds;
        private URI vaultBaseUri;
        private boolean regenerateCertificates;

        TimeShiftContextBuilder() {
        }

        public TimeShiftContextBuilder addSeconds(int seconds) {
            if (seconds <= 0) {
                throw new IllegalArgumentException("Time shift amount must be positive.");
            }
            this.seconds += seconds;
            return this;
        }

        public TimeShiftContextBuilder addMinutes(int minutes) {
            return this.addSeconds(60 * minutes);
        }

        public TimeShiftContextBuilder addHours(int hours) {
            return this.addMinutes(60 * hours);
        }

        public TimeShiftContextBuilder addDays(int days) {
            return this.addHours(24 * days);
        }

        public TimeShiftContextBuilder regenerateCertificates() {
            this.regenerateCertificates = true;
            return this;
        }

        public TimeShiftContextBuilder vaultBaseUri(@NonNull URI vaultBaseUri) {
            if (vaultBaseUri == null) {
                throw new IllegalArgumentException("vaultBaseUri is marked non-null but is null");
            }
            this.vaultBaseUri = vaultBaseUri;
            return this;
        }

        public TimeShiftContext build() {
            return new TimeShiftContext(this.seconds, this.vaultBaseUri, this.regenerateCertificates);
        }
    }
}

