/*
 * Decompiled with CFR 0.152.
 */
package com.github.nagyesta.lowkeyvault.http.management.impl;

import com.azure.core.http.HttpClient;
import com.azure.core.http.HttpHeaderName;
import com.azure.core.http.HttpMethod;
import com.azure.core.http.HttpRequest;
import com.azure.core.http.HttpResponse;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.github.nagyesta.lowkeyvault.http.management.LowkeyVaultException;
import com.github.nagyesta.lowkeyvault.http.management.LowkeyVaultManagementClient;
import com.github.nagyesta.lowkeyvault.http.management.RecoveryLevel;
import com.github.nagyesta.lowkeyvault.http.management.TimeShiftContext;
import com.github.nagyesta.lowkeyvault.http.management.VaultModel;
import com.github.nagyesta.lowkeyvault.http.management.impl.ResponseEntity;
import com.github.nagyesta.lowkeyvault.http.management.impl.UriUtil;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.TreeMap;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import lombok.Generated;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.util.annotation.Nullable;

public final class LowkeyVaultManagementClientImpl
implements LowkeyVaultManagementClient {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(LowkeyVaultManagementClientImpl.class);
    private static final String PING_PATH = "/ping";
    private static final String MANAGEMENT_VAULT_PATH = "/management/vault";
    private static final String MANAGEMENT_VAULT_DELETED_PATH = "/management/vault/deleted";
    private static final String MANAGEMENT_VAULT_RECOVERY_PATH = "/management/vault/recover";
    private static final String MANAGEMENT_VAULT_ALIAS_PATH = "/management/vault/alias";
    private static final String MANAGEMENT_VAULT_PURGE_PATH = "/management/vault/purge";
    private static final String MANAGEMENT_VAULT_TIME_PATH = "/management/vault/time";
    private static final String MANAGEMENT_VAULT_TIME_ALL_PATH = "/management/vault/time/all";
    private static final String MANAGEMENT_VAULT_EXPORT_ACTIVE_PATH = "/management/vault/export";
    private static final String BASE_URI_QUERY_PARAM = "baseUri";
    private static final String ALIAS_URI_ADD_QUERY_PARAM = "add";
    private static final String ALIAS_URI_REMOVE_QUERY_PARAM = "remove";
    private static final String SECONDS_QUERY_PARAM = "seconds";
    private static final String REGENERATE_CERTS_QUERY_PARAM = "regenerateCertificates";
    private final String vaultUrl;
    private final HttpClient instance;
    private final ObjectReader objectReader;
    private final ObjectWriter objectWriter;

    public LowkeyVaultManagementClientImpl(@NonNull String vaultUrl, @NonNull HttpClient instance, @NonNull ObjectMapper objectMapper) {
        if (vaultUrl == null) {
            throw new IllegalArgumentException("vaultUrl is marked non-null but is null");
        }
        if (instance == null) {
            throw new IllegalArgumentException("instance is marked non-null but is null");
        }
        if (objectMapper == null) {
            throw new IllegalArgumentException("objectMapper is marked non-null but is null");
        }
        this.vaultUrl = vaultUrl;
        this.instance = instance;
        this.objectReader = objectMapper.reader();
        this.objectWriter = objectMapper.writer();
    }

    @Override
    public <T extends Throwable> void verifyConnectivity(int retries, int waitMillis, @NonNull Supplier<T> exceptionProvider) throws T, InterruptedException {
        if (exceptionProvider == null) {
            throw new IllegalArgumentException("exceptionProvider is marked non-null but is null");
        }
        HttpRequest request = new HttpRequest(HttpMethod.GET, this.vaultUrl + PING_PATH);
        for (int i = 0; i < retries; ++i) {
            Thread.sleep(waitMillis);
            if (!this.isSuccessful(this.doSend(request))) continue;
            return;
        }
        throw (Throwable)exceptionProvider.get();
    }

    @Override
    public VaultModel createVault(@NonNull URI baseUri, @NonNull RecoveryLevel recoveryLevel, @Nullable Integer recoverableDays) {
        if (baseUri == null) {
            throw new IllegalArgumentException("baseUri is marked non-null but is null");
        }
        if (recoveryLevel == null) {
            throw new IllegalArgumentException("recoveryLevel is marked non-null but is null");
        }
        String body = this.vaultModelAsString(baseUri, recoveryLevel, recoverableDays);
        URI uri = UriUtil.uriBuilderForPath(this.vaultUrl, MANAGEMENT_VAULT_PATH);
        HttpRequest request = new HttpRequest(HttpMethod.POST, uri.toString()).setBody(body).setHeader(HttpHeaderName.CONTENT_TYPE, "application/json");
        return this.sendAndProcess(request, r -> r.getResponseObject(VaultModel.class));
    }

    @Override
    public List<VaultModel> listVaults() {
        URI uri = UriUtil.uriBuilderForPath(this.vaultUrl, MANAGEMENT_VAULT_PATH);
        HttpRequest request = new HttpRequest(HttpMethod.GET, uri.toString());
        return this.sendAndProcess(request, r -> r.getResponseObject(ResponseEntity.VAULT_MODEL_LIST_TYPE_REF));
    }

    @Override
    public List<VaultModel> listDeletedVaults() {
        URI uri = UriUtil.uriBuilderForPath(this.vaultUrl, MANAGEMENT_VAULT_DELETED_PATH);
        HttpRequest request = new HttpRequest(HttpMethod.GET, uri.toString());
        return this.sendAndProcess(request, r -> r.getResponseObject(ResponseEntity.VAULT_MODEL_LIST_TYPE_REF));
    }

    @Override
    public boolean delete(@NonNull URI baseUri) {
        if (baseUri == null) {
            throw new IllegalArgumentException("baseUri is marked non-null but is null");
        }
        URI uri = UriUtil.uriBuilderForPath(this.vaultUrl, MANAGEMENT_VAULT_PATH, Map.of(BASE_URI_QUERY_PARAM, baseUri.toString()));
        HttpRequest request = new HttpRequest(HttpMethod.DELETE, uri.toString());
        return this.sendAndProcess(request, r -> r.getResponseObject(Boolean.class));
    }

    @Override
    public VaultModel recover(@NonNull URI baseUri) {
        if (baseUri == null) {
            throw new IllegalArgumentException("baseUri is marked non-null but is null");
        }
        Map<String, String> parameters = Map.of(BASE_URI_QUERY_PARAM, baseUri.toString());
        URI uri = UriUtil.uriBuilderForPath(this.vaultUrl, MANAGEMENT_VAULT_RECOVERY_PATH, parameters);
        HttpRequest request = new HttpRequest(HttpMethod.PUT, uri.toString()).setHeader(HttpHeaderName.CONTENT_TYPE, "application/json");
        return this.sendAndProcess(request, r -> r.getResponseObject(VaultModel.class));
    }

    @Override
    public VaultModel addAlias(@NonNull URI baseUri, @NonNull URI alias) {
        if (baseUri == null) {
            throw new IllegalArgumentException("baseUri is marked non-null but is null");
        }
        if (alias == null) {
            throw new IllegalArgumentException("alias is marked non-null but is null");
        }
        return this.performAliasUpdate(new TreeMap<String, String>(Map.of(BASE_URI_QUERY_PARAM, baseUri.toString(), ALIAS_URI_ADD_QUERY_PARAM, alias.toString())));
    }

    @Override
    public VaultModel removeAlias(@NonNull URI baseUri, @NonNull URI alias) {
        if (baseUri == null) {
            throw new IllegalArgumentException("baseUri is marked non-null but is null");
        }
        if (alias == null) {
            throw new IllegalArgumentException("alias is marked non-null but is null");
        }
        return this.performAliasUpdate(new TreeMap<String, String>(Map.of(BASE_URI_QUERY_PARAM, baseUri.toString(), ALIAS_URI_REMOVE_QUERY_PARAM, alias.toString())));
    }

    @Override
    public boolean purge(@NonNull URI baseUri) {
        if (baseUri == null) {
            throw new IllegalArgumentException("baseUri is marked non-null but is null");
        }
        Map<String, String> parameters = Map.of(BASE_URI_QUERY_PARAM, baseUri.toString());
        URI uri = UriUtil.uriBuilderForPath(this.vaultUrl, MANAGEMENT_VAULT_PURGE_PATH, parameters);
        HttpRequest request = new HttpRequest(HttpMethod.DELETE, uri.toString());
        return this.sendAndProcess(request, r -> r.getResponseObject(Boolean.class));
    }

    @Override
    public void timeShift(@NonNull TimeShiftContext context) {
        if (context == null) {
            throw new IllegalArgumentException("context is marked non-null but is null");
        }
        TreeMap<String, String> parameters = new TreeMap<String, String>();
        parameters.put(SECONDS_QUERY_PARAM, Integer.toString(context.getSeconds()));
        if (context.isRegenerateCertificates()) {
            parameters.put(REGENERATE_CERTS_QUERY_PARAM, Boolean.TRUE.toString());
        }
        Optional<URI> optionalURI = Optional.ofNullable(context.getVaultBaseUri());
        optionalURI.ifPresent(uri -> parameters.put(BASE_URI_QUERY_PARAM, uri.toString()));
        String path = optionalURI.map(u -> MANAGEMENT_VAULT_TIME_PATH).orElse(MANAGEMENT_VAULT_TIME_ALL_PATH);
        URI uri2 = UriUtil.uriBuilderForPath(this.vaultUrl, path, parameters);
        HttpRequest request = new HttpRequest(HttpMethod.PUT, uri2.toString()).setHeader(HttpHeaderName.CONTENT_TYPE, "application/json");
        this.sendRaw(request);
    }

    @Override
    public String exportActive() {
        URI uri = UriUtil.uriBuilderForPath(this.vaultUrl, MANAGEMENT_VAULT_EXPORT_ACTIVE_PATH);
        HttpRequest request = new HttpRequest(HttpMethod.GET, uri.toString());
        return this.sendRaw(request).getResponseBodyAsString();
    }

    @Override
    public String unpackBackup(byte[] backup) throws IOException {
        byte[] nonNullBackup = Optional.ofNullable(backup).orElseThrow(() -> new IllegalArgumentException("Backup cannot be null"));
        try (ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(nonNullBackup);){
            String string;
            try (GZIPInputStream gzipInputStream = new GZIPInputStream(byteArrayInputStream);){
                String json = new String(gzipInputStream.readAllBytes());
                string = this.objectReader.readTree(json).toPrettyString();
            }
            return string;
        }
    }

    @Override
    public byte[] compressBackup(@NonNull String backup) throws IOException {
        if (backup == null) {
            throw new IllegalArgumentException("backup is marked non-null but is null");
        }
        try (ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();){
            byte[] byArray;
            try (GZIPOutputStream gzipOutputStream = new GZIPOutputStream(byteArrayOutputStream);){
                gzipOutputStream.write(backup.getBytes(StandardCharsets.UTF_8));
                gzipOutputStream.flush();
                gzipOutputStream.finish();
                byArray = byteArrayOutputStream.toByteArray();
            }
            return byArray;
        }
    }

    private VaultModel performAliasUpdate(Map<String, String> parameters) {
        URI uri = UriUtil.uriBuilderForPath(this.vaultUrl, MANAGEMENT_VAULT_ALIAS_PATH, parameters);
        HttpRequest request = new HttpRequest(HttpMethod.PATCH, uri.toString()).setHeader(HttpHeaderName.CONTENT_TYPE, "application/json");
        return this.sendAndProcess(request, r -> r.getResponseObject(VaultModel.class));
    }

    String vaultModelAsString(URI baseUri, RecoveryLevel recoveryLevel, Integer recoverableDays) {
        try {
            return this.objectWriter.writeValueAsString((Object)new VaultModel(baseUri, null, recoveryLevel, recoverableDays, null, null));
        }
        catch (JsonProcessingException e) {
            throw new LowkeyVaultException("Cannot serialize model:", e);
        }
    }

    <T> T sendAndProcess(HttpRequest request, Function<ResponseEntity, T> conversionFunction) {
        ResponseEntity responseEntity = this.sendRaw(request);
        return conversionFunction.apply(responseEntity);
    }

    private ResponseEntity sendRaw(HttpRequest request) {
        ResponseEntity responseEntity = this.doSendNotNull(request);
        if (!responseEntity.isSuccessful()) {
            throw new LowkeyVaultException("Request was not successful. Status: " + responseEntity.getResponseCode());
        }
        return responseEntity;
    }

    private boolean isSuccessful(ResponseEntity responseEntity) {
        return Optional.ofNullable(responseEntity).map(ResponseEntity::isSuccessful).orElse(false);
    }

    private ResponseEntity doSend(HttpRequest request) {
        try {
            return this.doSendNotNull(request);
        }
        catch (LowkeyVaultException e) {
            return null;
        }
    }

    private ResponseEntity doSendNotNull(HttpRequest request) {
        ResponseEntity responseEntity;
        block8: {
            HttpResponse response = (HttpResponse)this.instance.send(request).block();
            try {
                responseEntity = new ResponseEntity(Objects.requireNonNull(response), this.objectReader);
                if (response == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    log.info("Call to container failed: {}", (Object)e.getMessage());
                    throw new LowkeyVaultException("Couldn't get a response due to an exception.", e);
                }
            }
            response.close();
        }
        return responseEntity;
    }
}

