/*
 * Decompiled with CFR 0.152.
 */
package com.github.nagyesta.lowkeyvault.http.management.impl;

import com.azure.core.http.HttpResponse;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectReader;
import com.github.nagyesta.lowkeyvault.http.management.LowkeyVaultException;
import com.github.nagyesta.lowkeyvault.http.management.VaultModel;
import java.nio.charset.StandardCharsets;
import java.util.List;
import lombok.Generated;
import lombok.NonNull;

final class ResponseEntity {
    public static final ListTypeReference VAULT_MODEL_LIST_TYPE_REF = new ListTypeReference();
    private final int responseCode;
    private final String responseBody;
    private final ObjectReader reader;

    ResponseEntity(@NonNull HttpResponse response, @NonNull ObjectReader reader) {
        if (response == null) {
            throw new IllegalArgumentException("response is marked non-null but is null");
        }
        if (reader == null) {
            throw new IllegalArgumentException("reader is marked non-null but is null");
        }
        this.responseBody = (String)response.getBodyAsString(StandardCharsets.UTF_8).block();
        this.responseCode = response.getStatusCode();
        this.reader = reader;
    }

    public boolean isSuccessful() {
        return this.responseCode >= 200 && this.responseCode < 300;
    }

    public <T> T getResponseObject(Class<T> type) {
        try {
            return (T)this.reader.forType(type).readValue(this.responseBody);
        }
        catch (JsonProcessingException e) {
            throw new LowkeyVaultException("Unable to map response entity.", e);
        }
    }

    public <T> T getResponseObject(TypeReference<T> type) {
        try {
            return (T)this.reader.forType(type).readValue(this.responseBody);
        }
        catch (JsonProcessingException e) {
            throw new LowkeyVaultException("Unable to map response entity.", e);
        }
    }

    public String getResponseBodyAsString() {
        return this.responseBody;
    }

    @Generated
    public int getResponseCode() {
        return this.responseCode;
    }

    public static class ListTypeReference
    extends TypeReference<List<VaultModel>> {
    }
}

