/*
 * Decompiled with CFR 0.152.
 */
package com.github.nagyesta.lowkeyvault.http.management.impl;

import com.github.nagyesta.lowkeyvault.http.management.LowkeyVaultException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import lombok.NonNull;
import org.apache.http.client.utils.URIBuilder;

public final class UriUtil {
    private UriUtil() {
        throw new IllegalCallerException("Utility cannot be instantiated.");
    }

    public static URI uriBuilderForPath(String baseUrl, String path) {
        return UriUtil.uriBuilderForPath(baseUrl, path, Map.of());
    }

    public static URI uriBuilderForPath(@NonNull String baseUrl, @NonNull String path, Map<String, String> parameters) {
        if (baseUrl == null) {
            throw new IllegalArgumentException("baseUrl is marked non-null but is null");
        }
        if (path == null) {
            throw new IllegalArgumentException("path is marked non-null but is null");
        }
        try {
            URIBuilder builder = new URIBuilder(baseUrl).setPath(path);
            Objects.requireNonNullElse(parameters, Collections.emptyMap()).forEach((arg_0, arg_1) -> ((URIBuilder)builder).addParameter(arg_0, arg_1));
            return builder.build();
        }
        catch (URISyntaxException e) {
            throw new LowkeyVaultException("Unable to parse baseUrl.", e);
        }
    }
}

