/*
 * Decompiled with CFR 0.152.
 */
package com.github.nagyesta.lowkeyvault.testcontainers;

import com.github.nagyesta.lowkeyvault.testcontainers.LowkeyVaultArgLineBuilder;
import com.github.nagyesta.lowkeyvault.testcontainers.LowkeyVaultContainerBuilder;
import java.io.ByteArrayInputStream;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.charset.StandardCharsets;
import java.security.KeyStore;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.testcontainers.containers.BindMode;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.wait.strategy.Wait;
import org.testcontainers.containers.wait.strategy.WaitStrategy;
import org.testcontainers.utility.DockerImageName;

public class LowkeyVaultContainer
extends GenericContainer<LowkeyVaultContainer> {
    static final DockerImageName DEFAULT_IMAGE_NAME = DockerImageName.parse((String)"nagyesta/lowkey-vault");
    private static final String DUMMY_USERNAME = "DUMMY";
    private static final String DUMMY_PASSWORD = "DUMMY";
    private static final int CONTAINER_PORT = 8443;
    private static final int CONTAINER_TOKEN_PORT = 8080;
    private static final String HTTP = "http://";
    private static final String HTTPS = "https://";
    private static final String PORT_SEPARATOR = ":";
    private static final String LOCALHOST = "localhost";
    private static final String DOT = ".";
    private static final String TOKEN_ENDPOINT_PATH = "/metadata/identity/oauth2/token";
    private final HttpClient httpClient = HttpClient.newHttpClient();

    @Deprecated
    public LowkeyVaultContainer(DockerImageName dockerImageName) {
        this(LowkeyVaultContainerBuilder.lowkeyVault(dockerImageName));
    }

    @Deprecated
    public LowkeyVaultContainer(DockerImageName dockerImageName, Set<String> vaultNames) {
        this(LowkeyVaultContainerBuilder.lowkeyVault(dockerImageName).vaultNames(vaultNames));
    }

    LowkeyVaultContainer(LowkeyVaultContainerBuilder containerBuilder) {
        super(containerBuilder.getDockerImageName());
        List<String> args;
        String absolutePath;
        containerBuilder.getDockerImageName().assertCompatibleWith(new DockerImageName[]{DEFAULT_IMAGE_NAME});
        if (containerBuilder.getHostPort() != null) {
            this.addFixedExposedPort(containerBuilder.getHostPort(), 8443);
        } else {
            this.addExposedPort(8443);
        }
        if (containerBuilder.getHostTokenPort() != null) {
            this.addFixedExposedPort(containerBuilder.getHostTokenPort(), 8080);
        } else {
            this.addExposedPort(8080);
        }
        if (containerBuilder.getImportFile() != null) {
            absolutePath = containerBuilder.getImportFile().getAbsolutePath();
            this.logger().info("Using path for import file: '{}'", (Object)absolutePath);
            this.withFileSystemBind(absolutePath, "/import/vaults.json", containerBuilder.getImportFileBindMode());
        }
        if (containerBuilder.getCustomSslCertStore() != null) {
            absolutePath = containerBuilder.getCustomSslCertStore().getAbsolutePath();
            this.logger().info("Using path for custom certificate: '{}'", (Object)absolutePath);
            this.withFileSystemBind(absolutePath, "/config/cert.store", BindMode.READ_ONLY);
        }
        if (containerBuilder.getExternalConfigFile() != null) {
            absolutePath = containerBuilder.getExternalConfigFile().getAbsolutePath();
            this.logger().info("Using path for external configuration: '{}'", (Object)absolutePath);
            this.withFileSystemBind(absolutePath, "/config/application.properties", BindMode.READ_ONLY);
        }
        if (!(args = new LowkeyVaultArgLineBuilder().vaultNames(Objects.requireNonNullElse(containerBuilder.getVaultNames(), Set.of())).aliases(containerBuilder.getAliasMap()).logicalHost(containerBuilder.getLogicalHost()).logicalPort(containerBuilder.getLogicalPort()).debug(containerBuilder.isDebug()).importFile(containerBuilder.getImportFile()).customSSLCertificate(containerBuilder.getCustomSslCertStore(), containerBuilder.getCustomSslCertPassword(), containerBuilder.getCustomSslCertType()).additionalArgs(containerBuilder.getAdditionalArgs()).build()).isEmpty()) {
            this.withEnv("LOWKEY_ARGS", String.join((CharSequence)" ", args));
        }
        this.waitingFor((WaitStrategy)Wait.forLogMessage((String)"(?s).*Started LowkeyVaultApp.*$", (int)1));
    }

    public String getDefaultVaultBaseUrl() {
        return HTTPS + this.getDefaultVaultAuthority();
    }

    public String getTokenEndpointBaseUrl() {
        return "http://localhost:" + this.getMappedPort(8080);
    }

    public String getTokenEndpointUrl() {
        return this.getTokenEndpointBaseUrl() + TOKEN_ENDPOINT_PATH;
    }

    public String getVaultBaseUrl(String vaultName) {
        return HTTPS + this.getVaultAuthority(vaultName);
    }

    public String getDefaultVaultAuthority() {
        return "localhost:8443";
    }

    public String getVaultAuthority(String vaultName) {
        return Objects.requireNonNull(vaultName) + ".localhost:8443";
    }

    public String getEndpointAuthority() {
        return this.getHost() + PORT_SEPARATOR + this.getMappedPort(8443);
    }

    public String getPassword() {
        return "DUMMY";
    }

    public String getUsername() {
        return "DUMMY";
    }

    public KeyStore getDefaultKeyStore() {
        HttpRequest request = HttpRequest.newBuilder().uri(URI.create(this.getTokenEndpointBaseUrl() + "/metadata/default-cert/lowkey-vault.p12")).GET().build();
        try {
            byte[] keyStoreBytes = this.httpClient.send(request, HttpResponse.BodyHandlers.ofByteArray()).body();
            KeyStore keyStore = KeyStore.getInstance("PKCS12");
            keyStore.load(new ByteArrayInputStream(keyStoreBytes), this.getDefaultKeyStorePassword().toCharArray());
            return keyStore;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to get default key store", e);
        }
    }

    public String getDefaultKeyStorePassword() {
        HttpRequest request = HttpRequest.newBuilder().uri(URI.create(this.getTokenEndpointBaseUrl() + "/metadata/default-cert/password")).GET().build();
        try {
            return this.httpClient.send(request, HttpResponse.BodyHandlers.ofString(StandardCharsets.UTF_8)).body();
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to get default key store password", e);
        }
    }
}

