/*
 * Decompiled with CFR 0.152.
 */
package com.github.nagyesta.lowkeyvault.testcontainers;

import com.github.nagyesta.lowkeyvault.testcontainers.LowkeyVaultContainer;
import com.github.nagyesta.lowkeyvault.testcontainers.StoreType;
import java.io.File;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.testcontainers.containers.BindMode;
import org.testcontainers.utility.DockerImageName;

public final class LowkeyVaultContainerBuilder {
    private final DockerImageName dockerImageName;
    private Set<String> vaultNames = Set.of();
    private Map<String, Set<String>> aliasMap = Map.of();
    private File importFile;
    private BindMode importFileBindMode;
    private File customSslCertStore;
    private String customSslCertPassword;
    private StoreType customSslCertType;
    private Integer hostPort;
    private Integer hostTokenPort;
    private Integer logicalPort;
    private String logicalHost;
    private List<String> additionalArgs = List.of();
    private boolean debug;
    private File externalConfigFile;

    public static LowkeyVaultContainerBuilder lowkeyVault(DockerImageName dockerImageName) {
        return new LowkeyVaultContainerBuilder(dockerImageName);
    }

    private LowkeyVaultContainerBuilder(DockerImageName dockerImageName) {
        if (dockerImageName == null) {
            throw new IllegalArgumentException("Image name cannot be null.");
        }
        this.dockerImageName = dockerImageName;
    }

    public LowkeyVaultContainerBuilder noAutoRegistration() {
        this.vaultNames = Set.of("-");
        return this;
    }

    public LowkeyVaultContainerBuilder vaultNames(Set<String> vaultNames) {
        if (vaultNames == null) {
            throw new IllegalArgumentException("Vault names collection cannot be null.");
        }
        this.vaultNames = Set.copyOf(vaultNames);
        return this;
    }

    public LowkeyVaultContainerBuilder vaultAliases(Map<String, Set<String>> aliasMap) {
        if (aliasMap == null) {
            throw new IllegalArgumentException("Alias map cannot be null.");
        }
        aliasMap.keySet().forEach(host -> {
            if (!host.matches("^[0-9a-z\\-_.]+$")) {
                throw new IllegalArgumentException("Vault host names must match '^[0-9a-z\\-_.]+$'. Found: " + host);
            }
        });
        aliasMap.values().stream().flatMap(Collection::stream).forEach(host -> {
            if (!host.matches("^[0-9a-z\\-_.]+(:[0-9]+|:<port>)?$")) {
                throw new IllegalArgumentException("Vault aliases must match '^[0-9a-z\\-_.]+(:[0-9]+|:<port>)?$'. Found: " + host);
            }
        });
        TreeMap temp = new TreeMap();
        aliasMap.forEach((key, value) -> temp.put(key, Set.copyOf(value)));
        this.aliasMap = Map.copyOf(temp);
        return this;
    }

    public LowkeyVaultContainerBuilder importFile(File importFile) {
        return this.importFile(importFile, BindMode.READ_ONLY);
    }

    public LowkeyVaultContainerBuilder importFile(File importFile, BindMode bindMode) {
        if (importFile == null) {
            throw new IllegalArgumentException("Import file cannot be null.");
        }
        this.importFile = importFile;
        this.importFileBindMode = bindMode;
        return this;
    }

    public LowkeyVaultContainerBuilder externalConfigFile(File externalConfigFile) {
        if (externalConfigFile == null) {
            throw new IllegalArgumentException("External configuration file cannot be null.");
        }
        if (!externalConfigFile.getName().endsWith(".properties")) {
            throw new IllegalArgumentException("External configuration file must be a *.properties file.");
        }
        this.externalConfigFile = externalConfigFile;
        return this;
    }

    public LowkeyVaultContainerBuilder customSslCertificate(File customSslCert, String password, StoreType type) {
        if (customSslCert == null) {
            throw new IllegalArgumentException("SSL certificate file cannot be null.");
        }
        this.customSslCertStore = customSslCert;
        this.customSslCertPassword = password;
        this.customSslCertType = type;
        return this;
    }

    public LowkeyVaultContainerBuilder hostPort(int hostPort) {
        if (hostPort < 1) {
            throw new IllegalArgumentException("Host port cannot be zero or negative.");
        }
        this.hostPort = hostPort;
        return this;
    }

    public LowkeyVaultContainerBuilder hostTokenPort(int hostTokenPort) {
        if (hostTokenPort < 1) {
            throw new IllegalArgumentException("Host token port cannot be zero or negative.");
        }
        this.hostTokenPort = hostTokenPort;
        return this;
    }

    public LowkeyVaultContainerBuilder logicalPort(int logicalPort) {
        if (logicalPort < 1) {
            throw new IllegalArgumentException("Logical port cannot be zero or negative.");
        }
        this.logicalPort = logicalPort;
        return this;
    }

    public LowkeyVaultContainerBuilder logicalHost(String logicalHost) {
        if (logicalHost == null) {
            throw new IllegalArgumentException("Logical host cannot be null.");
        }
        this.logicalHost = logicalHost;
        return this;
    }

    public LowkeyVaultContainerBuilder additionalArgs(List<String> additionalArgs) {
        if (additionalArgs == null) {
            throw new IllegalArgumentException("Additional argument collection cannot be null.");
        }
        this.additionalArgs = List.copyOf(additionalArgs);
        return this;
    }

    public LowkeyVaultContainerBuilder debug() {
        this.debug = true;
        return this;
    }

    public LowkeyVaultContainer build() {
        return new LowkeyVaultContainer(this);
    }

    public DockerImageName getDockerImageName() {
        return this.dockerImageName;
    }

    public Set<String> getVaultNames() {
        return this.vaultNames;
    }

    public Map<String, Set<String>> getAliasMap() {
        return this.aliasMap;
    }

    public File getImportFile() {
        return this.importFile;
    }

    public BindMode getImportFileBindMode() {
        return this.importFileBindMode;
    }

    public File getCustomSslCertStore() {
        return this.customSslCertStore;
    }

    public File getExternalConfigFile() {
        return this.externalConfigFile;
    }

    public String getCustomSslCertPassword() {
        return this.customSslCertPassword;
    }

    public StoreType getCustomSslCertType() {
        return this.customSslCertType;
    }

    public Integer getHostPort() {
        return this.hostPort;
    }

    public Integer getHostTokenPort() {
        return this.hostTokenPort;
    }

    public Integer getLogicalPort() {
        return this.logicalPort;
    }

    public String getLogicalHost() {
        return this.logicalHost;
    }

    public List<String> getAdditionalArgs() {
        return this.additionalArgs;
    }

    public boolean isDebug() {
        return this.debug;
    }
}

