/*
 * Decompiled with CFR 0.152.
 */
package com.github.nagyesta.lowkeyvault.testcontainers;

import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import org.testcontainers.lifecycle.Startable;

public final class ContainerDependency<T extends Startable> {
    private final T container;
    private final Function<T, Map<String, String>> secretSupplier;

    ContainerDependency(T container) {
        this((Startable)container, (Function<Startable, Map<String, String>>)((Function<Startable, Map>)c -> Collections.emptyMap()));
    }

    ContainerDependency(T container, Function<T, Map<String, String>> secretSupplier) {
        this.container = container;
        this.secretSupplier = secretSupplier;
    }

    public T getContainer() {
        return this.container;
    }

    public Map<String, String> getSecrets() {
        return this.secretSupplier.apply(this.container);
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ContainerDependency that = (ContainerDependency)o;
        return Objects.equals(this.container, that.container) && Objects.equals(this.secretSupplier, that.secretSupplier);
    }

    public int hashCode() {
        return Objects.hash(this.container, this.secretSupplier);
    }
}

