/*
 * Decompiled with CFR 0.152.
 */
package com.github.nagyesta.lowkeyvault.testcontainers;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.PosixFilePermissions;
import java.security.KeyStore;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.lang3.SystemUtils;

public final class KeyStoreMerger
implements AutoCloseable {
    public static final String CUSTOM_TRUST_STORE_LOCATION_PROPERTY = "javax.net.ssl.trustStore";
    public static final String BACKUP_TRUST_STORE_LOCATION_PROPERTY = "backup.ssl.trustStore";
    public static final String CUSTOM_TRUST_STORE_TYPE_PROPERTY = "javax.net.ssl.trustStoreType";
    public static final String BACKUP_TRUST_STORE_TYPE_PROPERTY = "backup.ssl.trustStoreType";
    public static final String CUSTOM_TRUST_STORE_PASSWORD_PROPERTY = "javax.net.ssl.trustStorePassword";
    public static final String BACKUP_TRUST_STORE_PASSWORD_PROPERTY = "backup.ssl.trustStorePassword";
    public static final String DEFAULT_PASSWORD = "changeit";
    private static final String JAVA_HOME = "java.home";
    private static final String LIB = "lib";
    private static final String SECURITY = "security";
    private static final String JSSECACERTS = "jssecacerts";
    private static final String CACERTS = "cacerts";
    private final KeyStore lowkeyVaultStore;
    private final char[] lowkeyVaultStorePassword;

    public KeyStoreMerger(KeyStore lowkeyVaultStore, char[] lowkeyVaultStorePassword) {
        this.lowkeyVaultStore = lowkeyVaultStore;
        this.lowkeyVaultStorePassword = lowkeyVaultStorePassword;
    }

    public boolean shouldMerge() {
        return System.getProperty(BACKUP_TRUST_STORE_LOCATION_PROPERTY) == null;
    }

    public void mergeDefaultTrustStore() {
        if (!this.shouldMerge()) {
            throw new IllegalStateException("Trust store is already merged: " + System.getProperty(CUSTOM_TRUST_STORE_LOCATION_PROPERTY));
        }
        Path originalLocation = this.findTrustStore();
        String originalStoreType = this.findTrustStoreType();
        String originalPassword = this.findTrustStorePassword();
        KeyStore originalTrustStore = this.loadOriginal(originalLocation, originalStoreType, originalPassword.toCharArray());
        this.doMerge(originalTrustStore, originalPassword.toCharArray());
        Path tempFile = this.storeToTempFile(originalTrustStore, originalPassword.toCharArray());
        System.setProperty(BACKUP_TRUST_STORE_LOCATION_PROPERTY, originalLocation.toString());
        System.setProperty(BACKUP_TRUST_STORE_TYPE_PROPERTY, originalStoreType);
        System.setProperty(BACKUP_TRUST_STORE_PASSWORD_PROPERTY, originalPassword);
        System.setProperty(CUSTOM_TRUST_STORE_LOCATION_PROPERTY, tempFile.toString());
        System.setProperty(CUSTOM_TRUST_STORE_TYPE_PROPERTY, originalStoreType);
        System.setProperty(CUSTOM_TRUST_STORE_PASSWORD_PROPERTY, originalPassword);
    }

    void doMerge(KeyStore toStore, char[] toStorePassword) {
        try {
            KeyStore.PasswordProtection fromProtectionParam = new KeyStore.PasswordProtection(this.lowkeyVaultStorePassword);
            KeyStore.PasswordProtection toProtectionParam = new KeyStore.PasswordProtection(toStorePassword);
            this.lowkeyVaultStore.aliases().asIterator().forEachRemaining(alias -> {
                try {
                    if (toStore.containsAlias((String)alias)) {
                        return;
                    }
                    KeyStore.Entry entry = this.lowkeyVaultStore.getEntry((String)alias, fromProtectionParam);
                    toStore.setEntry((String)alias, entry, toProtectionParam);
                }
                catch (Exception e) {
                    throw new IllegalStateException(e);
                }
            });
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    String findTrustStoreType() {
        return Optional.ofNullable(System.getProperty(CUSTOM_TRUST_STORE_TYPE_PROPERTY)).orElse(KeyStore.getDefaultType());
    }

    String findTrustStorePassword() {
        return Optional.ofNullable(System.getProperty(CUSTOM_TRUST_STORE_PASSWORD_PROPERTY)).orElse(DEFAULT_PASSWORD);
    }

    Path findTrustStore() {
        return Optional.ofNullable(System.getProperty(CUSTOM_TRUST_STORE_LOCATION_PROPERTY)).map(x$0 -> Path.of(x$0, new String[0])).map(Path::toAbsolutePath).filter(x$0 -> Files.exists(x$0, new LinkOption[0])).or(() -> Optional.of(Paths.get(System.getProperty(JAVA_HOME), LIB, SECURITY, JSSECACERTS))).map(Path::toAbsolutePath).filter(x$0 -> Files.exists(x$0, new LinkOption[0])).or(() -> Optional.of(Paths.get(System.getProperty(JAVA_HOME), LIB, SECURITY, CACERTS))).map(Path::toAbsolutePath).filter(x$0 -> Files.exists(x$0, new LinkOption[0])).orElseThrow(() -> new IllegalStateException("Unable to find original trust store"));
    }

    Path storeToTempFile(KeyStore originalTrustStore, char[] storePassword) {
        try {
            Path tempFile = this.createTempKeyStoreFile();
            originalTrustStore.store(Files.newOutputStream(tempFile, new OpenOption[0]), storePassword);
            tempFile.toFile().deleteOnExit();
            return tempFile;
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    private Path createTempKeyStoreFile() throws IOException {
        Path tempFilePath;
        if (SystemUtils.IS_OS_UNIX) {
            FileAttribute<Set<PosixFilePermission>> attr = PosixFilePermissions.asFileAttribute(PosixFilePermissions.fromString("rwx------"));
            tempFilePath = Files.createTempFile("lowkey-vault-trust-store-", ".keystore", attr);
        } else {
            tempFilePath = Files.createTempFile("lowkey-vault-trust-store-", ".keystore", new FileAttribute[0]);
            File tempFile = tempFilePath.toFile();
            if (!(tempFile.setReadable(true, true) && tempFile.setWritable(true, true) && tempFile.setExecutable(true, true))) {
                throw new IllegalStateException("Unable to limit permissions for temporary key store");
            }
        }
        return tempFilePath;
    }

    private KeyStore loadOriginal(Path storeLocation, String storeType, char[] storePassword) {
        try {
            KeyStore trustStore = KeyStore.getInstance(storeType);
            trustStore.load(Files.newInputStream(storeLocation, new OpenOption[0]), storePassword);
            return trustStore;
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public void close() {
        this.restoreFromBackup(BACKUP_TRUST_STORE_LOCATION_PROPERTY, CUSTOM_TRUST_STORE_LOCATION_PROPERTY);
        this.restoreFromBackup(BACKUP_TRUST_STORE_TYPE_PROPERTY, CUSTOM_TRUST_STORE_TYPE_PROPERTY);
        this.restoreFromBackup(BACKUP_TRUST_STORE_PASSWORD_PROPERTY, CUSTOM_TRUST_STORE_PASSWORD_PROPERTY);
    }

    private void restoreFromBackup(String backup, String original) {
        String backupLocation = System.getProperty(backup);
        if (backupLocation != null) {
            System.setProperty(original, backupLocation);
            System.clearProperty(backup);
        }
    }
}

