/*
 * Decompiled with CFR 0.152.
 */
package com.github.nagyesta.lowkeyvault.testcontainers;

import com.github.nagyesta.lowkeyvault.testcontainers.StoreType;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class LowkeyVaultArgLineBuilder {
    private static final String NO_AUTO_REGISTRATION_VALUE = "-";
    private static final Set<String> NO_AUTO_REGISTRATION = Set.of("-");
    private static final String EMPTY = "";
    private static final Pattern NAME_PATTERN = Pattern.compile("^[0-9a-zA-Z-]+$");
    private final List<String> args = new ArrayList<String>();

    public LowkeyVaultArgLineBuilder() {
        this.args.add("--LOWKEY_VAULT_RELAXED_PORTS=true");
    }

    public LowkeyVaultArgLineBuilder vaultNames(Set<String> vaultNames) {
        if (!NO_AUTO_REGISTRATION.equals(vaultNames)) {
            this.assertVaultNamesAreValid(vaultNames);
        }
        if (!vaultNames.isEmpty()) {
            this.args.add("--LOWKEY_VAULT_NAMES=" + String.join((CharSequence)",", vaultNames));
        }
        return this;
    }

    public LowkeyVaultArgLineBuilder logicalHost(String logicalHost) {
        if (logicalHost != null) {
            this.args.add("--LOWKEY_IMPORT_TEMPLATE_HOST=" + logicalHost);
        }
        return this;
    }

    public LowkeyVaultArgLineBuilder logicalPort(Integer logicalPort) {
        if (logicalPort != null) {
            this.args.add("--LOWKEY_IMPORT_TEMPLATE_PORT=" + logicalPort);
        }
        return this;
    }

    public LowkeyVaultArgLineBuilder debug(boolean debug) {
        if (debug) {
            this.args.add("--LOWKEY_DEBUG_REQUEST_LOG=true");
        }
        return this;
    }

    public LowkeyVaultArgLineBuilder usePersistence(String containerPath) {
        this.importFile(containerPath);
        this.exportFile(containerPath);
        return this;
    }

    @Deprecated(forRemoval=true)
    public LowkeyVaultArgLineBuilder importFile(File file) {
        if (file != null) {
            return this.importFile("/import/vaults.json");
        }
        return this;
    }

    public LowkeyVaultArgLineBuilder importFile(String containerPath) {
        if (containerPath != null) {
            this.args.add("--LOWKEY_IMPORT_LOCATION=" + containerPath);
        }
        return this;
    }

    public LowkeyVaultArgLineBuilder customSSLCertificate(File file, String password, StoreType type) {
        if (file != null) {
            this.args.add("--server.ssl.key-store=/config/cert.store");
            this.args.add("--server.ssl.key-store-type=" + Optional.ofNullable(type).orElse(StoreType.PKCS12).name());
            this.args.add("--server.ssl.key-store-password=" + Optional.ofNullable(password).orElse(EMPTY));
        }
        return this;
    }

    public LowkeyVaultArgLineBuilder aliases(Map<String, Set<String>> aliases) {
        if (aliases != null && !aliases.isEmpty()) {
            String aliasMappings = new TreeMap<String, Set<String>>(aliases).entrySet().stream().flatMap(e -> new TreeSet((Collection)e.getValue()).stream().map(alias -> (String)e.getKey() + "=" + alias)).collect(Collectors.joining(","));
            this.args.add("--LOWKEY_VAULT_ALIASES=" + aliasMappings);
        }
        return this;
    }

    public LowkeyVaultArgLineBuilder additionalArgs(List<String> additionalArgs) {
        if (additionalArgs != null && !additionalArgs.isEmpty()) {
            this.args.addAll(additionalArgs);
        }
        return this;
    }

    public List<String> build() {
        return Collections.unmodifiableList(this.args);
    }

    private void exportFile(String containerPath) {
        if (containerPath != null) {
            this.args.add("--LOWKEY_EXPORT_LOCATION=" + containerPath);
        }
    }

    private void assertVaultNamesAreValid(Set<String> vaultNames) {
        if (vaultNames == null) {
            throw new IllegalArgumentException("VaultNames must not be null.");
        }
        Collection invalid = vaultNames.stream().filter(s -> !NAME_PATTERN.matcher(Objects.requireNonNullElse(s, EMPTY)).matches()).collect(Collectors.toList());
        if (!invalid.isEmpty()) {
            throw new IllegalArgumentException("VaultNames contains invalid values: " + String.valueOf(invalid));
        }
    }
}

