/*
 * Decompiled with CFR 0.152.
 */
package com.github.nagyesta.lowkeyvault.testcontainers;

import com.azure.core.credential.BasicAuthenticationCredential;
import com.azure.core.credential.TokenCredential;
import com.azure.core.http.HttpClient;
import com.azure.security.keyvault.certificates.CertificateClientBuilder;
import com.azure.security.keyvault.keys.KeyClientBuilder;
import com.azure.security.keyvault.keys.cryptography.CryptographyClientBuilder;
import com.azure.security.keyvault.secrets.SecretClientBuilder;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.nagyesta.lowkeyvault.http.ApacheHttpClient;
import com.github.nagyesta.lowkeyvault.http.AuthorityOverrideFunction;
import com.github.nagyesta.lowkeyvault.http.management.LowkeyVaultManagementClient;
import com.github.nagyesta.lowkeyvault.http.management.impl.LowkeyVaultManagementClientImpl;
import com.github.nagyesta.lowkeyvault.testcontainers.LowkeyVaultContainer;
import java.net.URI;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.UnaryOperator;
import javax.net.ssl.HostnameVerifier;
import org.apache.http.conn.ssl.DefaultHostnameVerifier;
import org.apache.http.conn.ssl.TrustSelfSignedStrategy;
import org.apache.http.conn.ssl.TrustStrategy;

public class LowkeyVaultClientFactory {
    private final LowkeyVaultContainer lowkeyVaultContainer;
    private final Map<String, ApacheHttpClient> httpClientCache = new ConcurrentHashMap<String, ApacheHttpClient>();

    public LowkeyVaultClientFactory(LowkeyVaultContainer lowkeyVaultContainer) {
        this.lowkeyVaultContainer = lowkeyVaultContainer;
    }

    public BasicAuthenticationCredential getBasicAuthenticationCredential() {
        return new BasicAuthenticationCredential(this.lowkeyVaultContainer.getUsername(), this.lowkeyVaultContainer.getPassword());
    }

    public SecretClientBuilder getSecretClientBuilderForDefaultVault() {
        return this.getSecretClientBuilderFor(URI.create(this.lowkeyVaultContainer.getDefaultVaultBaseUrl()));
    }

    public SecretClientBuilder getSecretClientBuilderFor(String vaultName) {
        return this.getSecretClientBuilderFor(URI.create(this.lowkeyVaultContainer.getVaultBaseUrl(vaultName)));
    }

    public SecretClientBuilder getSecretClientBuilderFor(URI vaultUri) {
        return new SecretClientBuilder().vaultUrl(vaultUri.toString()).credential((TokenCredential)this.getBasicAuthenticationCredential()).disableChallengeResourceVerification().httpClient((HttpClient)this.getApacheHttpClient(vaultUri.getAuthority()));
    }

    public KeyClientBuilder getKeyClientBuilderForDefaultVault() {
        return this.getKeyClientBuilderFor(URI.create(this.lowkeyVaultContainer.getDefaultVaultBaseUrl()));
    }

    public KeyClientBuilder getKeyClientBuilderFor(String vaultName) {
        return this.getKeyClientBuilderFor(URI.create(this.lowkeyVaultContainer.getVaultBaseUrl(vaultName)));
    }

    public KeyClientBuilder getKeyClientBuilderFor(URI vaultUri) {
        return new KeyClientBuilder().vaultUrl(vaultUri.toString()).credential((TokenCredential)this.getBasicAuthenticationCredential()).disableChallengeResourceVerification().httpClient((HttpClient)this.getApacheHttpClient(vaultUri.getAuthority()));
    }

    public CryptographyClientBuilder getCryptoClientBuilderForDefaultVault() {
        return this.getCryptoClientBuilderFor(URI.create(this.lowkeyVaultContainer.getDefaultVaultBaseUrl()));
    }

    public CryptographyClientBuilder getCryptoClientBuilderFor(String vaultName) {
        return this.getCryptoClientBuilderFor(URI.create(this.lowkeyVaultContainer.getVaultBaseUrl(vaultName)));
    }

    public CryptographyClientBuilder getCryptoClientBuilderFor(URI vaultUri) {
        return new CryptographyClientBuilder().credential((TokenCredential)this.getBasicAuthenticationCredential()).disableChallengeResourceVerification().httpClient((HttpClient)this.getApacheHttpClient(vaultUri.getAuthority()));
    }

    public CertificateClientBuilder getCertificateClientBuilderForDefaultVault() {
        return this.getCertificateClientBuilderFor(URI.create(this.lowkeyVaultContainer.getDefaultVaultBaseUrl()));
    }

    public CertificateClientBuilder getCertificateClientBuilderFor(String vaultName) {
        return this.getCertificateClientBuilderFor(URI.create(this.lowkeyVaultContainer.getVaultBaseUrl(vaultName)));
    }

    public CertificateClientBuilder getCertificateClientBuilderFor(URI vaultUri) {
        return new CertificateClientBuilder().vaultUrl(vaultUri.toString()).credential((TokenCredential)this.getBasicAuthenticationCredential()).disableChallengeResourceVerification().httpClient((HttpClient)this.getApacheHttpClient(vaultUri.getAuthority()));
    }

    public LowkeyVaultManagementClient getLowkeyVaultManagementClient() {
        return new LowkeyVaultManagementClientImpl("https://" + this.lowkeyVaultContainer.getEndpointAuthority(), (HttpClient)this.getApacheHttpClient(this.lowkeyVaultContainer.getEndpointAuthority()), new ObjectMapper());
    }

    private ApacheHttpClient getApacheHttpClient(String vaultAuthority) {
        return this.httpClientCache.computeIfAbsent(vaultAuthority, v -> new ApacheHttpClient((UnaryOperator)new AuthorityOverrideFunction(v, this.lowkeyVaultContainer.getEndpointAuthority()), (TrustStrategy)new TrustSelfSignedStrategy(), (HostnameVerifier)new DefaultHostnameVerifier()));
    }
}

