/*
 * Decompiled with CFR 0.152.
 */
package com.github.nagyesta.lowkeyvault.testcontainers;

import com.azure.core.credential.BasicAuthenticationCredential;
import com.azure.core.credential.TokenCredential;
import com.azure.security.keyvault.secrets.SecretClient;
import com.azure.security.keyvault.secrets.SecretClientBuilder;
import com.azure.security.keyvault.secrets.SecretServiceVersion;
import com.github.dockerjava.api.model.Version;
import com.github.nagyesta.lowkeyvault.testcontainers.ContainerDependency;
import com.github.nagyesta.lowkeyvault.testcontainers.KeyStoreMerger;
import com.github.nagyesta.lowkeyvault.testcontainers.LowkeyVaultArgLineBuilder;
import com.github.nagyesta.lowkeyvault.testcontainers.LowkeyVaultClientFactory;
import com.github.nagyesta.lowkeyvault.testcontainers.LowkeyVaultContainerBuilder;
import java.io.ByteArrayInputStream;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.charset.StandardCharsets;
import java.security.KeyStore;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.Function;
import org.slf4j.Logger;
import org.testcontainers.DockerClientFactory;
import org.testcontainers.containers.BindMode;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.wait.strategy.Wait;
import org.testcontainers.containers.wait.strategy.WaitStrategy;
import org.testcontainers.lifecycle.Startable;
import org.testcontainers.utility.DockerImageName;

public class LowkeyVaultContainer
extends GenericContainer<LowkeyVaultContainer> {
    static final DockerImageName DEFAULT_IMAGE_NAME = DockerImageName.parse((String)"nagyesta/lowkey-vault");
    static final String IMPORT_FILE_CONTAINER_PATH = "/import/vaults.json";
    static final String CONFIG_CERT_STORE_CONTAINER_PATH = "/config/cert.store";
    static final String CONFIG_APPLICATION_PROPERTIES_CONTAINER_PATH = "/config/application.properties";
    private static final String DUMMY_USERNAME = "DUMMY";
    private static final String DUMMY_PASSWORD = UUID.randomUUID().toString();
    private static final int CONTAINER_PORT = 8443;
    private static final int CONTAINER_TOKEN_PORT = 8080;
    private static final String HTTP = "http://";
    private static final String HTTPS = "https://";
    private static final String PORT_SEPARATOR = ":";
    private static final String LOCALHOST = "localhost";
    private static final String DOT = ".";
    private static final String TOKEN_ENDPOINT_PATH = "/metadata/identity/oauth2/token";
    private final HttpClient httpClient = HttpClient.newHttpClient();
    private final Integer logicalPort;
    private final boolean mergeTrustStores;
    private final List<ContainerDependency<?>> dependsOnContainers;
    private final Function<LowkeyVaultContainer, Map<String, String>> lowkeyVaultSystemPropertySupplier;
    private Optional<KeyStoreMerger> keyStoreMerger = Optional.empty();

    LowkeyVaultContainer(LowkeyVaultContainerBuilder containerBuilder) {
        super(containerBuilder.getDockerImageName());
        String absolutePath;
        containerBuilder.validate();
        this.recommendMultiArchImageIfApplicable(this.logger(), containerBuilder.getDockerImageName(), ((Version)DockerClientFactory.instance().client().versionCmd().exec()).getArch());
        if (containerBuilder.getHostPort() != null) {
            this.addFixedExposedPort(containerBuilder.getHostPort(), 8443);
        } else {
            this.addExposedPort(8443);
        }
        if (containerBuilder.getHostTokenPort() != null) {
            this.addFixedExposedPort(containerBuilder.getHostTokenPort(), 8080);
        } else {
            this.addExposedPort(8080);
        }
        this.logicalPort = containerBuilder.getLogicalPort();
        if (containerBuilder.getImportFile() != null) {
            absolutePath = containerBuilder.getImportFile().getAbsolutePath();
            this.logger().info("Using path for import file: '{}'", (Object)absolutePath);
            this.withFileSystemBind(absolutePath, IMPORT_FILE_CONTAINER_PATH, containerBuilder.getImportFileBindMode());
        }
        if (containerBuilder.getCustomSslCertStore() != null) {
            absolutePath = containerBuilder.getCustomSslCertStore().getAbsolutePath();
            this.logger().info("Using path for custom certificate: '{}'", (Object)absolutePath);
            this.withFileSystemBind(absolutePath, CONFIG_CERT_STORE_CONTAINER_PATH, BindMode.READ_ONLY);
        }
        if (containerBuilder.getExternalConfigFile() != null) {
            absolutePath = containerBuilder.getExternalConfigFile().getAbsolutePath();
            this.logger().info("Using path for external configuration: '{}'", (Object)absolutePath);
            this.withFileSystemBind(absolutePath, CONFIG_APPLICATION_PROPERTIES_CONTAINER_PATH, BindMode.READ_ONLY);
        }
        LowkeyVaultArgLineBuilder argLineBuilder = new LowkeyVaultArgLineBuilder().vaultNames(Objects.requireNonNullElse(containerBuilder.getVaultNames(), Set.of())).aliases(containerBuilder.getAliasMap()).logicalHost(containerBuilder.getLogicalHost()).logicalPort(containerBuilder.getLogicalPort());
        if (containerBuilder.isPersistent()) {
            argLineBuilder.usePersistence(IMPORT_FILE_CONTAINER_PATH);
        } else if (containerBuilder.getImportFile() != null) {
            argLineBuilder.importFile(IMPORT_FILE_CONTAINER_PATH);
        }
        List<String> args = argLineBuilder.debug(containerBuilder.isDebug()).customSSLCertificate(containerBuilder.getCustomSslCertStore(), containerBuilder.getCustomSslCertPassword(), containerBuilder.getCustomSslCertType()).additionalArgs(containerBuilder.getAdditionalArgs()).build();
        this.withEnv("LOWKEY_ARGS", String.join((CharSequence)" ", args));
        this.waitingFor((WaitStrategy)Wait.forLogMessage((String)"(?s).*Started LowkeyVaultApp.*$", (int)1));
        this.mergeTrustStores = containerBuilder.isMergeTrustStores();
        this.dependsOnContainers = containerBuilder.getDependsOnContainers();
        this.dependsOnContainers.stream().map(ContainerDependency::getContainer).forEach(xva$0 -> {
            LowkeyVaultContainer cfr_ignored_0 = (LowkeyVaultContainer)this.dependsOn(new Startable[]{xva$0});
        });
        this.lowkeyVaultSystemPropertySupplier = Objects.requireNonNullElse(containerBuilder.getLowkeyVaultSystemPropertySupplier(), c -> Map.of());
    }

    public String getDefaultVaultBaseUrl() {
        return HTTPS + this.getDefaultVaultAuthority();
    }

    public String getTokenEndpointBaseUrl() {
        return "http://localhost:" + this.getMappedPort(8080);
    }

    public String getTokenEndpointUrl() {
        return this.getTokenEndpointBaseUrl() + TOKEN_ENDPOINT_PATH;
    }

    public String getVaultBaseUrl(String vaultName) {
        return HTTPS + this.getVaultAuthority(vaultName);
    }

    public String getDefaultVaultAuthority() {
        return "localhost:" + this.getLogicalPort();
    }

    public String getVaultAuthority(String vaultName) {
        return Objects.requireNonNull(vaultName) + ".localhost:" + this.getLogicalPort();
    }

    public String getEndpointAuthority() {
        return this.getHost() + PORT_SEPARATOR + this.getMappedPort(8443);
    }

    public String getEndpointBaseUrl() {
        return HTTPS + this.getEndpointAuthority();
    }

    public String getPassword() {
        return DUMMY_PASSWORD;
    }

    public String getUsername() {
        return DUMMY_USERNAME;
    }

    public KeyStore getDefaultKeyStore() {
        HttpRequest request = HttpRequest.newBuilder().uri(URI.create(this.getTokenEndpointBaseUrl() + "/metadata/default-cert/lowkey-vault.p12")).GET().build();
        try {
            byte[] keyStoreBytes = this.httpClient.send(request, HttpResponse.BodyHandlers.ofByteArray()).body();
            KeyStore keyStore = KeyStore.getInstance("PKCS12");
            keyStore.load(new ByteArrayInputStream(keyStoreBytes), this.getDefaultKeyStorePassword().toCharArray());
            return keyStore;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new IllegalStateException("Failed to get default key store", e);
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to get default key store", e);
        }
    }

    public String getDefaultKeyStorePassword() {
        HttpRequest request = HttpRequest.newBuilder().uri(URI.create(this.getTokenEndpointBaseUrl() + "/metadata/default-cert/password")).GET().build();
        try {
            return this.httpClient.send(request, HttpResponse.BodyHandlers.ofString(StandardCharsets.UTF_8)).body();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new IllegalStateException("Failed to get default key store password", e);
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to get default key store password", e);
        }
    }

    protected void recommendMultiArchImageIfApplicable(Logger logger, DockerImageName dockerImageName, String hostArch) {
        boolean imageIsNotMultiArch;
        dockerImageName.assertCompatibleWith(new DockerImageName[]{DEFAULT_IMAGE_NAME});
        boolean hostArchIsNotAmd64 = !"amd64".equals(hostArch);
        boolean defaultImageUsed = DEFAULT_IMAGE_NAME.getUnversionedPart().equals(dockerImageName.getUnversionedPart());
        String versionPart = dockerImageName.getVersionPart();
        boolean bl = imageIsNotMultiArch = !versionPart.contains("-ubi9-minimal");
        if (defaultImageUsed && hostArchIsNotAmd64 && imageIsNotMultiArch) {
            logger.warn("An amd64 image is detected with non-amd64 ({}) host.", (Object)hostArch);
            logger.warn("Please consider using a multi-arch image, like: {}-ubi9-minimal", (Object)versionPart);
            logger.warn("See more information: https://github.com/nagyesta/lowkey-vault/tree/main/lowkey-vault-docker#arm-builds");
        }
    }

    public LowkeyVaultClientFactory getClientFactory() {
        return new LowkeyVaultClientFactory(this);
    }

    public void start() {
        super.start();
        this.mergeTrustStoresIfNecessary();
        this.autoSetDependencySecrets();
        this.lowkeyVaultSystemPropertySupplier.apply(this).forEach((key, value) -> {
            this.logger().info("Setting system property '{}' to '{}'", key, value);
            System.setProperty(key, value);
        });
    }

    public void stop() {
        super.stop();
        this.keyStoreMerger.ifPresent(KeyStoreMerger::close);
    }

    private int getLogicalPort() {
        return Optional.ofNullable(this.logicalPort).orElse(this.getMappedPort(8443));
    }

    private void autoSetDependencySecrets() {
        if (!this.dependsOnContainers.isEmpty()) {
            SecretClient secretClient = this.getSecretClient();
            this.dependsOnContainers.forEach(dependency -> {
                Map<String, String> secrets = dependency.getSecrets();
                secrets.forEach((name, value) -> {
                    this.logger().info("Saving secret '{}' with value '{}' to default vault", name, value);
                    secretClient.setSecret(name, value);
                });
            });
        }
    }

    private SecretClient getSecretClient() {
        SecretClient secretClient;
        if (this.shouldUseOfficialAzureClients()) {
            this.warnAboutLogicalPortIfMisconfigured();
            this.logger().info("Using official Azure Secret Client to save secrets to default vault.");
            secretClient = new SecretClientBuilder().vaultUrl(this.getDefaultVaultBaseUrl()).disableChallengeResourceVerification().credential((TokenCredential)new BasicAuthenticationCredential(this.getUsername(), this.getPassword())).serviceVersion(SecretServiceVersion.V7_5).buildClient();
        } else {
            this.logger().info("Using Lowkey Vault Secret Client to save secrets to default vault.");
            secretClient = this.getClientFactory().getSecretClientBuilderForDefaultVault().buildClient();
        }
        return secretClient;
    }

    private void warnAboutLogicalPortIfMisconfigured() {
        if (this.logicalPort != null && this.lowkeyVaultClientIsNotPresent()) {
            this.logger().warn("Logical port is set but lowkey vault client is not present on the classpath.");
            this.logger().warn("This is strongly suggesting that you have a configuration issue.");
            this.logger().warn("Please verify your configuration! To try resolving this issue you can:");
            this.logger().warn("- add the Lowkey Vault client (com.github.nagyesta.lowkey-vault:lowkey-vault-client) as a test dependency");
            this.logger().warn("- stop using the logical port configuration to let us use the official Azure clients");
        }
    }

    private boolean shouldUseOfficialAzureClients() {
        return this.mergeTrustStores || this.lowkeyVaultClientIsNotPresent();
    }

    private boolean lowkeyVaultClientIsNotPresent() {
        try {
            Class.forName("com.github.nagyesta.lowkeyvault.http.ApacheHttpClient");
            return false;
        }
        catch (ClassNotFoundException e) {
            return true;
        }
    }

    private void mergeTrustStoresIfNecessary() {
        if (!this.mergeTrustStores) {
            this.logger().debug("Not merging trust stores.");
            return;
        }
        this.logger().info("Merging trust stores");
        KeyStore defaultKeyStore = this.getDefaultKeyStore();
        String defaultKeyStorePassword = this.getDefaultKeyStorePassword();
        KeyStoreMerger merger = new KeyStoreMerger(defaultKeyStore, defaultKeyStorePassword.toCharArray());
        merger.mergeDefaultTrustStore();
        this.keyStoreMerger = Optional.of(merger);
    }
}

