/*
 * Decompiled with CFR 0.152.
 */
package com.nawforce.apexlink.cmds;

import com.nawforce.apexlink.api.Org;
import com.nawforce.apexlink.api.Org$;
import com.nawforce.apexlink.api.ServerOps$;
import com.nawforce.apexlink.cmds.Check;
import com.nawforce.apexlink.plugins.Plugin;
import com.nawforce.apexlink.plugins.PluginsManager$;
import com.nawforce.apexlink.plugins.UnusedPlugin;
import com.nawforce.pkgforce.api.Issue;
import com.nawforce.pkgforce.diagnostics.DefaultLogger;
import com.nawforce.pkgforce.diagnostics.Logger;
import com.nawforce.pkgforce.diagnostics.LoggerOps$;
import com.nawforce.runtime.platform.Environment$;
import java.io.Serializable;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.ArrayOps$;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;

public final class Check$ {
    public static final Check$ MODULE$ = new Check$();
    private static final int STATUS_OK = 0;
    private static final int STATUS_ARGS = 1;
    private static final int STATUS_EXCEPTION = 3;
    private static final int STATUS_ISSUES = 4;

    public final int STATUS_OK() {
        return STATUS_OK;
    }

    public final int STATUS_ARGS() {
        return STATUS_ARGS;
    }

    public final int STATUS_EXCEPTION() {
        return STATUS_EXCEPTION;
    }

    public final int STATUS_ISSUES() {
        return STATUS_ISSUES;
    }

    public String usage(String name) {
        return new StringBuilder(85).append("Usage: ").append(name).append(" [-json] [-verbose [-unused]] [-info|-debug] [-nocache] [-depends] <directory>").toString();
    }

    public int run(String[] args) {
        int n;
        Set flags = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"-json", "-verbose", "-info", "-debug", "-nocache", "-unused", "-depends"}));
        boolean json = ArrayOps$.MODULE$.contains$extension(Predef$.MODULE$.refArrayOps((Object[])args), (Object)"-json");
        boolean verbose = !json && ArrayOps$.MODULE$.contains$extension(Predef$.MODULE$.refArrayOps((Object[])args), (Object)"-verbose");
        boolean debug = !json && ArrayOps$.MODULE$.contains$extension(Predef$.MODULE$.refArrayOps((Object[])args), (Object)"-debug");
        boolean info = !json && !debug && ArrayOps$.MODULE$.contains$extension(Predef$.MODULE$.refArrayOps((Object[])args), (Object)"-info");
        boolean depends = ArrayOps$.MODULE$.contains$extension(Predef$.MODULE$.refArrayOps((Object[])args), (Object)"-depends");
        boolean noCache = ArrayOps$.MODULE$.contains$extension(Predef$.MODULE$.refArrayOps((Object[])args), (Object)"-nocache");
        boolean unused = ArrayOps$.MODULE$.contains$extension(Predef$.MODULE$.refArrayOps((Object[])args), (Object)"-unused");
        Object[] dirs = (String[])ArrayOps$.MODULE$.filterNot$extension(Predef$.MODULE$.refArrayOps((Object[])args), (Function1 & Serializable)elem -> BoxesRunTime.boxToBoolean((boolean)flags.contains((Object)elem)));
        if (ArrayOps$.MODULE$.isEmpty$extension(Predef$.MODULE$.refArrayOps(dirs))) {
            System.err.println("No workspace directory argument provided.");
            return this.STATUS_ARGS();
        }
        if (dirs.length > 1) {
            System.err.println(new StringBuilder(62).append("Multiple arguments provided, expected workspace directory, '").append(Predef$.MODULE$.wrapRefArray(dirs).mkString(", ")).append("'}").toString());
            return this.STATUS_ARGS();
        }
        try {
            ServerOps$.MODULE$.setAutoFlush(false);
            LoggerOps$.MODULE$.setLogger((Logger)new DefaultLogger(System.out));
            if (debug) {
                LoggerOps$.MODULE$.setLoggingLevel(Predef$.MODULE$.int2Integer(LoggerOps$.MODULE$.DEBUG_LOGGING()));
            } else if (info) {
                LoggerOps$.MODULE$.setLoggingLevel(Predef$.MODULE$.int2Integer(LoggerOps$.MODULE$.INFO_LOGGING()));
            }
            if (noCache) {
                Environment$.MODULE$.setCacheDirOverride((Option)new Some((Object)None$.MODULE$));
            }
            if (!verbose || !unused) {
                PluginsManager$.MODULE$.removePlugins((Seq<Class<? extends Plugin>>)new .colon.colon(UnusedPlugin.class, (List)Nil$.MODULE$));
            }
            Org org = Org$.MODULE$.newOrg((String)ArrayOps$.MODULE$.head$extension(Predef$.MODULE$.refArrayOps(dirs)));
            if (!noCache) {
                org.flush();
            }
            if (depends) {
                if (json) {
                    this.writeDependenciesAsJSON(org);
                } else {
                    this.writeDependenciesAsCSV(org);
                }
            } else {
                return this.writeIssues(org, json, verbose);
            }
            n = this.STATUS_OK();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace(System.err);
            n = this.STATUS_EXCEPTION();
        }
        return n;
    }

    private void writeDependenciesAsJSON(Org org) {
        scala.collection.mutable.StringBuilder buffer = new scala.collection.mutable.StringBuilder();
        BooleanRef first = BooleanRef.create((boolean)true);
        buffer.$plus$plus$eq("{ \"dependencies\": [\n");
        CollectionConverters$.MODULE$.MapHasAsScala(org.getDependencies()).asScala().foreach((Function1 & Serializable)kv -> {
            if (!first$1.elem) {
                buffer.$plus$plus$eq(",\n");
            }
            first$1.elem = false;
            buffer.$plus$plus$eq(new StringBuilder(31).append("{ \"name\": \"").append(kv._1()).append("\", \"dependencies\": [").toString());
            buffer.$plus$plus$eq(Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])kv._2()), (Function1 & Serializable)x$1 -> new StringBuilder(2).append("\"").append((String)x$1).append("\"").toString(), ClassTag$.MODULE$.apply(String.class))).mkString(", "));
            return buffer.$plus$plus$eq("]}");
        });
        buffer.$plus$plus$eq("]}\n");
        Predef$.MODULE$.print((Object)buffer.mkString());
    }

    private void writeDependenciesAsCSV(Org org) {
        CollectionConverters$.MODULE$.MapHasAsScala(org.getDependencies()).asScala().foreach((Function1 & Serializable)kv -> {
            Predef$.MODULE$.println((Object)new StringBuilder(2).append(kv._1()).append(", ").append(Predef$.MODULE$.wrapRefArray((Object[])kv._2()).mkString(", ")).toString());
            return BoxedUnit.UNIT;
        });
    }

    private int writeIssues(Org org, boolean asJSON, boolean includeWarnings) {
        Object[] issues = org.issues().issuesForFiles(null, includeWarnings, 0);
        Check.MessageWriter writer = asJSON ? new Check.JSONMessageWriter() : new Check.TextMessageWriter(true);
        writer.startOutput();
        BooleanRef hasErrors = BooleanRef.create((boolean)false);
        ObjectRef lastPath = ObjectRef.create((Object)"");
        ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps(issues), (Function1 & Serializable)issue -> {
            Check$.$anonfun$writeIssues$1(hasErrors, includeWarnings, lastPath, writer, issue);
            return BoxedUnit.UNIT;
        });
        if (StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString((String)lastPath.elem))) {
            writer.endDocument();
        }
        Predef$.MODULE$.print((Object)writer.output());
        System.out.flush();
        if (hasErrors.elem) {
            return this.STATUS_ISSUES();
        }
        return this.STATUS_OK();
    }

    public static final /* synthetic */ void $anonfun$writeIssues$1(BooleanRef hasErrors$1, boolean includeWarnings$1, ObjectRef lastPath$1, Check.MessageWriter writer$1, Issue issue) {
        hasErrors$1.elem |= Predef$.MODULE$.Boolean2boolean(issue.isError());
        if (includeWarnings$1 || Predef$.MODULE$.Boolean2boolean(issue.isError())) {
            String string = issue.filePath();
            String string2 = (String)lastPath$1.elem;
            if (string == null ? string2 != null : !string.equals(string2)) {
                if (StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString((String)lastPath$1.elem))) {
                    writer$1.endDocument();
                }
                lastPath$1.elem = issue.filePath();
                writer$1.startDocument((String)lastPath$1.elem);
            }
            writer$1.writeMessage(issue.category(), issue.fileLocation(), issue.message());
        }
    }

    private Check$() {
    }
}

