/*
 * Decompiled with CFR 0.152.
 */
package com.nawforce.apexlink.types.apex;

import com.nawforce.apexlink.api.DependentSummary;
import com.nawforce.apexlink.api.FieldDependentSummary;
import com.nawforce.apexlink.api.MethodDependentSummary;
import com.nawforce.apexlink.api.TypeDependentSummary;
import com.nawforce.apexlink.finding.TypeError;
import com.nawforce.apexlink.finding.TypeResolver$;
import com.nawforce.apexlink.org.Module;
import com.nawforce.apexlink.types.apex.ApexClassDeclaration;
import com.nawforce.apexlink.types.apex.SummaryDeclaration;
import com.nawforce.apexlink.types.core.Dependent;
import com.nawforce.apexlink.types.core.FieldDeclaration;
import com.nawforce.apexlink.types.core.MethodDeclaration;
import com.nawforce.apexlink.types.core.TypeDeclaration;
import com.nawforce.apexlink.types.core.TypeId;
import com.nawforce.apexlink.types.other.ComponentDeclaration;
import com.nawforce.apexlink.types.other.InterviewDeclaration;
import com.nawforce.apexlink.types.other.LabelDeclaration;
import com.nawforce.apexlink.types.other.PageDeclaration;
import com.nawforce.apexlink.types.schema.SObjectDeclaration;
import com.nawforce.pkgforce.diagnostics.LoggerOps$;
import com.nawforce.pkgforce.names.Name;
import com.nawforce.pkgforce.names.TypeIdentifier;
import com.nawforce.pkgforce.names.TypeName;
import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.immutable.ArraySeq;
import scala.collection.mutable.HashMap;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.NonLocalReturnControl;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

public final class DependentValidation$ {
    public static final DependentValidation$ MODULE$ = new DependentValidation$();

    public boolean areTypeDependenciesValid(DependentSummary[] dependents, Module module, HashMap<Tuple2<TypeName, Module>, Either<TypeError, TypeDeclaration>> typeCache) {
        Object object = new Object();
        try {
            ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps((Object[])dependents), (Function1 & Serializable)dependent -> {
                DependentValidation$.$anonfun$areTypeDependenciesValid$1(module, typeCache, object, dependent);
                return BoxedUnit.UNIT;
            });
            return true;
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                return ex.value$mcZ$sp();
            }
            throw ex;
        }
    }

    private Option<TypeDeclaration> findValidTypeDependent(TypeDependentSummary dependent, Module module, HashMap<Tuple2<TypeName, Module>, Either<TypeError, TypeDeclaration>> typeCache) {
        return this.convertToTypeId(module, dependent.typeId()).flatMap((Function1 & Serializable)typeId -> this.findSummaryType$1((TypeId)typeId, (HashMap)typeCache).filter((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)(bl = x0$1 instanceof SummaryDeclaration ? ((SummaryDeclaration)x0$1).sourceHash() == dependent.sourceHash() : (x0$1 instanceof LabelDeclaration ? ((LabelDeclaration)x0$1).sourceHash() == dependent.sourceHash() : (x0$1 instanceof InterviewDeclaration ? ((InterviewDeclaration)x0$1).sourceHash() == dependent.sourceHash() : (x0$1 instanceof PageDeclaration ? ((PageDeclaration)x0$1).sourceHash() == dependent.sourceHash() : (x0$1 instanceof ComponentDeclaration ? ((ComponentDeclaration)x0$1).sourceHash() == dependent.sourceHash() : (x0$1 instanceof SObjectDeclaration ? ((SObjectDeclaration)x0$1).sourceHash() == dependent.sourceHash() : true)))))))));
    }

    public Dependent[] getDependents(DependentSummary[] dependents, Module module, HashMap<Tuple2<TypeName, Module>, Either<TypeError, TypeDeclaration>> typeCache) {
        return (Dependent[])ArrayOps$.MODULE$.flatMap$extension(Predef$.MODULE$.refArrayOps((Object[])dependents), (Function1 & Serializable)dependent -> {
            void var3_3;
            Option<Dependent> dep = MODULE$.findDependent((DependentSummary)dependent, module, typeCache);
            if (dep.isEmpty()) {
                LoggerOps$.MODULE$.debug(new StringBuilder(26).append("Rejected other dependency ").append(dependent).toString());
            }
            return var3_3;
        }, ClassTag$.MODULE$.apply(Dependent.class));
    }

    private Option<Dependent> findDependent(DependentSummary dependent, Module module, HashMap<Tuple2<TypeName, Module>, Either<TypeError, TypeDeclaration>> typeCache) {
        Object object;
        if (dependent instanceof TypeDependentSummary) {
            TypeDependentSummary typeDependentSummary = (TypeDependentSummary)dependent;
            object = this.findDependent(typeDependentSummary, module, typeCache);
        } else if (dependent instanceof FieldDependentSummary) {
            FieldDependentSummary fieldDependentSummary = (FieldDependentSummary)dependent;
            object = this.findDependent(fieldDependentSummary, module, typeCache);
        } else if (dependent instanceof MethodDependentSummary) {
            MethodDependentSummary methodDependentSummary = (MethodDependentSummary)dependent;
            object = this.findDependent(methodDependentSummary, module, typeCache);
        } else {
            object = None$.MODULE$;
        }
        return object;
    }

    private Option<TypeDeclaration> findDependent(TypeDependentSummary dependent, Module module, HashMap<Tuple2<TypeName, Module>, Either<TypeError, TypeDeclaration>> typeCache) {
        return this.convertToTypeId(module, dependent.typeId()).flatMap((Function1 & Serializable)typeId -> MODULE$.findDependentType(typeId.typeName(), typeId.module(), typeCache));
    }

    private Option<FieldDeclaration> findDependent(FieldDependentSummary dependent, Module module, HashMap<Tuple2<TypeName, Module>, Either<TypeError, TypeDeclaration>> typeCache) {
        Name name = new Name(dependent.name());
        return this.convertToTypeId(module, dependent.typeId()).flatMap((Function1 & Serializable)typeId -> MODULE$.findExactDependentType(typeId.typeName(), typeId.module(), typeCache).flatMap((Function1 & Serializable)x$2 -> x$2.fields().find((Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)DependentValidation$.$anonfun$findDependent$4(name, x$3)))));
    }

    private Option<MethodDeclaration> findDependent(MethodDependentSummary dependent, Module module, HashMap<Tuple2<TypeName, Module>, Either<TypeError, TypeDeclaration>> typeCache) {
        Name name = new Name(dependent.name());
        return this.convertToTypeId(module, dependent.typeId()).flatMap((Function1 & Serializable)typeId -> MODULE$.findExactDependentType(typeId.typeName(), typeId.module(), typeCache).flatMap((Function1 & Serializable)x0$1 -> {
            Option option;
            if (x0$1 instanceof ApexClassDeclaration) {
                option = ((ApexClassDeclaration)x0$1).methodMap().findMethod(name, dependent.parameterTypes());
            } else if (x0$1 != null) {
                option = x0$1.methods().find((Function1 & Serializable)m -> BoxesRunTime.boxToBoolean((boolean)DependentValidation$.$anonfun$findDependent$7(name, dependent, m)));
            } else {
                throw new MatchError(null);
            }
            return option;
        }));
    }

    private Option<TypeDeclaration> findExactDependentType(TypeName typeName, Module module, HashMap<Tuple2<TypeName, Module>, Either<TypeError, TypeDeclaration>> typeCache) {
        return this.findDependentType(typeName, module, typeCache).flatMap((Function1 & Serializable)td -> {
            TypeName typeName = td.typeName();
            if (typeName == null ? typeName != null : !typeName.equals(typeName)) {
                return td.nestedTypes().find((Function1 & Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)DependentValidation$.$anonfun$findExactDependentType$2(typeName, x$5)));
            }
            return new Some(td);
        });
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Option<TypeDeclaration> findDependentType(TypeName typeName, Module module, HashMap<Tuple2<TypeName, Module>, Either<TypeError, TypeDeclaration>> typeCache) {
        TypeDeclaration d;
        TypeDeclaration d2;
        TypeDeclaration d3;
        TypeDeclaration d4;
        TypeDeclaration d5;
        Either response = (Either)typeCache.getOrElseUpdate((Object)new Tuple2((Object)typeName, (Object)module), (Function0 & Serializable)() -> TypeResolver$.MODULE$.apply(typeName, module));
        boolean bl = false;
        Right right = null;
        if (response instanceof Left) {
            return None$.MODULE$;
        }
        if (response instanceof Right) {
            bl = true;
            right = (Right)response;
            TypeDeclaration d6 = (TypeDeclaration)right.value();
            if (d6 instanceof ApexClassDeclaration) {
                ApexClassDeclaration apexClassDeclaration = (ApexClassDeclaration)d6;
                return new Some((Object)apexClassDeclaration);
            }
        }
        if (bl && (d5 = (TypeDeclaration)right.value()) instanceof LabelDeclaration) {
            LabelDeclaration labelDeclaration = (LabelDeclaration)d5;
            return new Some((Object)labelDeclaration);
        }
        if (bl && (d4 = (TypeDeclaration)right.value()) instanceof InterviewDeclaration) {
            InterviewDeclaration interviewDeclaration = (InterviewDeclaration)d4;
            return new Some((Object)interviewDeclaration);
        }
        if (bl && (d3 = (TypeDeclaration)right.value()) instanceof PageDeclaration) {
            PageDeclaration pageDeclaration = (PageDeclaration)d3;
            return new Some((Object)pageDeclaration);
        }
        if (bl && (d2 = (TypeDeclaration)right.value()) instanceof ComponentDeclaration) {
            ComponentDeclaration componentDeclaration = (ComponentDeclaration)d2;
            return new Some((Object)componentDeclaration);
        }
        if (bl && (d = (TypeDeclaration)right.value()) instanceof SObjectDeclaration) {
            SObjectDeclaration sObjectDeclaration = (SObjectDeclaration)d;
            return new Some((Object)sObjectDeclaration);
        }
        if (!bl) throw new MatchError((Object)response);
        return None$.MODULE$;
    }

    private Option<TypeId> convertToTypeId(Module module, TypeIdentifier typeIdentifier) {
        TypeName typeName = typeIdentifier.typeName();
        Option option = typeIdentifier.namespace();
        Option<Name> option2 = module.namespace();
        if (!(option != null ? !option.equals(option2) : option2 != null)) {
            return new Some((Object)new TypeId(module, typeName));
        }
        return module.pkg().org().packagesByNamespace().get((Object)typeIdentifier.namespace()).flatMap((Function1 & Serializable)x$6 -> x$6.orderedModules().headOption()).map((Function1 & Serializable)x$7 -> new TypeId((Module)x$7, typeName));
    }

    public static final /* synthetic */ void $anonfun$areTypeDependenciesValid$1(Module module$1, HashMap typeCache$1, Object nonLocalReturnKey1$1, DependentSummary dependent) {
        TypeDependentSummary typeDependentSummary;
        if (dependent instanceof TypeDependentSummary && MODULE$.findValidTypeDependent(typeDependentSummary = (TypeDependentSummary)dependent, module$1, (HashMap<Tuple2<TypeName, Module>, Either<TypeError, TypeDeclaration>>)typeCache$1).isEmpty()) {
            LoggerOps$.MODULE$.debug(new StringBuilder(25).append("Rejected type dependency ").append(dependent).toString());
            throw new NonLocalReturnControl.mcZ.sp(nonLocalReturnKey1$1, false);
        }
    }

    private final Option findSummaryType$1(TypeId typeId, HashMap typeCache$2) {
        return this.findDependentType(typeId.typeName(), typeId.module(), (HashMap<Tuple2<TypeName, Module>, Either<TypeError, TypeDeclaration>>)typeCache$2).orElse((Function0 & Serializable)() -> typeId.typeName().outer().flatMap((Function1 & Serializable)x$1 -> MODULE$.findDependentType((TypeName)x$1, typeId.module(), (HashMap<Tuple2<TypeName, Module>, Either<TypeError, TypeDeclaration>>)typeCache$2)));
    }

    public static final /* synthetic */ boolean $anonfun$findDependent$4(Name name$1, FieldDeclaration x$3) {
        Name name = x$3.name();
        return !(name != null ? !name.equals(name$1) : name$1 != null);
    }

    public static final /* synthetic */ boolean $anonfun$findDependent$7(Name name$2, MethodDependentSummary dependent$2, MethodDeclaration m) {
        Name name = m.name();
        if (!(name != null ? !name.equals(name$2) : name$2 != null)) {
            ArraySeq arraySeq = m.parameters().map((Function1 & Serializable)x$4 -> x$4.typeName());
            ArraySeq<TypeName> arraySeq2 = dependent$2.parameterTypes();
            if (!(arraySeq != null ? !arraySeq.equals(arraySeq2) : arraySeq2 != null)) {
                return true;
            }
        }
        return false;
    }

    public static final /* synthetic */ boolean $anonfun$findExactDependentType$2(TypeName typeName$1, TypeDeclaration x$5) {
        TypeName typeName = x$5.typeName();
        return !(typeName != null ? !typeName.equals(typeName$1) : typeName$1 != null);
    }

    private DependentValidation$() {
    }
}

