/*
 * Decompiled with CFR 0.152.
 */
package internal.heylogs;

import com.vladsch.flexmark.ast.Heading;
import com.vladsch.flexmark.ast.LinkNodeBase;
import com.vladsch.flexmark.util.ast.Document;
import com.vladsch.flexmark.util.ast.Node;
import internal.heylogs.RuleSupport;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.NonNull;
import nbbrd.heylogs.Nodes;
import nbbrd.heylogs.Util;
import nbbrd.heylogs.Version;
import nbbrd.heylogs.spi.Rule;
import nbbrd.heylogs.spi.RuleBatch;
import nbbrd.heylogs.spi.RuleIssue;
import nbbrd.heylogs.spi.RuleSeverity;
import org.checkerframework.checker.nullness.qual.Nullable;

public enum ExtendedRules implements Rule
{
    HTTPS{

        @Override
        public RuleIssue getRuleIssueOrNull(@NonNull Node node) {
            if (node == null) {
                throw new NullPointerException("node is marked non-null but is null");
            }
            return node instanceof LinkNodeBase ? 1.validateHttps((LinkNodeBase)node) : NO_RULE_ISSUE;
        }

        @Override
        @NonNull
        public String getRuleName() {
            return "HTTPS";
        }
    }
    ,
    CONSISTENT_SEPARATOR{

        @Override
        public @Nullable RuleIssue getRuleIssueOrNull(@NonNull Node node) {
            if (node == null) {
                throw new NullPointerException("node is marked non-null but is null");
            }
            return node instanceof Document ? 2.validateConsistentSeparator((Document)node) : NO_RULE_ISSUE;
        }

        @Override
        @NonNull
        public String getRuleName() {
            return "Consistent separator";
        }
    };


    @Override
    @NonNull
    public String getRuleId() {
        return RuleSupport.nameToId(this);
    }

    @Override
    @NonNull
    public String getRuleCategory() {
        return "extension";
    }

    @Override
    public boolean isRuleAvailable() {
        return true;
    }

    @Override
    @NonNull
    public RuleSeverity getRuleSeverity() {
        return RuleSeverity.ERROR;
    }

    static RuleIssue validateHttps(LinkNodeBase link) {
        return RuleSupport.linkToURL(link).filter(url -> !url.getProtocol().equals("https")).map(ignore -> RuleIssue.builder().message("Expecting HTTPS protocol").location((Node)link).build()).orElse(NO_RULE_ISSUE);
    }

    static RuleIssue validateConsistentSeparator(Document doc) {
        List separators = Nodes.of(Heading.class).descendants((Node)doc).filter(Version::isVersionLevel).map(Util.illegalArgumentToNull(Version::parse)).filter(version -> version != null && !version.isUnreleased()).map(Version::getSeparator).distinct().collect(Collectors.toList());
        return separators.size() > 1 ? RuleIssue.builder().message("Expecting consistent version-date separator " + Util.toUnicode((Character)separators.get(0)) + ", found " + separators.stream().map(Util::toUnicode).collect(Collectors.joining(", ", "[", "]"))).location((Node)doc).build() : NO_RULE_ISSUE;
    }

    public static final class Batch
    implements RuleBatch {
        @Override
        @NonNull
        public Stream<Rule> getProviders() {
            return Stream.of(ExtendedRules.values());
        }
    }
}

