/*
 * Decompiled with CFR 0.152.
 */
package internal.heylogs;

import com.vladsch.flexmark.ast.Heading;
import com.vladsch.flexmark.ast.Reference;
import com.vladsch.flexmark.ast.util.ReferenceRepository;
import com.vladsch.flexmark.parser.Parser;
import com.vladsch.flexmark.util.ast.Document;
import com.vladsch.flexmark.util.ast.Node;
import com.vladsch.flexmark.util.data.DataHolder;
import internal.heylogs.RuleSupport;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import lombok.NonNull;
import nbbrd.heylogs.Changelog;
import nbbrd.heylogs.Nodes;
import nbbrd.heylogs.TypeOfChange;
import nbbrd.heylogs.Util;
import nbbrd.heylogs.Version;
import nbbrd.heylogs.spi.Rule;
import nbbrd.heylogs.spi.RuleBatch;
import nbbrd.heylogs.spi.RuleIssue;
import nbbrd.heylogs.spi.RuleSeverity;
import org.checkerframework.checker.nullness.qual.Nullable;

public enum GuidingPrinciples implements Rule
{
    FOR_HUMANS{

        @Override
        public RuleIssue getRuleIssueOrNull(@NonNull Node node) {
            if (node == null) {
                throw new NullPointerException("node is marked non-null but is null");
            }
            return node instanceof Document ? 1.validateForHumans((Document)node) : NO_RULE_ISSUE;
        }

        @Override
        @NonNull
        public String getRuleName() {
            return "For humans";
        }
    }
    ,
    ALL_H2_CONTAIN_A_VERSION{

        @Override
        public RuleIssue getRuleIssueOrNull(@NonNull Node node) {
            if (node == null) {
                throw new NullPointerException("node is marked non-null but is null");
            }
            return node instanceof Heading ? 2.validateAllH2ContainAVersion((Heading)node) : NO_RULE_ISSUE;
        }

        @Override
        @NonNull
        public String getRuleName() {
            return "All H2 contain a version";
        }
    }
    ,
    TYPE_OF_CHANGES_GROUPED{

        @Override
        public RuleIssue getRuleIssueOrNull(@NonNull Node node) {
            if (node == null) {
                throw new NullPointerException("node is marked non-null but is null");
            }
            return node instanceof Heading ? 3.validateTypeOfChangesGrouped((Heading)node) : NO_RULE_ISSUE;
        }

        @Override
        @NonNull
        public String getRuleName() {
            return "Type of changes grouped";
        }
    }
    ,
    LINKABLE{

        @Override
        public RuleIssue getRuleIssueOrNull(@NonNull Node node) {
            if (node == null) {
                throw new NullPointerException("node is marked non-null but is null");
            }
            return node instanceof Heading ? 4.validateLinkable((Heading)node) : NO_RULE_ISSUE;
        }

        @Override
        @NonNull
        public String getRuleName() {
            return "Linkable";
        }
    }
    ,
    LATEST_VERSION_FIRST{

        @Override
        public RuleIssue getRuleIssueOrNull(@NonNull Node node) {
            if (node == null) {
                throw new NullPointerException("node is marked non-null but is null");
            }
            return node instanceof Document ? 5.validateLatestVersionFirst((Document)node) : NO_RULE_ISSUE;
        }

        @Override
        @NonNull
        public String getRuleName() {
            return "Latest version first";
        }
    }
    ,
    DATE_DISPLAYED{

        @Override
        public RuleIssue getRuleIssueOrNull(@NonNull Node node) {
            if (node == null) {
                throw new NullPointerException("node is marked non-null but is null");
            }
            return NO_RULE_ISSUE;
        }

        @Override
        @NonNull
        public String getRuleName() {
            return "Date displayed";
        }
    };


    @Override
    @NonNull
    public String getRuleId() {
        return RuleSupport.nameToId(this);
    }

    @Override
    @NonNull
    public String getRuleCategory() {
        return "main";
    }

    @Override
    public boolean isRuleAvailable() {
        return true;
    }

    @Override
    @NonNull
    public RuleSeverity getRuleSeverity() {
        return RuleSeverity.ERROR;
    }

    static RuleIssue validateForHumans(@NonNull Document document) {
        if (document == null) {
            throw new NullPointerException("document is marked non-null but is null");
        }
        List headings = Nodes.of(Heading.class).descendants((Node)document).filter(Changelog::isChangelogLevel).collect(Collectors.toList());
        switch (headings.size()) {
            case 0: {
                return RuleIssue.builder().message("Missing Changelog heading").location((Node)document).build();
            }
            case 1: {
                try {
                    Changelog.parse((Heading)headings.get(0));
                    return NO_RULE_ISSUE;
                }
                catch (IllegalArgumentException ex) {
                    return RuleIssue.builder().message(ex.getMessage()).location((Node)document).build();
                }
            }
        }
        return RuleIssue.builder().message("Too many Changelog headings").location((Node)document).build();
    }

    static RuleIssue validateAllH2ContainAVersion(@NonNull Heading heading) {
        if (heading == null) {
            throw new NullPointerException("heading is marked non-null but is null");
        }
        if (!Version.isVersionLevel(heading)) {
            return NO_RULE_ISSUE;
        }
        try {
            Version.parse(heading);
        }
        catch (IllegalArgumentException ex) {
            return RuleIssue.builder().message(ex.getMessage()).location((Node)heading).build();
        }
        return NO_RULE_ISSUE;
    }

    static RuleIssue validateTypeOfChangesGrouped(@NonNull Heading heading) {
        if (heading == null) {
            throw new NullPointerException("heading is marked non-null but is null");
        }
        if (!TypeOfChange.isTypeOfChangeLevel(heading)) {
            return NO_RULE_ISSUE;
        }
        try {
            TypeOfChange.parse(heading);
        }
        catch (IllegalArgumentException ex) {
            return RuleIssue.builder().message(ex.getMessage()).location((Node)heading).build();
        }
        return NO_RULE_ISSUE;
    }

    static RuleIssue validateLinkable(@NonNull Heading heading) {
        if (heading == null) {
            throw new NullPointerException("heading is marked non-null but is null");
        }
        if (!Version.isVersionLevel(heading)) {
            return NO_RULE_ISSUE;
        }
        try {
            Version version = Version.parse(heading);
            ReferenceRepository repository = (ReferenceRepository)Parser.REFERENCES.get((DataHolder)heading.getDocument());
            String normalizeRef = repository.normalizeKey((CharSequence)version.getRef());
            Reference reference = (Reference)repository.get((Object)normalizeRef);
            return reference == null ? RuleIssue.builder().message("Missing reference '" + version.getRef() + "'").location((Node)heading).build() : NO_RULE_ISSUE;
        }
        catch (IllegalArgumentException ex) {
            return NO_RULE_ISSUE;
        }
    }

    static RuleIssue validateLatestVersionFirst(@NonNull Document doc) {
        Comparator<VersionNode> comparator;
        if (doc == null) {
            throw new NullPointerException("doc is marked non-null but is null");
        }
        List<VersionNode> versions = VersionNode.allOf(doc);
        VersionNode unsortedItem = GuidingPrinciples.getFirstUnsortedItem(versions, comparator = Comparator.comparing(item -> item.getVersion().getDate()).reversed());
        return unsortedItem != null ? RuleIssue.builder().message("Versions not sorted").location(unsortedItem.getNode()).build() : NO_RULE_ISSUE;
    }

    private static <T> T getFirstUnsortedItem(List<T> list, Comparator<T> comparator) {
        if (list.isEmpty() || list.size() == 1) {
            return null;
        }
        Iterator<T> iterator = list.iterator();
        T previous = iterator.next();
        while (iterator.hasNext()) {
            T current = iterator.next();
            if (comparator.compare(previous, current) > 0) {
                return current;
            }
            previous = current;
        }
        return null;
    }

    private static final class VersionNode {
        private final Version version;
        private final Node node;

        static VersionNode parse(Heading node) {
            return new VersionNode(Version.parse(node), (Node)node);
        }

        static List<VersionNode> allOf(Document doc) {
            return Nodes.of(Heading.class).descendants((Node)doc).filter(Version::isVersionLevel).map(Util.illegalArgumentToNull(VersionNode::parse)).filter(Objects::nonNull).collect(Collectors.toList());
        }

        @Generated
        public VersionNode(Version version, Node node) {
            this.version = version;
            this.node = node;
        }

        @Generated
        public Version getVersion() {
            return this.version;
        }

        @Generated
        public Node getNode() {
            return this.node;
        }

        @Generated
        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof VersionNode)) {
                return false;
            }
            VersionNode other = (VersionNode)o;
            Version this$version = this.getVersion();
            Version other$version = other.getVersion();
            if (this$version == null ? other$version != null : !((Object)this$version).equals(other$version)) {
                return false;
            }
            Node this$node = this.getNode();
            Node other$node = other.getNode();
            return !(this$node == null ? other$node != null : !this$node.equals(other$node));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Version $version = this.getVersion();
            result = result * 59 + ($version == null ? 43 : ((Object)$version).hashCode());
            Node $node = this.getNode();
            result = result * 59 + ($node == null ? 43 : $node.hashCode());
            return result;
        }

        @Generated
        public @org.checkerframework.checker.nullness.qual.NonNull String toString() {
            return "GuidingPrinciples.VersionNode(version=" + this.getVersion() + ", node=" + this.getNode() + ")";
        }
    }

    public static final class Batch
    implements RuleBatch {
        @Override
        @NonNull
        public Stream<Rule> getProviders() {
            return Stream.of(GuidingPrinciples.values());
        }
    }
}

