/*
 * Decompiled with CFR 0.152.
 */
package internal.heylogs;

import com.vladsch.flexmark.ast.LinkNodeBase;
import com.vladsch.flexmark.util.ast.Document;
import com.vladsch.flexmark.util.ast.Node;
import java.net.URL;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import lombok.NonNull;
import nbbrd.heylogs.Nodes;
import nbbrd.heylogs.Problem;
import nbbrd.heylogs.spi.Rule;
import nbbrd.heylogs.spi.RuleIssue;
import nbbrd.io.text.Parser;

public final class RuleSupport {
    private RuleSupport() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    @NonNull
    public static String nameToId(Enum<?> o) {
        return o.name().toLowerCase(Locale.ROOT).replace('_', '-');
    }

    @NonNull
    public static Optional<URL> linkToURL(@NonNull LinkNodeBase link) {
        if (link == null) {
            throw new NullPointerException("link is marked non-null but is null");
        }
        return Parser.onURL().parseValue((CharSequence)link.getUrl());
    }

    @NonNull
    public static Stream<Problem> problemStreamOf(@NonNull Document root, @NonNull List<Rule> rules) {
        if (root == null) {
            throw new NullPointerException("root is marked non-null but is null");
        }
        if (rules == null) {
            throw new NullPointerException("rules is marked non-null but is null");
        }
        return Nodes.walk((Node)root).flatMap(node -> rules.stream().map(rule -> RuleSupport.getProblemOrNull(node, rule)).filter(Objects::nonNull));
    }

    private static Problem getProblemOrNull(Node node, Rule rule) {
        RuleIssue ruleIssueOrNull = rule.getRuleIssueOrNull(node);
        return ruleIssueOrNull != null ? Problem.builder().rule(rule).issue(ruleIssueOrNull).build() : null;
    }
}

