/*
 * Decompiled with CFR 0.152.
 */
package internal.heylogs;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import lombok.Generated;
import lombok.NonNull;
import nbbrd.heylogs.Check;
import nbbrd.heylogs.Problem;
import nbbrd.heylogs.Resource;
import nbbrd.heylogs.Scan;
import nbbrd.heylogs.Summary;
import nbbrd.heylogs.spi.Format;
import nbbrd.heylogs.spi.FormatType;
import nbbrd.io.text.Formatter;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class StylishFormat
implements Format {
    public static final String ID = "stylish";

    @Override
    @NonNull
    public String getFormatId() {
        return ID;
    }

    @Override
    @NonNull
    public String getFormatName() {
        return "Human-readable output";
    }

    @Override
    @NonNull
    public String getFormatCategory() {
        return "interaction";
    }

    @Override
    @NonNull
    public Set<FormatType> getSupportedFormatTypes() {
        return EnumSet.allOf(FormatType.class);
    }

    @Override
    public void formatProblems(@NonNull Appendable appendable, @NonNull List<Check> list) throws IOException {
        if (appendable == null) {
            throw new NullPointerException("appendable is marked non-null but is null");
        }
        if (list == null) {
            throw new NullPointerException("list is marked non-null but is null");
        }
        StylishWriter.builder().column(StylishFormat.getPositionFormatter(list)).column(StylishFormat.getRuleSeverityFormatter()).column((Formatter<Problem>)Formatter.of(problem -> problem.getIssue().getMessage())).column((Formatter<Problem>)Formatter.of(Problem::getId)).build().writeAll(appendable, list, Check::getSource, Check::getProblems, item -> this.getProblemsSummary(item.getProblems()));
    }

    private static Formatter<Problem> getPositionFormatter(List<Check> problems) {
        int l = problems.stream().flatMap(o -> o.getProblems().stream()).mapToInt(problem -> StylishFormat.getNumberOfDigits(problem.getIssue().getLine())).max().orElse(0);
        int c = problems.stream().flatMap(o -> o.getProblems().stream()).mapToInt(problem -> StylishFormat.getNumberOfDigits(problem.getIssue().getColumn())).max().orElse(0);
        String format = "%" + l + "d:%-" + c + "d";
        return Formatter.of(problem -> String.format(Locale.ROOT, format, problem.getIssue().getLine(), problem.getIssue().getColumn()));
    }

    private static Formatter<Problem> getRuleSeverityFormatter() {
        return Formatter.of(problem -> {
            switch (problem.getSeverity()) {
                case OFF: {
                    return "off";
                }
                case WARN: {
                    return "warning";
                }
                case ERROR: {
                    return "error";
                }
            }
            throw new RuntimeException();
        });
    }

    private static int getNumberOfDigits(int number) {
        return (int)(Math.log10(number) + 1.0);
    }

    private String getProblemsSummary(List<Problem> list) {
        switch (list.size()) {
            case 0: {
                return "No problem";
            }
            case 1: {
                return "1 problem";
            }
        }
        return list.size() + " problems";
    }

    @Override
    public void formatStatus(@NonNull Appendable appendable, @NonNull List<Scan> list) throws IOException {
        if (appendable == null) {
            throw new NullPointerException("appendable is marked non-null but is null");
        }
        if (list == null) {
            throw new NullPointerException("list is marked non-null but is null");
        }
        StylishWriter.builder().column(Formatter.onString()).build().writeAll(appendable, list, Scan::getSource, item -> this.getStatusBody(item.getSummary()), ignore -> null);
    }

    private List<String> getStatusBody(Summary summary) {
        ArrayList<String> result = new ArrayList<String>();
        if (summary.isValid()) {
            result.add("Valid changelog");
            if (summary.getReleaseCount() == 0) {
                result.add("No release found");
            } else {
                result.add(String.format(Locale.ROOT, "Found %d releases", summary.getReleaseCount()));
                result.add(String.format(Locale.ROOT, "Ranging from %s to %s", summary.getTimeRange().getFrom(), summary.getTimeRange().getTo()));
                result.add(summary.getCompatibilities().isEmpty() ? "Not compatible with known versioning" : "Compatible with " + String.join((CharSequence)", ", summary.getCompatibilities()));
            }
            result.add("Forged with " + Optional.ofNullable(summary.getForgeName()).orElse("unknown forge") + " at " + Optional.ofNullable(summary.getForgeURL()).map(URL::toString).orElse("unknown URL"));
            result.add(summary.getUnreleasedChanges() > 0 ? "Has " + summary.getUnreleasedChanges() + " unreleased changes" : "Has no unreleased changes");
        } else {
            result.add("Invalid changelog");
        }
        return result;
    }

    @Override
    public void formatResources(@NonNull Appendable appendable, @NonNull List<Resource> list) throws IOException {
        if (appendable == null) {
            throw new NullPointerException("appendable is marked non-null but is null");
        }
        if (list == null) {
            throw new NullPointerException("list is marked non-null but is null");
        }
        StylishWriter.builder().column(Formatter.of(Resource::getType)).column(Formatter.of(Resource::getCategory)).column(Formatter.of(Resource::getId)).column(Formatter.of(Resource::getName)).build().write(appendable, "Resources", list, this.getResourcesSummary(list));
    }

    private String getResourcesSummary(List<Resource> list) {
        switch (list.size()) {
            case 0: {
                return "No resource found";
            }
            case 1: {
                return "1 resource found";
            }
        }
        return list.size() + " resources found";
    }

    private static final class StylishWriter<T> {
        private final String delimiter;
        private final String separator;
        private final List<Formatter<T>> columns;

        public <X> void writeAll(Appendable appendable, List<X> list, Function<X, CharSequence> header, Function<X, List<T>> body, Function<X, CharSequence> footer) throws IOException {
            Iterator<X> iterator = list.iterator();
            if (iterator.hasNext()) {
                X first = iterator.next();
                this.write(appendable, header.apply(first), body.apply(first), footer.apply(first));
                while (iterator.hasNext()) {
                    appendable.append(this.separator);
                    X next = iterator.next();
                    this.write(appendable, header.apply(next), body.apply(next), footer.apply(next));
                }
            }
        }

        public void write(Appendable appendable, CharSequence header, List<T> body, CharSequence footer) throws IOException {
            this.writeHeader(appendable, header);
            this.writeBody(appendable, body);
            if (footer != null) {
                this.writeFooter(appendable, footer);
            }
        }

        private void writeHeader(Appendable appendable, CharSequence header) throws IOException {
            appendable.append(header);
            appendable.append(this.separator);
        }

        private void writeBody(Appendable appendable, List<T> body) throws IOException {
            int i;
            ArrayList<CharSequence[]> rows = new ArrayList<CharSequence[]>();
            for (Object value : body) {
                CharSequence[] row = new CharSequence[this.columns.size()];
                for (i = 0; i < row.length; ++i) {
                    row[i] = this.columns.get(i).format(value);
                }
                rows.add(row);
            }
            int[] sizes = new int[this.columns.size()];
            for (CharSequence[] row : rows) {
                for (i = 0; i < row.length; ++i) {
                    sizes[i] = Math.max(sizes[i], row[i].length());
                }
            }
            String[] patterns = new String[this.columns.size()];
            for (int i2 = 0; i2 < patterns.length; ++i2) {
                patterns[i2] = "%-" + sizes[i2] + "s";
            }
            for (CharSequence[] row : rows) {
                for (int i3 = 0; i3 < row.length; ++i3) {
                    appendable.append(this.delimiter).append(String.format(Locale.ROOT, patterns[i3], row[i3]));
                }
                appendable.append(this.separator);
            }
        }

        private void writeFooter(Appendable appendable, CharSequence footer) throws IOException {
            appendable.append(this.delimiter).append(this.separator);
            appendable.append(this.delimiter).append(footer);
            appendable.append(this.separator);
        }

        @Generated
        private static <T> String $default$delimiter() {
            return "  ";
        }

        @Generated
        private static <T> String $default$separator() {
            return System.lineSeparator();
        }

        @Generated
        StylishWriter(String delimiter, String separator, List<Formatter<T>> columns) {
            this.delimiter = delimiter;
            this.separator = separator;
            this.columns = columns;
        }

        @Generated
        public static <T> @org.checkerframework.checker.nullness.qual.NonNull Builder<T> builder() {
            return new Builder();
        }

        @Generated
        public String getDelimiter() {
            return this.delimiter;
        }

        @Generated
        public String getSeparator() {
            return this.separator;
        }

        @Generated
        public List<Formatter<T>> getColumns() {
            return this.columns;
        }

        @Generated
        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof StylishWriter)) {
                return false;
            }
            StylishWriter other = (StylishWriter)o;
            String this$delimiter = this.getDelimiter();
            String other$delimiter = other.getDelimiter();
            if (this$delimiter == null ? other$delimiter != null : !this$delimiter.equals(other$delimiter)) {
                return false;
            }
            String this$separator = this.getSeparator();
            String other$separator = other.getSeparator();
            if (this$separator == null ? other$separator != null : !this$separator.equals(other$separator)) {
                return false;
            }
            List<Formatter<T>> this$columns = this.getColumns();
            List<Formatter<T>> other$columns = other.getColumns();
            return !(this$columns == null ? other$columns != null : !((Object)this$columns).equals(other$columns));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $delimiter = this.getDelimiter();
            result = result * 59 + ($delimiter == null ? 43 : $delimiter.hashCode());
            String $separator = this.getSeparator();
            result = result * 59 + ($separator == null ? 43 : $separator.hashCode());
            List<Formatter<T>> $columns = this.getColumns();
            result = result * 59 + ($columns == null ? 43 : ((Object)$columns).hashCode());
            return result;
        }

        @Generated
        public @org.checkerframework.checker.nullness.qual.NonNull String toString() {
            return "StylishFormat.StylishWriter(delimiter=" + this.getDelimiter() + ", separator=" + this.getSeparator() + ", columns=" + this.getColumns() + ")";
        }

        @Generated
        public static class Builder<T> {
            @Generated
            private boolean delimiter$set;
            @Generated
            private String delimiter$value;
            @Generated
            private boolean separator$set;
            @Generated
            private String separator$value;
            @Generated
            private ArrayList<Formatter<T>> columns;

            @Generated
            Builder() {
            }

            @Generated
            public @org.checkerframework.checker.nullness.qual.NonNull Builder<T> delimiter(String delimiter) {
                this.delimiter$value = delimiter;
                this.delimiter$set = true;
                return this;
            }

            @Generated
            public @org.checkerframework.checker.nullness.qual.NonNull Builder<T> separator(String separator) {
                this.separator$value = separator;
                this.separator$set = true;
                return this;
            }

            @Generated
            public @org.checkerframework.checker.nullness.qual.NonNull Builder<T> column(Formatter<T> column) {
                if (this.columns == null) {
                    this.columns = new ArrayList();
                }
                this.columns.add(column);
                return this;
            }

            @Generated
            public @org.checkerframework.checker.nullness.qual.NonNull Builder<T> columns(@org.checkerframework.checker.nullness.qual.NonNull Collection<? extends Formatter<T>> columns) {
                if (columns == null) {
                    throw new NullPointerException("columns cannot be null");
                }
                if (this.columns == null) {
                    this.columns = new ArrayList();
                }
                this.columns.addAll(columns);
                return this;
            }

            @Generated
            public @org.checkerframework.checker.nullness.qual.NonNull Builder<T> clearColumns() {
                if (this.columns != null) {
                    this.columns.clear();
                }
                return this;
            }

            @Generated
            public @org.checkerframework.checker.nullness.qual.NonNull StylishWriter<T> build() {
                List columns;
                switch (this.columns == null ? 0 : this.columns.size()) {
                    case 0: {
                        columns = Collections.emptyList();
                        break;
                    }
                    case 1: {
                        columns = Collections.singletonList(this.columns.get(0));
                        break;
                    }
                    default: {
                        columns = Collections.unmodifiableList(new ArrayList<Formatter<T>>(this.columns));
                    }
                }
                String delimiter$value = this.delimiter$value;
                if (!this.delimiter$set) {
                    delimiter$value = StylishWriter.$default$delimiter();
                }
                String separator$value = this.separator$value;
                if (!this.separator$set) {
                    separator$value = StylishWriter.$default$separator();
                }
                return new StylishWriter(delimiter$value, separator$value, columns);
            }

            @Generated
            public @org.checkerframework.checker.nullness.qual.NonNull String toString() {
                return "StylishFormat.StylishWriter.Builder(delimiter$value=" + this.delimiter$value + ", separator$value=" + this.separator$value + ", columns=" + this.columns + ")";
            }
        }
    }
}

