/*
 * Decompiled with CFR 0.152.
 */
package internal.heylogs;

import java.util.Comparator;
import java.util.function.Consumer;
import java.util.stream.Collector;
import lombok.Generated;
import org.checkerframework.checker.nullness.qual.NonNull;

public final class SummaryStatistics<T>
implements Consumer<T> {
    private final Comparator<? super T> comparator;
    private long count;
    private T min;
    private T max;

    public static <T extends Comparable<? super T>> Collector<T, ?, SummaryStatistics<T>> summarizing() {
        return SummaryStatistics.summarizing(Comparator.naturalOrder());
    }

    public static <T> Collector<T, ?, SummaryStatistics<T>> summarizing(Comparator<? super T> comparator) {
        return Collector.of(() -> new SummaryStatistics(comparator), SummaryStatistics::accept, SummaryStatistics::combine, Collector.Characteristics.UNORDERED, Collector.Characteristics.IDENTITY_FINISH);
    }

    @Override
    public void accept(T value) {
        if (this.count == 0L) {
            this.max = value;
            this.min = this.max;
        } else if (this.comparator.compare(value, this.min) < 0) {
            this.min = value;
        } else if (this.comparator.compare(value, this.max) > 0) {
            this.max = value;
        }
        ++this.count;
    }

    public SummaryStatistics<T> combine(SummaryStatistics<T> other) {
        if (this.count == 0L) {
            return other;
        }
        if (other.count == 0L) {
            return this;
        }
        this.count += other.count;
        if (this.comparator.compare(other.min, this.min) < 0) {
            this.min = other.min;
        }
        if (this.comparator.compare(other.max, this.max) > 0) {
            this.max = other.max;
        }
        return this;
    }

    @Generated
    public Comparator<? super T> getComparator() {
        return this.comparator;
    }

    @Generated
    public long getCount() {
        return this.count;
    }

    @Generated
    public T getMin() {
        return this.min;
    }

    @Generated
    public T getMax() {
        return this.max;
    }

    @Generated
    public @NonNull String toString() {
        return "SummaryStatistics(comparator=" + this.getComparator() + ", count=" + this.getCount() + ", min=" + this.getMin() + ", max=" + this.getMax() + ")";
    }

    @Generated
    public SummaryStatistics(Comparator<? super T> comparator) {
        this.comparator = comparator;
    }
}

