/*
 * Decompiled with CFR 0.152.
 */
package internal.heylogs;

import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.regex.Pattern;
import java.util.stream.IntStream;
import lombok.NonNull;

public final class URLExtractor {
    private URLExtractor() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    @NonNull
    public static String[] getPathArray(@NonNull URL url) {
        if (url == null) {
            throw new NullPointerException("url is marked non-null but is null");
        }
        String path = url.getPath();
        if (path == null || path.isEmpty()) {
            return new String[0];
        }
        String[] result = path.substring(1).split("/", -1);
        for (int i = 0; i < result.length; ++i) {
            result[i] = URLExtractor.decode(result[i]);
        }
        return result;
    }

    private static String decode(String o) {
        try {
            return URLDecoder.decode(o, StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException ex) {
            throw new RuntimeException(ex);
        }
    }

    @NonNull
    public static URL baseOf(@NonNull URL url) {
        if (url == null) {
            throw new NullPointerException("url is marked non-null but is null");
        }
        try {
            return new URI(url.getProtocol(), url.getUserInfo(), url.getHost(), url.getPort(), null, null, null).toURL();
        }
        catch (MalformedURLException | URISyntaxException ex) {
            throw new IllegalArgumentException(ex);
        }
    }

    @NonNull
    public static URL urlOf(@NonNull CharSequence text) throws IllegalArgumentException {
        if (text == null) {
            throw new NullPointerException("text is marked non-null but is null");
        }
        try {
            return URI.create(text.toString()).toURL();
        }
        catch (MalformedURLException ex) {
            throw new IllegalArgumentException(ex);
        }
    }

    public static void checkPathLength(String[] pathArray, int ... lengths) {
        if (IntStream.of(lengths).noneMatch(length -> length == pathArray.length)) {
            throw new IllegalArgumentException("Invalid path length: expecting " + Arrays.toString(lengths) + ", found " + pathArray.length);
        }
    }

    public static void checkPathItem(String[] pathArray, int index, String ... values) {
        if (!Arrays.asList(values).contains(pathArray[index])) {
            throw new IllegalArgumentException("Invalid path item: expecting " + Arrays.toString(values) + ", found '" + pathArray[index] + "'");
        }
    }

    public static void checkPathItem(String[] pathArray, int index, Pattern pattern) {
        if (!pattern.matcher(pathArray[index]).matches()) {
            throw new IllegalArgumentException("Invalid path item at index " + index + ": expecting pattern '" + pattern.pattern() + "', found '" + pathArray[index] + "'");
        }
    }
}

