/*
 * Decompiled with CFR 0.152.
 */
package internal.heylogs;

import com.vladsch.flexmark.ast.Heading;
import com.vladsch.flexmark.ast.Reference;
import com.vladsch.flexmark.ast.util.ReferenceRepository;
import com.vladsch.flexmark.util.ast.Document;
import com.vladsch.flexmark.util.ast.Node;
import internal.heylogs.ChangelogNodes;
import internal.heylogs.URLExtractor;
import java.net.URL;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import nbbrd.heylogs.Nodes;
import nbbrd.heylogs.Version;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class VersionNode {
    @lombok.NonNull
    private final Heading heading;
    @lombok.NonNull
    private final Version version;
    @lombok.NonNull
    private final Reference reference;

    public static VersionNode of(Version version, URL url) {
        return new VersionNode(version.toHeading(), version, ChangelogNodes.newReference(version, url));
    }

    public static List<VersionNode> allOf(Document document, ReferenceRepository repository) {
        return Nodes.of(Heading.class).descendants((Node)document).filter(Version::isVersionLevel).map(heading -> {
            try {
                Version version = Version.parse(heading);
                return new VersionNode((Heading)heading, version, Objects.requireNonNull((Reference)repository.getFromRaw((CharSequence)version.getRef())));
            }
            catch (RuntimeException ex) {
                return null;
            }
        }).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public static Optional<VersionNode> findUnreleased(List<VersionNode> list) {
        return list.stream().filter(versionNode -> versionNode.getVersion().isUnreleased()).findFirst();
    }

    public URL getURL() {
        return URLExtractor.urlOf((CharSequence)this.getReference().getUrl());
    }

    @Generated
    public VersionNode(@lombok.NonNull Heading heading, @lombok.NonNull Version version, @lombok.NonNull Reference reference) {
        if (heading == null) {
            throw new NullPointerException("heading is marked non-null but is null");
        }
        if (version == null) {
            throw new NullPointerException("version is marked non-null but is null");
        }
        if (reference == null) {
            throw new NullPointerException("reference is marked non-null but is null");
        }
        this.heading = heading;
        this.version = version;
        this.reference = reference;
    }

    @lombok.NonNull
    @Generated
    public Heading getHeading() {
        return this.heading;
    }

    @lombok.NonNull
    @Generated
    public Version getVersion() {
        return this.version;
    }

    @lombok.NonNull
    @Generated
    public Reference getReference() {
        return this.reference;
    }

    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof VersionNode)) {
            return false;
        }
        VersionNode other = (VersionNode)o;
        Heading this$heading = this.getHeading();
        Heading other$heading = other.getHeading();
        if (this$heading == null ? other$heading != null : !this$heading.equals(other$heading)) {
            return false;
        }
        Version this$version = this.getVersion();
        Version other$version = other.getVersion();
        if (this$version == null ? other$version != null : !((Object)this$version).equals(other$version)) {
            return false;
        }
        Reference this$reference = this.getReference();
        Reference other$reference = other.getReference();
        return !(this$reference == null ? other$reference != null : !this$reference.equals(other$reference));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Heading $heading = this.getHeading();
        result = result * 59 + ($heading == null ? 43 : $heading.hashCode());
        Version $version = this.getVersion();
        result = result * 59 + ($version == null ? 43 : ((Object)$version).hashCode());
        Reference $reference = this.getReference();
        result = result * 59 + ($reference == null ? 43 : $reference.hashCode());
        return result;
    }

    @Generated
    public @NonNull String toString() {
        return "VersionNode(heading=" + this.getHeading() + ", version=" + this.getVersion() + ", reference=" + this.getReference() + ")";
    }
}

