/*
 * Decompiled with CFR 0.152.
 */
package nbbrd.heylogs;

import com.vladsch.flexmark.ast.Heading;
import com.vladsch.flexmark.ast.Text;
import com.vladsch.flexmark.util.ast.Node;
import com.vladsch.flexmark.util.sequence.BasedSequence;
import lombok.NonNull;
import nbbrd.heylogs.BaseSection;

public enum Changelog implements BaseSection
{
    INSTANCE;

    private static final int HEADING_LEVEL = 1;

    @NonNull
    public static Changelog parse(@NonNull Heading heading) {
        if (heading == null) {
            throw new NullPointerException("heading is marked non-null but is null");
        }
        if (!Changelog.isChangelogLevel(heading)) {
            throw new IllegalArgumentException("Invalid heading level");
        }
        if (!"Changelog".contentEquals((CharSequence)heading.getText())) {
            throw new IllegalArgumentException("Invalid text");
        }
        return INSTANCE;
    }

    @Override
    @NonNull
    public Heading toHeading() {
        Heading result = new Heading();
        result.setOpeningMarker(BasedSequence.repeatOf((CharSequence)"#", (int)1));
        result.setLevel(1);
        result.appendChild((Node)new Text(BasedSequence.of((CharSequence)"Changelog")));
        return result;
    }

    public static boolean isChangelogLevel(Heading heading) {
        return heading.getLevel() == 1;
    }
}

