/*
 * Decompiled with CFR 0.152.
 */
package nbbrd.heylogs;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import lombok.Generated;
import nbbrd.heylogs.Problem;
import nbbrd.heylogs.spi.RuleSeverity;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class Check {
    @lombok.NonNull
    private final String source;
    private final List<Problem> problems;

    public boolean hasErrors() {
        return this.problems.stream().anyMatch(problem -> problem.getSeverity().equals((Object)RuleSeverity.ERROR));
    }

    @Generated
    Check(@lombok.NonNull String source, List<Problem> problems) {
        if (source == null) {
            throw new NullPointerException("source is marked non-null but is null");
        }
        this.source = source;
        this.problems = problems;
    }

    @Generated
    public static @NonNull Builder builder() {
        return new Builder();
    }

    @lombok.NonNull
    @Generated
    public String getSource() {
        return this.source;
    }

    @Generated
    public List<Problem> getProblems() {
        return this.problems;
    }

    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Check)) {
            return false;
        }
        Check other = (Check)o;
        String this$source = this.getSource();
        String other$source = other.getSource();
        if (this$source == null ? other$source != null : !this$source.equals(other$source)) {
            return false;
        }
        List<Problem> this$problems = this.getProblems();
        List<Problem> other$problems = other.getProblems();
        return !(this$problems == null ? other$problems != null : !((Object)this$problems).equals(other$problems));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $source = this.getSource();
        result = result * 59 + ($source == null ? 43 : $source.hashCode());
        List<Problem> $problems = this.getProblems();
        result = result * 59 + ($problems == null ? 43 : ((Object)$problems).hashCode());
        return result;
    }

    @Generated
    public @NonNull String toString() {
        return "Check(source=" + this.getSource() + ", problems=" + this.getProblems() + ")";
    }

    @Generated
    public static class Builder {
        @Generated
        private String source;
        @Generated
        private ArrayList<Problem> problems;

        @Generated
        Builder() {
        }

        @Generated
        public @NonNull Builder source(@lombok.NonNull String source) {
            if (source == null) {
                throw new NullPointerException("source is marked non-null but is null");
            }
            this.source = source;
            return this;
        }

        @Generated
        public @NonNull Builder problem(Problem problem) {
            if (this.problems == null) {
                this.problems = new ArrayList();
            }
            this.problems.add(problem);
            return this;
        }

        @Generated
        public @NonNull Builder problems(@NonNull Collection<? extends Problem> problems) {
            if (problems == null) {
                throw new NullPointerException("problems cannot be null");
            }
            if (this.problems == null) {
                this.problems = new ArrayList();
            }
            this.problems.addAll(problems);
            return this;
        }

        @Generated
        public @NonNull Builder clearProblems() {
            if (this.problems != null) {
                this.problems.clear();
            }
            return this;
        }

        @Generated
        public @NonNull Check build() {
            List<Problem> problems;
            switch (this.problems == null ? 0 : this.problems.size()) {
                case 0: {
                    problems = Collections.emptyList();
                    break;
                }
                case 1: {
                    problems = Collections.singletonList(this.problems.get(0));
                    break;
                }
                default: {
                    problems = Collections.unmodifiableList(new ArrayList<Problem>(this.problems));
                }
            }
            return new Check(this.source, problems);
        }

        @Generated
        public @NonNull String toString() {
            return "Check.Builder(source=" + this.source + ", problems=" + this.problems + ")";
        }
    }
}

