/*
 * Decompiled with CFR 0.152.
 */
package nbbrd.heylogs;

import java.time.LocalDate;
import java.time.Year;
import java.time.YearMonth;
import java.util.regex.Pattern;
import lombok.Generated;
import nbbrd.heylogs.TimeRange;
import nbbrd.heylogs.Version;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class Filter {
    public static final Filter DEFAULT = Filter.builder().build();
    @lombok.NonNull
    private final String ref;
    @lombok.NonNull
    private final Pattern unreleasedPattern;
    @lombok.NonNull
    private final TimeRange timeRange;
    private final int limit;
    private final boolean ignoreContent;

    private boolean isUnreleasedPattern() {
        return this.unreleasedPattern.asPredicate().test(this.ref);
    }

    private boolean containsRef(@lombok.NonNull Version version) {
        if (version == null) {
            throw new NullPointerException("version is marked non-null but is null");
        }
        return this.isUnreleasedPattern() && version.isUnreleased() || version.getRef().contains(this.ref);
    }

    public boolean contains(@lombok.NonNull Version version) {
        if (version == null) {
            throw new NullPointerException("version is marked non-null but is null");
        }
        return this.containsRef(version) && this.timeRange.contains(version.getDate());
    }

    @lombok.NonNull
    public static LocalDate parseLocalDate(@lombok.NonNull CharSequence input) {
        if (input == null) {
            throw new NullPointerException("input is marked non-null but is null");
        }
        try {
            return Year.parse(input).atDay(1);
        }
        catch (Exception ex1) {
            try {
                return YearMonth.parse(input).atDay(1);
            }
            catch (Exception ex2) {
                return LocalDate.parse(input);
            }
        }
    }

    @Generated
    private static String $default$ref() {
        return "";
    }

    @Generated
    private static Pattern $default$unreleasedPattern() {
        return Pattern.compile("^.*-SNAPSHOT$");
    }

    @Generated
    private static TimeRange $default$timeRange() {
        return TimeRange.ALL;
    }

    @Generated
    private static int $default$limit() {
        return Integer.MAX_VALUE;
    }

    @Generated
    private static boolean $default$ignoreContent() {
        return false;
    }

    @Generated
    Filter(@lombok.NonNull String ref, @lombok.NonNull Pattern unreleasedPattern, @lombok.NonNull TimeRange timeRange, int limit, boolean ignoreContent) {
        if (ref == null) {
            throw new NullPointerException("ref is marked non-null but is null");
        }
        if (unreleasedPattern == null) {
            throw new NullPointerException("unreleasedPattern is marked non-null but is null");
        }
        if (timeRange == null) {
            throw new NullPointerException("timeRange is marked non-null but is null");
        }
        this.ref = ref;
        this.unreleasedPattern = unreleasedPattern;
        this.timeRange = timeRange;
        this.limit = limit;
        this.ignoreContent = ignoreContent;
    }

    @Generated
    public static @NonNull Builder builder() {
        return new Builder();
    }

    @Generated
    public @NonNull Builder toBuilder() {
        return new Builder().ref(this.ref).unreleasedPattern(this.unreleasedPattern).timeRange(this.timeRange).limit(this.limit).ignoreContent(this.ignoreContent);
    }

    @lombok.NonNull
    @Generated
    public String getRef() {
        return this.ref;
    }

    @lombok.NonNull
    @Generated
    public Pattern getUnreleasedPattern() {
        return this.unreleasedPattern;
    }

    @lombok.NonNull
    @Generated
    public TimeRange getTimeRange() {
        return this.timeRange;
    }

    @Generated
    public int getLimit() {
        return this.limit;
    }

    @Generated
    public boolean isIgnoreContent() {
        return this.ignoreContent;
    }

    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Filter)) {
            return false;
        }
        Filter other = (Filter)o;
        if (this.getLimit() != other.getLimit()) {
            return false;
        }
        if (this.isIgnoreContent() != other.isIgnoreContent()) {
            return false;
        }
        String this$ref = this.getRef();
        String other$ref = other.getRef();
        if (this$ref == null ? other$ref != null : !this$ref.equals(other$ref)) {
            return false;
        }
        Pattern this$unreleasedPattern = this.getUnreleasedPattern();
        Pattern other$unreleasedPattern = other.getUnreleasedPattern();
        if (this$unreleasedPattern == null ? other$unreleasedPattern != null : !this$unreleasedPattern.equals(other$unreleasedPattern)) {
            return false;
        }
        TimeRange this$timeRange = this.getTimeRange();
        TimeRange other$timeRange = other.getTimeRange();
        return !(this$timeRange == null ? other$timeRange != null : !((Object)this$timeRange).equals(other$timeRange));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getLimit();
        result = result * 59 + (this.isIgnoreContent() ? 79 : 97);
        String $ref = this.getRef();
        result = result * 59 + ($ref == null ? 43 : $ref.hashCode());
        Pattern $unreleasedPattern = this.getUnreleasedPattern();
        result = result * 59 + ($unreleasedPattern == null ? 43 : $unreleasedPattern.hashCode());
        TimeRange $timeRange = this.getTimeRange();
        result = result * 59 + ($timeRange == null ? 43 : ((Object)$timeRange).hashCode());
        return result;
    }

    @Generated
    public @NonNull String toString() {
        return "Filter(ref=" + this.getRef() + ", unreleasedPattern=" + this.getUnreleasedPattern() + ", timeRange=" + this.getTimeRange() + ", limit=" + this.getLimit() + ", ignoreContent=" + this.isIgnoreContent() + ")";
    }

    @Generated
    public static class Builder {
        @Generated
        private boolean ref$set;
        @Generated
        private String ref$value;
        @Generated
        private boolean unreleasedPattern$set;
        @Generated
        private Pattern unreleasedPattern$value;
        @Generated
        private boolean timeRange$set;
        @Generated
        private TimeRange timeRange$value;
        @Generated
        private boolean limit$set;
        @Generated
        private int limit$value;
        @Generated
        private boolean ignoreContent$set;
        @Generated
        private boolean ignoreContent$value;

        @Generated
        Builder() {
        }

        @Generated
        public @NonNull Builder ref(@lombok.NonNull String ref) {
            if (ref == null) {
                throw new NullPointerException("ref is marked non-null but is null");
            }
            this.ref$value = ref;
            this.ref$set = true;
            return this;
        }

        @Generated
        public @NonNull Builder unreleasedPattern(@lombok.NonNull Pattern unreleasedPattern) {
            if (unreleasedPattern == null) {
                throw new NullPointerException("unreleasedPattern is marked non-null but is null");
            }
            this.unreleasedPattern$value = unreleasedPattern;
            this.unreleasedPattern$set = true;
            return this;
        }

        @Generated
        public @NonNull Builder timeRange(@lombok.NonNull TimeRange timeRange) {
            if (timeRange == null) {
                throw new NullPointerException("timeRange is marked non-null but is null");
            }
            this.timeRange$value = timeRange;
            this.timeRange$set = true;
            return this;
        }

        @Generated
        public @NonNull Builder limit(int limit) {
            this.limit$value = limit;
            this.limit$set = true;
            return this;
        }

        @Generated
        public @NonNull Builder ignoreContent(boolean ignoreContent) {
            this.ignoreContent$value = ignoreContent;
            this.ignoreContent$set = true;
            return this;
        }

        @Generated
        public @NonNull Filter build() {
            String ref$value = this.ref$value;
            if (!this.ref$set) {
                ref$value = Filter.$default$ref();
            }
            Pattern unreleasedPattern$value = this.unreleasedPattern$value;
            if (!this.unreleasedPattern$set) {
                unreleasedPattern$value = Filter.$default$unreleasedPattern();
            }
            TimeRange timeRange$value = this.timeRange$value;
            if (!this.timeRange$set) {
                timeRange$value = Filter.$default$timeRange();
            }
            int limit$value = this.limit$value;
            if (!this.limit$set) {
                limit$value = Filter.$default$limit();
            }
            boolean ignoreContent$value = this.ignoreContent$value;
            if (!this.ignoreContent$set) {
                ignoreContent$value = Filter.$default$ignoreContent();
            }
            return new Filter(ref$value, unreleasedPattern$value, timeRange$value, limit$value, ignoreContent$value);
        }

        @Generated
        public @NonNull String toString() {
            return "Filter.Builder(ref$value=" + this.ref$value + ", unreleasedPattern$value=" + this.unreleasedPattern$value + ", timeRange$value=" + this.timeRange$value + ", limit$value=" + this.limit$value + ", ignoreContent$value=" + this.ignoreContent$value + ")";
        }
    }
}

