/*
 * Decompiled with CFR 0.152.
 */
package nbbrd.heylogs;

import com.vladsch.flexmark.ast.Heading;
import com.vladsch.flexmark.ast.RefNode;
import com.vladsch.flexmark.ast.Reference;
import com.vladsch.flexmark.ast.util.ReferenceRepository;
import com.vladsch.flexmark.parser.Parser;
import com.vladsch.flexmark.util.ast.Document;
import com.vladsch.flexmark.util.ast.Node;
import com.vladsch.flexmark.util.data.DataHolder;
import internal.heylogs.ChangelogNodes;
import internal.heylogs.GuidingPrinciples;
import internal.heylogs.RuleSupport;
import internal.heylogs.URLExtractor;
import internal.heylogs.VersionNode;
import internal.heylogs.VersioningSupport;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import lombok.NonNull;
import nbbrd.heylogs.Check;
import nbbrd.heylogs.Filter;
import nbbrd.heylogs.Nodes;
import nbbrd.heylogs.Problem;
import nbbrd.heylogs.Resource;
import nbbrd.heylogs.Scan;
import nbbrd.heylogs.Summary;
import nbbrd.heylogs.TimeRange;
import nbbrd.heylogs.Version;
import nbbrd.heylogs.spi.Forge;
import nbbrd.heylogs.spi.ForgeLoader;
import nbbrd.heylogs.spi.Format;
import nbbrd.heylogs.spi.FormatLoader;
import nbbrd.heylogs.spi.Rule;
import nbbrd.heylogs.spi.RuleLoader;
import nbbrd.heylogs.spi.Versioning;
import nbbrd.heylogs.spi.VersioningLoader;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class Heylogs {
    @NonNull
    private final List<Rule> rules;
    @NonNull
    private final List<Format> formats;
    @NonNull
    private final List<Versioning> versionings;
    @NonNull
    private final List<Forge> forges;
    public static final String FIRST_FORMAT_AVAILABLE = "";

    @NonNull
    public static Heylogs ofServiceLoader() {
        return Heylogs.builder().rules(RuleLoader.load()).formats(FormatLoader.load()).versionings(VersioningLoader.load()).forges(ForgeLoader.load()).build();
    }

    @NonNull
    public List<Problem> checkFormat(@NonNull Document document) {
        if (document == null) {
            throw new NullPointerException("document is marked non-null but is null");
        }
        return RuleSupport.problemStreamOf(document, this.rules).collect(Collectors.toList());
    }

    public void extractVersions(@NonNull Document document, @NonNull Filter filter) {
        if (document == null) {
            throw new NullPointerException("document is marked non-null but is null");
        }
        if (filter == null) {
            throw new NullPointerException("filter is marked non-null but is null");
        }
        if (Heylogs.isNotValidAgainstGuidingPrinciples(document)) {
            throw new IllegalArgumentException("Invalid changelog");
        }
        int found = 0;
        boolean keep = false;
        ArrayList refNodes = new ArrayList();
        ArrayList<Reference> references = new ArrayList<Reference>();
        for (Node current : document.getChildren()) {
            boolean versionHeading;
            boolean bl = versionHeading = current instanceof Heading && Version.isVersionLevel((Heading)current);
            if (versionHeading) {
                if (found >= filter.getLimit() || !filter.contains(Version.parse((Heading)current))) {
                    keep = false;
                } else {
                    ++found;
                    keep = true;
                }
            }
            if (keep) {
                Nodes.of(RefNode.class).descendants(current).map(node -> node.getReference().toString()).forEach(refNodes::add);
                if (!versionHeading || !filter.isIgnoreContent()) continue;
                keep = false;
                continue;
            }
            if (current instanceof Reference) {
                references.add((Reference)current);
                continue;
            }
            current.unlink();
        }
        references.stream().filter(reference -> !refNodes.contains(reference.getReference().toString())).forEach(Node::unlink);
    }

    @NonNull
    public List<Resource> listResources() {
        return Heylogs.concat(this.rules.stream().map(Resource::of), this.formats.stream().map(Resource::of), this.versionings.stream().map(Resource::of), this.forges.stream().map(Resource::of)).sorted(Resource.DEFAULT_COMPARATOR).collect(Collectors.toList());
    }

    public void releaseChanges(@NonNull Document document, @NonNull Version newVersion, @NonNull String versionTagPrefix) {
        if (document == null) {
            throw new NullPointerException("document is marked non-null but is null");
        }
        if (newVersion == null) {
            throw new NullPointerException("newVersion is marked non-null but is null");
        }
        if (versionTagPrefix == null) {
            throw new NullPointerException("versionTagPrefix is marked non-null but is null");
        }
        if (Heylogs.isNotValidAgainstGuidingPrinciples(document)) {
            throw new IllegalArgumentException("Invalid changelog");
        }
        ReferenceRepository repository = (ReferenceRepository)Parser.REFERENCES.get((DataHolder)document);
        List<VersionNode> versions = VersionNode.allOf(document, repository);
        VersionNode unreleased = VersionNode.findUnreleased(versions).orElseThrow(() -> new IllegalArgumentException("Cannot locate unreleased header"));
        Forge forge = this.findForge(unreleased).orElseThrow(() -> new IllegalArgumentException("Cannot determine forge"));
        URL releaseURL = forge.deriveCompareLink(unreleased.getURL(), versionTagPrefix + newVersion.getRef());
        VersionNode release = VersionNode.of(newVersion, releaseURL);
        URL updatedURL = forge.deriveCompareLink(releaseURL, "HEAD");
        VersionNode updated = VersionNode.of(unreleased.getVersion(), updatedURL);
        repository.putRawKey((CharSequence)release.getReference().getReference(), (Object)release.getReference());
        repository.putRawKey((CharSequence)updated.getReference().getReference(), (Object)updated.getReference());
        unreleased.getHeading().appendChild((Node)release.getHeading());
        unreleased.getReference().insertAfter((Node)release.getReference());
        unreleased.getReference().insertBefore((Node)updated.getReference());
        unreleased.getReference().unlink();
    }

    @NonNull
    public Summary scanContent(@NonNull Document document) {
        if (document == null) {
            throw new NullPointerException("document is marked non-null but is null");
        }
        if (Heylogs.isNotValidAgainstGuidingPrinciples(document)) {
            return Summary.INVALID;
        }
        ReferenceRepository repository = (ReferenceRepository)Parser.REFERENCES.get((DataHolder)document);
        List<VersionNode> versions = VersionNode.allOf(document, repository);
        if (versions.isEmpty()) {
            return Summary.EMPTY;
        }
        List<Version> releases = versions.stream().map(VersionNode::getVersion).filter(version -> !version.isUnreleased()).collect(Collectors.toList());
        long unreleasedChanges = VersionNode.findUnreleased(versions).map(VersionNode::getHeading).map(ChangelogNodes::getBulletListsByTypeOfChange).map(o -> o.values().stream().mapToLong(List::size).sum()).orElse(0L);
        VersionNode first = versions.get(0);
        Forge forgeOrNull = this.findForge(first).orElse(null);
        return Summary.builder().valid(true).releaseCount(releases.size()).timeRange(releases.stream().map(Version::getDate).collect(TimeRange.toTimeRange()).orElse(TimeRange.ALL)).compatibilities(VersioningSupport.versioningStreamOf(this.versionings, releases).map(Versioning::getVersioningName).collect(Collectors.toList())).unreleasedChanges((int)unreleasedChanges).forgeName(forgeOrNull != null ? forgeOrNull.getForgeName() : null).forgeURL(this.getBaseURL(forgeOrNull, first.getURL())).build();
    }

    public void formatProblems(@NonNull String formatId, @NonNull Appendable appendable, @NonNull List<Check> list) throws IOException {
        if (formatId == null) {
            throw new NullPointerException("formatId is marked non-null but is null");
        }
        if (appendable == null) {
            throw new NullPointerException("appendable is marked non-null but is null");
        }
        if (list == null) {
            throw new NullPointerException("list is marked non-null but is null");
        }
        this.getFormatById(formatId).formatProblems(appendable, list);
    }

    public void formatStatus(@NonNull String formatId, @NonNull Appendable appendable, @NonNull List<Scan> list) throws IOException {
        if (formatId == null) {
            throw new NullPointerException("formatId is marked non-null but is null");
        }
        if (appendable == null) {
            throw new NullPointerException("appendable is marked non-null but is null");
        }
        if (list == null) {
            throw new NullPointerException("list is marked non-null but is null");
        }
        this.getFormatById(formatId).formatStatus(appendable, list);
    }

    public void formatResources(@NonNull String formatId, @NonNull Appendable appendable, @NonNull List<Resource> list) throws IOException {
        if (formatId == null) {
            throw new NullPointerException("formatId is marked non-null but is null");
        }
        if (appendable == null) {
            throw new NullPointerException("appendable is marked non-null but is null");
        }
        if (list == null) {
            throw new NullPointerException("list is marked non-null but is null");
        }
        this.getFormatById(formatId).formatResources(appendable, list);
    }

    private URL getBaseURL(Forge forgeOrNull, URL url) {
        return forgeOrNull != null ? forgeOrNull.getProjectURL(url) : URLExtractor.baseOf(url);
    }

    private Optional<Forge> findForge(VersionNode node) {
        return this.forges.stream().filter(forge -> forge.isCompareLink(node.getURL())).findFirst();
    }

    private Format getFormatById(String formatId) throws IOException {
        return this.formats.stream().filter(format -> formatId.equals(FIRST_FORMAT_AVAILABLE) || format.getFormatId().equals(formatId)).findFirst().orElseThrow(() -> new IOException("Cannot find format '" + formatId + "'"));
    }

    private static boolean isNotValidAgainstGuidingPrinciples(Document document) {
        return RuleSupport.problemStreamOf(document, Arrays.asList(GuidingPrinciples.values())).findFirst().isPresent();
    }

    @SafeVarargs
    private static <T> Stream<T> concat(Stream<T> first, Stream<T> ... rest) {
        Stream<T> result = first;
        for (Stream<T> next : rest) {
            result = Stream.concat(result, next);
        }
        return result;
    }

    @Generated
    Heylogs(@NonNull List<Rule> rules, @NonNull List<Format> formats, @NonNull List<Versioning> versionings, @NonNull List<Forge> forges) {
        if (rules == null) {
            throw new NullPointerException("rules is marked non-null but is null");
        }
        if (formats == null) {
            throw new NullPointerException("formats is marked non-null but is null");
        }
        if (versionings == null) {
            throw new NullPointerException("versionings is marked non-null but is null");
        }
        if (forges == null) {
            throw new NullPointerException("forges is marked non-null but is null");
        }
        this.rules = rules;
        this.formats = formats;
        this.versionings = versionings;
        this.forges = forges;
    }

    @Generated
    public static @org.checkerframework.checker.nullness.qual.NonNull Builder builder() {
        return new Builder();
    }

    @Generated
    public @org.checkerframework.checker.nullness.qual.NonNull Builder toBuilder() {
        Builder builder = new Builder();
        if (this.rules != null) {
            builder.rules(this.rules);
        }
        if (this.formats != null) {
            builder.formats(this.formats);
        }
        if (this.versionings != null) {
            builder.versionings(this.versionings);
        }
        if (this.forges != null) {
            builder.forges(this.forges);
        }
        return builder;
    }

    @NonNull
    @Generated
    public List<Rule> getRules() {
        return this.rules;
    }

    @NonNull
    @Generated
    public List<Format> getFormats() {
        return this.formats;
    }

    @NonNull
    @Generated
    public List<Versioning> getVersionings() {
        return this.versionings;
    }

    @NonNull
    @Generated
    public List<Forge> getForges() {
        return this.forges;
    }

    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Heylogs)) {
            return false;
        }
        Heylogs other = (Heylogs)o;
        List<Rule> this$rules = this.getRules();
        List<Rule> other$rules = other.getRules();
        if (this$rules == null ? other$rules != null : !((Object)this$rules).equals(other$rules)) {
            return false;
        }
        List<Format> this$formats = this.getFormats();
        List<Format> other$formats = other.getFormats();
        if (this$formats == null ? other$formats != null : !((Object)this$formats).equals(other$formats)) {
            return false;
        }
        List<Versioning> this$versionings = this.getVersionings();
        List<Versioning> other$versionings = other.getVersionings();
        if (this$versionings == null ? other$versionings != null : !((Object)this$versionings).equals(other$versionings)) {
            return false;
        }
        List<Forge> this$forges = this.getForges();
        List<Forge> other$forges = other.getForges();
        return !(this$forges == null ? other$forges != null : !((Object)this$forges).equals(other$forges));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<Rule> $rules = this.getRules();
        result = result * 59 + ($rules == null ? 43 : ((Object)$rules).hashCode());
        List<Format> $formats = this.getFormats();
        result = result * 59 + ($formats == null ? 43 : ((Object)$formats).hashCode());
        List<Versioning> $versionings = this.getVersionings();
        result = result * 59 + ($versionings == null ? 43 : ((Object)$versionings).hashCode());
        List<Forge> $forges = this.getForges();
        result = result * 59 + ($forges == null ? 43 : ((Object)$forges).hashCode());
        return result;
    }

    @Generated
    public @org.checkerframework.checker.nullness.qual.NonNull String toString() {
        return "Heylogs(rules=" + this.getRules() + ", formats=" + this.getFormats() + ", versionings=" + this.getVersionings() + ", forges=" + this.getForges() + ")";
    }

    @Generated
    public static class Builder {
        @Generated
        private ArrayList<Rule> rules;
        @Generated
        private ArrayList<Format> formats;
        @Generated
        private ArrayList<Versioning> versionings;
        @Generated
        private ArrayList<Forge> forges;

        @Generated
        Builder() {
        }

        @Generated
        public @org.checkerframework.checker.nullness.qual.NonNull Builder rule(Rule rule) {
            if (this.rules == null) {
                this.rules = new ArrayList();
            }
            this.rules.add(rule);
            return this;
        }

        @Generated
        public @org.checkerframework.checker.nullness.qual.NonNull Builder rules(@org.checkerframework.checker.nullness.qual.NonNull Collection<? extends Rule> rules) {
            if (rules == null) {
                throw new NullPointerException("rules cannot be null");
            }
            if (this.rules == null) {
                this.rules = new ArrayList();
            }
            this.rules.addAll(rules);
            return this;
        }

        @Generated
        public @org.checkerframework.checker.nullness.qual.NonNull Builder clearRules() {
            if (this.rules != null) {
                this.rules.clear();
            }
            return this;
        }

        @Generated
        public @org.checkerframework.checker.nullness.qual.NonNull Builder format(Format format) {
            if (this.formats == null) {
                this.formats = new ArrayList();
            }
            this.formats.add(format);
            return this;
        }

        @Generated
        public @org.checkerframework.checker.nullness.qual.NonNull Builder formats(@org.checkerframework.checker.nullness.qual.NonNull Collection<? extends Format> formats) {
            if (formats == null) {
                throw new NullPointerException("formats cannot be null");
            }
            if (this.formats == null) {
                this.formats = new ArrayList();
            }
            this.formats.addAll(formats);
            return this;
        }

        @Generated
        public @org.checkerframework.checker.nullness.qual.NonNull Builder clearFormats() {
            if (this.formats != null) {
                this.formats.clear();
            }
            return this;
        }

        @Generated
        public @org.checkerframework.checker.nullness.qual.NonNull Builder versioning(Versioning versioning) {
            if (this.versionings == null) {
                this.versionings = new ArrayList();
            }
            this.versionings.add(versioning);
            return this;
        }

        @Generated
        public @org.checkerframework.checker.nullness.qual.NonNull Builder versionings(@org.checkerframework.checker.nullness.qual.NonNull Collection<? extends Versioning> versionings) {
            if (versionings == null) {
                throw new NullPointerException("versionings cannot be null");
            }
            if (this.versionings == null) {
                this.versionings = new ArrayList();
            }
            this.versionings.addAll(versionings);
            return this;
        }

        @Generated
        public @org.checkerframework.checker.nullness.qual.NonNull Builder clearVersionings() {
            if (this.versionings != null) {
                this.versionings.clear();
            }
            return this;
        }

        @Generated
        public @org.checkerframework.checker.nullness.qual.NonNull Builder forge(Forge forge) {
            if (this.forges == null) {
                this.forges = new ArrayList();
            }
            this.forges.add(forge);
            return this;
        }

        @Generated
        public @org.checkerframework.checker.nullness.qual.NonNull Builder forges(@org.checkerframework.checker.nullness.qual.NonNull Collection<? extends Forge> forges) {
            if (forges == null) {
                throw new NullPointerException("forges cannot be null");
            }
            if (this.forges == null) {
                this.forges = new ArrayList();
            }
            this.forges.addAll(forges);
            return this;
        }

        @Generated
        public @org.checkerframework.checker.nullness.qual.NonNull Builder clearForges() {
            if (this.forges != null) {
                this.forges.clear();
            }
            return this;
        }

        @Generated
        public @org.checkerframework.checker.nullness.qual.NonNull Heylogs build() {
            List<Forge> forges;
            List<Versioning> versionings;
            List<Format> formats;
            List<Rule> rules;
            switch (this.rules == null ? 0 : this.rules.size()) {
                case 0: {
                    rules = Collections.emptyList();
                    break;
                }
                case 1: {
                    rules = Collections.singletonList(this.rules.get(0));
                    break;
                }
                default: {
                    rules = Collections.unmodifiableList(new ArrayList<Rule>(this.rules));
                }
            }
            switch (this.formats == null ? 0 : this.formats.size()) {
                case 0: {
                    formats = Collections.emptyList();
                    break;
                }
                case 1: {
                    formats = Collections.singletonList(this.formats.get(0));
                    break;
                }
                default: {
                    formats = Collections.unmodifiableList(new ArrayList<Format>(this.formats));
                }
            }
            switch (this.versionings == null ? 0 : this.versionings.size()) {
                case 0: {
                    versionings = Collections.emptyList();
                    break;
                }
                case 1: {
                    versionings = Collections.singletonList(this.versionings.get(0));
                    break;
                }
                default: {
                    versionings = Collections.unmodifiableList(new ArrayList<Versioning>(this.versionings));
                }
            }
            switch (this.forges == null ? 0 : this.forges.size()) {
                case 0: {
                    forges = Collections.emptyList();
                    break;
                }
                case 1: {
                    forges = Collections.singletonList(this.forges.get(0));
                    break;
                }
                default: {
                    forges = Collections.unmodifiableList(new ArrayList<Forge>(this.forges));
                }
            }
            return new Heylogs(rules, formats, versionings, forges);
        }

        @Generated
        public @org.checkerframework.checker.nullness.qual.NonNull String toString() {
            return "Heylogs.Builder(rules=" + this.rules + ", formats=" + this.formats + ", versionings=" + this.versionings + ", forges=" + this.forges + ")";
        }
    }
}

