/*
 * Decompiled with CFR 0.152.
 */
package nbbrd.heylogs;

import com.vladsch.flexmark.util.ast.Node;
import java.util.Iterator;
import java.util.Spliterators;
import java.util.function.Predicate;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import lombok.Generated;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class Nodes<T extends Node> {
    @lombok.NonNull
    private final Class<T> type;

    @lombok.NonNull
    public Stream<T> descendants(@lombok.NonNull Node root) {
        if (root == null) {
            throw new NullPointerException("root is marked non-null but is null");
        }
        return StreamSupport.stream(root.getDescendants().spliterator(), false).filter(this.type::isInstance).map(this.type::cast);
    }

    @lombok.NonNull
    public static Stream<Node> walk(@lombok.NonNull Node root) {
        if (root == null) {
            throw new NullPointerException("root is marked non-null but is null");
        }
        return Stream.concat(Stream.of(root), Nodes.of(Node.class).descendants(root));
    }

    @lombok.NonNull
    public static Stream<Node> next(@lombok.NonNull Node seed, @lombok.NonNull Predicate<Node> hasNext) {
        if (seed == null) {
            throw new NullPointerException("seed is marked non-null but is null");
        }
        if (hasNext == null) {
            throw new NullPointerException("hasNext is marked non-null but is null");
        }
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(Nodes.getNextNodeIterator(seed, hasNext), 64), false);
    }

    private static Iterator<Node> getNextNodeIterator(final Node seed, final Predicate<Node> hasNext) {
        return new Iterator<Node>(){
            Node current;
            {
                this.current = seed;
            }

            @Override
            public boolean hasNext() {
                Node next = this.current.getNext();
                return next != null && hasNext.test(next);
            }

            @Override
            public Node next() {
                this.current = this.current.getNext();
                return this.current;
            }
        };
    }

    @Generated
    private Nodes(@lombok.NonNull Class<T> type) {
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        this.type = type;
    }

    @Generated
    public static <T extends Node> @NonNull Nodes<T> of(@lombok.NonNull Class<T> type) {
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        return new Nodes<T>(type);
    }

    @lombok.NonNull
    @Generated
    public Class<T> getType() {
        return this.type;
    }

    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Nodes)) {
            return false;
        }
        Nodes other = (Nodes)o;
        Class<T> this$type = this.getType();
        Class<T> other$type = other.getType();
        return !(this$type == null ? other$type != null : !this$type.equals(other$type));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Class<T> $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        return result;
    }

    @Generated
    public @NonNull String toString() {
        return "Nodes(type=" + this.getType() + ")";
    }
}

